<% @Language = "VBScript" %>
<%
'============================================================
' MODULE:    edit_events.asp
' APP:           ASPCalendar
' AUTHOR:     www.u229.no
' CREATED:  June 2005
'============================================================
' COMMENT: Edit calendar events.
'============================================================
' ROUTINES:

' - Function GetEvents()
' - Function CreateNewEvent()
' - Function EditEvent()
' - Sub PrintNewEventForm()
' - Sub PrintUpdateEventForm()
'============================================================

On Error Resume Next

%>
<!--#include file="aspcalendar_routines.asp"-->

<html>
<head>
<title>Edit Calendar Events</title>
<link rel="stylesheet" type="text/css" href="html/ASPCalendar.css" />
<script type="text/javascript">
<!--
function verifyFormInput() {
missinginfo = "";
if (document.form1.EventDay.value == "") {
missinginfo += "\n     -  Event Day";
}
if (document.form1.EventMonth.value == "") {
missinginfo += "\n     -  Event Month";
}
if (document.form1.EventTitle.value == "") {
missinginfo += "\n     -  Event Title";
}
if(document.form1.Event.value == "") {
missinginfo += "\n     -  Event Text";
}

if (missinginfo != "") {
missinginfo ="Please fill in these form fields:\n" +
missinginfo + "\n______________________";
alert(missinginfo);
return false;
}
else return true;
}
//-->
</script>
</head>
<body>
<%

Dim m_sNewEventTitle
Dim m_sNewEventText
Dim m_arrEvents
Dim iCounter

'---------------------------- Verify that visitor is autorized
If Not GetCookie Then
    Response.Write "You are not authorized.<br />If you are the site owner and this is your first visit here after installation, you must open the file start.asp in your browser. This will set a cookie on your computer which will authorize you. Make sure your browser accepts cookies from this domain.<br />After this is done you are strongly advised to rename start.asp. This is for security reasons. Be aware that if someone can open this file he will be able to manipulate your events."
    Response.End
End If

Select Case Request.QueryString("a")

		Case "n"    '// Create new event?
				Call CreateNewEvent
				Call GetEvents
				Call PrintNewEventForm
				Call CreateCalendar

		Case "u", "d"    '// Update or delete existing event?
				Call EditEvent
				Call GetEvents
				Call PrintNewEventForm
				Call CreateCalendar

		Case "e"    '// Print the update form
				Call PrintUpdateEventForm

		Case Else   '// Default
				Call GetEvents
				Call PrintNewEventForm

End Select

%>
</body>
</html>
<%

'------------------------------------------------------------------------------------------------------------
' Comment: List all events.
'------------------------------------------------------------------------------------------------------------
Function GetEvents()
    On Error Resume Next

		Dim oEvent
		Dim bSuccess

		If IsEmpty(oEvent) Then Set oEvent = New cEvents

		With oEvent
				.PathToDatabase = Server.MapPath(PATH_TO_DATABASE)
				.DatabaseType = DATABASE_TYPE
				bSuccess = .ListAllEvents
'        If Not bSuccess Then Response.Write .ErrorMessage
		End With

		Set oEvent = Nothing

		GetEvents = bSuccess

		End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Create event.
'------------------------------------------------------------------------------------------------------------
		Function CreateNewEvent()
		On Error Resume Next

		Dim oEvent
		Dim bSuccess

		If IsEmpty(oEvent) Then Set oEvent = New cEvents

		With oEvent
				.PathToDatabase = Server.MapPath(PATH_TO_DATABASE)
				.DatabaseType = DATABASE_TYPE
				bSuccess = .CreateNewEvent
'        If Not bSuccess Then Response.Write .ErrorMessage
		End With

		Set oEvent = Nothing

		CreateNewEvent = bSuccess

		End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Edit or delete existing event.
'------------------------------------------------------------------------------------------------------------
		Function EditEvent()
		On Error Resume Next

		Dim oEvent
		Dim bSuccess

		If IsEmpty(oEvent) Then Set oEvent = New cEvents

		With oEvent
				.PathToDatabase = Server.MapPath(PATH_TO_DATABASE)
				.DatabaseType = DATABASE_TYPE
				.EventID = Request.QueryString("id")
				bSuccess = .EditEvent
'        If Not bSuccess Then Response.Write .ErrorMessage
		End With

		Set oEvent = Nothing

		EditEvent = bSuccess

		End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Create new event form.
'------------------------------------------------------------------------------------------------------------
Sub PrintNewEventForm()
    On Error Resume Next
%>
<h3>Create New Event</h3>

<form method="post" action="edit_events.asp?a=n" name="form1" onSubmit="return verifyFormInput();">
<table cellpadding="0" cellspacing="0" border="0" id="event_list_new">
  <tr><th scope="row" abbr="month">month</th><td><input type="text" maxlength="2" name="EventMonth" class="narrowbox" /></td></tr>
  <tr><th scope="row" abbr="day">day</th><td><input type="text" maxlength="2" name="EventDay" class="narrowbox" /></td></tr>
  <tr><th scope="row" abbr="title">title</th><td><input type="text" name="EventTitle" class="widebox" /></td></tr>
  <tr><th scope="row" abbr="event">event</th><td><textarea name="Event" rows="6" cols="12"></textarea></td></tr>
  <tr><th scope="row" abbr="submit">submit</th><td><input type="submit" value="Submit" /> </td></tr>
</table>
</form>

<p align="center"><a href="javascript:window.close();">Close Window</a></p>
<%
End Sub

'------------------------------------------------------------------------------------------------------------
' Comment: Print out the update event form
'------------------------------------------------------------------------------------------------------------
		Sub PrintUpdateEventForm()
		On Error Resume Next

		Dim oEvent
		Dim bSuccess

		If IsEmpty(oEvent) Then Set oEvent = New cEvents

		With oEvent
				.PathToDatabase = Server.MapPath(PATH_TO_DATABASE)
				.DatabaseType = DATABASE_TYPE
				.EventID = Request.QueryString("id")
				bSuccess = .GetSingleEvent
'        If Not bSuccess Then Response.Write .ErrorMessage
		End With

		Set oEvent = Nothing

		End Sub
%>