<%
'============================================================
' MODULE:     cEvents.asp
' APP:            ASPCalendar
' AUTHOR:      www.u229.no
' CREATED:   June 2005
'============================================================
' COMMENT:
' - This class creates and edits calendar events. The events will be saved to database and
'    also saved as html. This html file is then cached to an application variable.
'============================================================
' TODO:
'============================================================
' ROUTINES:

' - Public Property Let PathToDatabase(s)
' - Public Property Let DatabaseType(s)
' - Public Property Let EventID(i)
' - Public Property Get ErrorMessage()

' - Private Sub Class_Initialize()
' - Private Sub Class_Terminate()
' - Public Function ListAllEvents()
' - Public Function CreateNewEvent()
' - Public Function EditEvent()
' - Public Function GetSingleEvent()
' - Public Function DeleteOldEvents()
' - Private Function VerifyUserData()
' - Private Function CreateEventsFile()
' - Private Function SQL_GetEvents()
' - Private Function SQL_GetSingleEvent()
' - Private Function SQL_NewEvent()
' - Private Function SQL_UpdateEvent()
' - Private Function SQL_DeleteEvent()
' - Private Function SQL_DeleteOldEvents()
'============================================================



'============================================================
Class cEvents
'============================================================


'// MODULE VARIABLES
Private m_sPathToDatabase        '// Path to database
Private m_sDatabaseType           '// Type of database
Private m_iEventID                    '// Which event to update/delete
Private m_iEventDay                  '// Day
Private m_iEventMonth               '// Month
Private m_sEventTitle                 '// Title
Private m_sEventText                 '// Text
Private m_oADO                         '// ADO Connection Object
Private m_oRs                            '// Recordset Object containing event dates


'// MODULE PROPERTIES
Public Property Let PathToDatabase(s)
    m_sPathToDatabase = s
End Property

Public Property Let DatabaseType(s)
    m_sDatabaseType = s
End Property

Public Property Let EventID(i)
    m_iEventID = i
End Property

Public Property Get ErrorMessage()
    ErrorMessage = m_sErrMessage
End Property

'------------------------------------------------------------------------------------------------------------
' Comment: Init some module variables.
'------------------------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
    On Error Resume Next

    If IsEmpty(m_oADO) Then Set m_oADO = New cADO
    If IsEmpty(m_oRs) Then Set m_oRs = Server.CreateObject("ADODB.Recordset")

    m_sPathToDatabase = ""
    m_sDatabaseType = ""
    m_sErrMessage = ""
    m_iEventDay = Request.Form("EventDay")
    m_iEventMonth = Request.Form("EventMonth")
    m_sEventTitle = Request.Form("EventTitle")
    m_sEventText = Request.Form("Event")

End Sub

'--------------------------------------------------------------------------------------------------------
' Comment: Make sure ADO objects are dead before we leave.
'--------------------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
    On Error Resume Next
    
    m_oRs.Close
    Set m_oRs = Nothing
    Set m_oADO = Nothing

    Err.Clear

End Sub

'------------------------------------------------------------------------------------------------------------
' Comment: Transfer events from recordset to array. More looping, but easy to implement.
'------------------------------------------------------------------------------------------------------------
Public Function ListAllEvents()
    On Error Resume Next

    Dim arrEvents
    Dim i, iLow

    '---------------------------- Verify user data
    
    If Len(m_sPathToDatabase) = 0 Then m_sErrMessage = "Missing parameter: Database path": Exit Function

    %>
    <h3>Listing All Events</h3>

    <table width="100%" border="0" cellpadding="0" cellspacing="0" id="event_list">
    <tr>
    <th scope="col" abbr="month">month</th>
    <th scope="col" abbr="day">day</th>
    <th scope="col" abbr="title">title</th>
    <th scope="col" abbr="event">event</th>
    <th scope="col" abbr="edit">edit</th>
    </tr>
    <%

    With m_oADO
        .DatabaseType = m_sDatabaseType
        .PathToDatabase = m_sPathToDatabase
        arrEvents = .ExecuteSQL(SQL_GetEvents, 1)
    End With

    If Not IsSafeArray(arrEvents) Then Response.Write "</table>": Exit Function
    On Error Resume Next

    iLow = LBound(arrEvents)

    For i = iLow To UBound(arrEvents, 2)
        Response.Write "<tr><td align=""center"">" & arrEvents(2, i) & "&nbsp;</td>"
        Response.Write "<td align=""center"">" & arrEvents(1, i) & "&nbsp;</td>"
        Response.Write "<td align=""left"">" & ToHTML(LimitTextLength(arrEvents(3, i), 50, Chr(32), " ..")) & "&nbsp;</td>"
        Response.Write "<td align=""left"">" & ToHTML(LimitTextLength(arrEvents(4, i), 50, Chr(32), " ..")) & "&nbsp;</td>"
        Response.Write "<td align=""center""><a href=""edit_events.asp?a=e&id=" & arrEvents(0, i) _
                        & """>Edit</a> | " & "<a href=""edit_events.asp?a=d&id=" & arrEvents(0, i) & """>Delete</a></td></tr>"
    Next

    Response.Write "</table>"

    ListAllEvents = (Err.Number = 0)

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Create a new event.
'------------------------------------------------------------------------------------------------------------
Public Function CreateNewEvent()
    On Error Resume Next

'---------------------------- Verify user data

    If Not VerifyUserData Then m_sErrMessage = "Invalid user data": Exit Function
    If Len(m_sPathToDatabase) = 0 Then m_sErrMessage = "Missing parameter: Database path": Exit Function

    With m_oADO
        .DatabaseType = m_sDatabaseType
        .PathToDatabase = m_sPathToDatabase
        CreateNewEvent = .ExecuteSQL(SQL_NewEvent, 4)
    End With

'---------------------------- Create a new events.html
    Call CreateEventsFile

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Update or delete an event.
'------------------------------------------------------------------------------------------------------------
Public Function EditEvent()
    On Error Resume Next

    If IsEmpty(m_iEventID) Then m_sErrMessage = "Missing parameter: ID for event": Exit Function

    With m_oADO
        .DatabaseType = m_sDatabaseType
        .PathToDatabase = m_sPathToDatabase

        Select Case Request.QueryString("a")

            Case "u"

                If Not VerifyUserData Then m_sErrMessage = "Invalid user data": Exit Function
                EditEvent = .ExecuteSQL(SQL_UpdateEvent, 4)

            Case "d"
                EditEvent = .ExecuteSQL(SQL_DeleteEvent, 4)

            Case Else
                m_sErrMessage = "Missing parameter: Action for editing event": Exit Function

        End Select

    End With

'---------------------------- Create a new events.html
    Call CreateEventsFile

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Return data for a single event.
'------------------------------------------------------------------------------------------------------------
Public Function GetSingleEvent()
    On Error Resume Next

    Dim sEvent
    Dim arrEvent

    If IsEmpty(m_iEventID) Then m_sErrMessage = "Missing parameter: ID for event": Exit Function

    With m_oADO
        .DatabaseType = m_sDatabaseType
        .PathToDatabase = m_sPathToDatabase
        sEvent = .ExecuteSQL(SQL_GetSingleEvent, 3)
    End With

    If Not InStr(sEvent, vbTab) > 0 Then m_sErrMessage = "Missing delimiter in returned record string": Exit Function
    arrEvent = Split(sEvent, vbTab)

    If UBound(arrEvent) <> 4 Then m_sErrMessage = "Error in returned data": Exit Function

    %>
    <h3>Update Event</h3>

    <form method="post" action="edit_events.asp?a=u&id=<%=m_iEventID%>" name="form1" onSubmit="return verifyFormInput();">
    <table cellpadding="0" cellspacing="0" border="0" id="event_list_new">
    <tr><th scope="row" abbr="month">month</th>
    <td><input type="text" maxlength="2" name="EventMonth" class="narrowbox" value="<%=arrEvent(1)%>" /></td></tr>
    <tr><th scope="row" abbr="day">day</th>
    <td><input type="text" maxlength="2" name="EventDay" class="narrowbox" value="<%=arrEvent(2)%>" /></td></tr>
    <tr><th scope="row" abbr="title">title</th>
    <td><input type="text" name="EventTitle" class="widebox" value="<%=arrEvent(3)%>" /></td></tr>
    <tr><th scope="row" abbr="event">event</th>
    <td><textarea name="Event" rows="6" cols="12"><%=arrEvent(4)%></textarea></td></tr>
    <tr><th scope="row" abbr="submit">submit</th><td><input type="submit" value="Submit" /></td></tr>
    </table>
    </form>

    <p align="center"><a href="javascript:window.close();">Close Window</a></p>
    <%

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Delete events older than 1 month, if any.
'------------------------------------------------------------------------------------------------------------
Public Function DeleteOldEvents()
    On Error Resume Next

    With m_oADO
        .DatabaseType = m_sDatabaseType
        .PathToDatabase = m_sPathToDatabase
        DeleteOldEvents = .ExecuteSQL(SQL_DeleteOldEvents, 4)
    End With

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Make sure all form fields are filled in and day and month are numeric.
'------------------------------------------------------------------------------------------------------------
Private Function VerifyUserData()
    On Error Resume Next

    If Not (IsEmpty(m_iEventDay) Or IsEmpty(m_iEventMonth) Or IsEmpty(m_sEventTitle) Or IsEmpty(m_sEventText)) Then
        VerifyUserData = True
        Exit Function
    End If

    If (IsNumeric(m_iEventDay) And IsNumeric(m_iEventMonth)) Then
        If (m_iEventDay > 0 And m_iEventDay < 32) And (m_iEventMonth > 0 And m_iEventMonth < 13) Then
            VerifyUserData = True
        End If
    End If

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: After editing an event or creating a new we create a new events.html.
'------------------------------------------------------------------------------------------------------------
Private Function CreateEventsFile()
    On Error Resume Next

    Dim arrEvents
    Dim i, iLow
    Dim sHtml

    With m_oADO
        .DatabaseType = m_sDatabaseType
        .PathToDatabase = m_sPathToDatabase
        arrEvents = .ExecuteSQL(SQL_GetEvents, 1)
    End With

    If Not IsSafeArray(arrEvents) Then m_sErrMessage = "No events returned from database": Exit Function
    On Error Resume Next
    iLow = LBound(arrEvents)

    sHtml = "<!DOCTYPE html PUBLIC ""-//W3C//DTD XHTML 1.0 Transitional//EN"" ""http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"">"
    sHtml = (sHtml & "<html xmlns=""http://www.w3.org/1999/xhtml""><head><title>Calendar Events</title>")
    sHtml = (sHtml & "<link rel=""stylesheet"" type=""text/css"" href=""../html/ASPCalendar.css"" />")
    sHtml = (sHtml & "</head><body><h3 class=""events_page_title"">Events</h3>")

    For i = iLow To UBound(arrEvents, 2)
        sHtml = (sHtml & "<div id=""event"">")
        sHtml = (sHtml & "<span class=""event_date""><a name=""" & arrEvents(2, i) & "_" & arrEvents(1, i) & """></a>")
        sHtml = (sHtml & FormatDateTime(DateSerial(Year(Date), arrEvents(2, i), arrEvents(1, i)), 2) & "</span>")
        sHtml = (sHtml & "<span class=""event_title"">" & ToHTML(arrEvents(3, i)) & "</span>")
        sHtml = (sHtml & "<div id=""event_text"">" & ToHTML(arrEvents(4, i)) & "</div></div>")
    Next

    sHtml = (sHtml & "<p align=""center""><a href=""javascript:window.close();"">Close Window</a></p></body></html>")
    sHtml = CleanUpLineBreaks(sHtml, "<br />")

    CreateEventsFile = CreateFile(Server.MapPath(PATH_TO_EVENTSFILE), sHtml, True)   '// Save events as html

End Function



'============================================================
' SQL:
'============================================================


'------------------------------------------------------------------------------------------------------------
' Comment: Build the SQL for getting the events.
'------------------------------------------------------------------------------------------------------------
Private Function SQL_GetEvents()
    On Error Resume Next
    
    SQL_GetEvents = "SELECT" & _
                              " id," & _
                              " event_day," & _
                              " event_month," & _
                              " event_title," & _
                              " event_text" & _
                              " FROM Events" & _
                              " WHERE (event_month = " & ToSQL(Month(Date), "Number", False) & _
                              " OR " & ToSQL(Month(Date) + 1, "Number", False) & ")" & _
                              " ORDER BY event_month, event_day ASC"

End Function


'------------------------------------------------------------------------------------------------------------
' Comment: Build the SQL for getting single event.
'------------------------------------------------------------------------------------------------------------
Private Function SQL_GetSingleEvent()
    On Error Resume Next

    SQL_GetSingleEvent = "SELECT * FROM Events WHERE (id = " & ToSQL(m_iEventID, "Number", False) & ")"

End Function


'------------------------------------------------------------------------------------------------------------
' Comment: SQL for a new event.
'------------------------------------------------------------------------------------------------------------
Private Function SQL_NewEvent()
    On Error Resume Next

    SQL_NewEvent = "INSERT INTO Events (" & _
                              "[event_day]," & _
                              "[event_month]," & _
                              "[event_title]," & _
                              "[event_text])" & _
                              " VALUES (" & _
                              ToSQL(Request.Form("EventDay"), "Number", False) & "," & _
                              ToSQL(Request.Form("EventMonth"), "Number", False) & "," & _
                              ToSQL(Request.Form("EventTitle"), "Text", True) & "," & _
                              ToSQL(Request.Form("Event"), "Text", False) & ")"

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Build the SQL for updating existing event.
'------------------------------------------------------------------------------------------------------------
Private Function SQL_UpdateEvent()
    On Error Resume Next

    SQL_UpdateEvent = "UPDATE Events SET " & _
                                  "[event_day]=" & ToSQL(Request.Form("EventDay"), "Number", False) & _
                                  ",[event_month]=" & ToSQL(Request.Form("EventMonth"), "Number", False) & _
                                  ",[event_title]=" & ToSQL(Request.Form("EventTitle"), "Text", True) & _
                                  ",[event_text]=" & ToSQL(Request.Form("Event"), "Text", False) & _
                                  " WHERE (id = " & ToSQL(m_iEventID, "Number", False) & ")"

End Function


'------------------------------------------------------------------------------------------------------------
' Comment: Build the SQL for deleting single event.
'------------------------------------------------------------------------------------------------------------
Private Function SQL_DeleteEvent()
    On Error Resume Next

    SQL_DeleteEvent = "DELETE FROM Events" & _
                                 " WHERE (id = " & ToSQL(m_iEventID, "Number", False) & ")"

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: SQL for deleting records older than 1 month.
'------------------------------------------------------------------------------------------------------------
Private Function SQL_DeleteOldEvents()
    On Error Resume Next

    SQL_DeleteOldEvents = "DELETE FROM Events" & _
                                       " WHERE (event_month <= " & _
                                       ToSQL(DatePart("m", DateSerial(Year(Date), Month(Date) - 1, Day(Date)), _
                                       FIRST_DAY_OF_WEEK, _
                                       FIRST_WEEK_OF_YEAR), "Number", False) & ")"

End Function

'============================================================
End Class
'============================================================
%>