<%
'============================================================
' MODULE:     cCalendar.asp
' APP:            ASPCalendar
' AUTHOR:      www.u229.no
' CREATED:   June 2005
' MODIFIED:  Nov 2005
'============================================================
' COMMENT: This class produces two calendars, for current month and for next month.
'                  The calendar is saved to an application variable and to a html file.
'============================================================
' ROUTINES:

' - Public Property Let OneOrTwo(i)
' - Public Property Let PathToDatabase(s)
' - Public Property Let DatabaseType(s)
' - Public Property Let PathToCalendar(s)
' - Public Property Let PathToEventsFile(s)
' - Public Property Let OpenWindow(i)
' - Public Property Get ErrorMessage()

' - Private Sub Class_Initialize()
' - Private Sub Class_Terminate()
' - Public Function PrintCalendar()
' - Private Function BuildCalendar(iMonth)
' - Private Sub PrintDayNumber(iDay, iMonth)
' - Private Function PrintEventDay(iDay, iMonth, arrEvents)
' - Private Sub SetWeekDayLetters()
' - Private Sub GetEvents()
' - Private Sub SetModuleValues()
' - Private Function SQL_GetEvents(iMonth)
' - Private Function DaysInAnyMonth(iMonth, iYear)
'============================================================


'============================================================
Class cCalendar
'============================================================

'// MODULE VARIABLES
Private m_lngOneOrTwo               '// Are we asked to create and display one or two calendars?
Private m_sPathToCalendar          '// Path to calendar.html
Private m_sPathToDatabase          '// Path to db
Private m_sDatabaseType            '// Type of database
Private m_sPathToEventsFile         '// Path to the events.html
Private m_lngEventsWindow         '// How should the events file be shown: 1) New browser window 2) Pop up window
Private m_iThisDay                      '// Number of current day: 1 etc
Private m_iThisWeekDay              '// Number of weekday: 1 etc
Private m_sThisWeekDayName     '// Name of weekday: Sunday etc
Private m_iThisMonth                   '// Month number: 1 etc
Private m_iNextMonth
Private m_sThisMonthName          '// Name of month: January etc
Private m_sNextMonthName
Private m_iThisYear                     '// DatePart Year
Private m_iNextYear
Private m_iDaysThisMonth            '// Number of days in month
Private m_iDaysNextMonth
Private m_iFirstDayThisMonth        '// Weekday of the 1 th day
Private m_iFirstDayNextMonth
Private m_arrEventsThis()            '// Dates with Events
Private m_arrEventsNext()
Private m_arrWeekDayLetters(6)   '// Array contains first letter of day
Private m_iFirstDayOfWeek           '// 0 = System 1 = Sunday 2 = Monday etc
Private m_sCalendar                     '// Our Calendar(s)
Private m_i                                   '// Module counter for the event arrays
Private m_sErrMessage                 '// Return a human readable error message
Private m_oADO                           '// Reference to the cADO class
Private m_oRs                              '// Recordset Object containing event dates


'// MODULE PROPERTIES
Public Property Let OneOrTwo(i)
    On Error Resume Next
    
    If Len(i) = 0 Or Not IsNumeric(i) Then Exit Property
    m_lngOneOrTwo = CLng(i)
End Property

Public Property Let PathToDatabase(s)
    m_sPathToDatabase = s
End Property

Public Property Let DatabaseType(s)
    m_sDatabaseType = s
End Property

Public Property Let PathToCalendar(s)
    m_sPathToCalendar = s
End Property

Public Property Let PathToEventsFile(s)
    m_sPathToEventsFile = s
End Property

Public Property Let EventsWindow(i)
    On Error Resume Next
    
    If Len(i) = 0 Or Not IsNumeric(i) Then Exit Property
    m_lngEventsWindow = CLng(i)
End Property

Public Property Let FirstDayOfWeek(i)
    On Error Resume Next
    
    If Len(i) = 0 Or Not IsNumeric(i) Then Exit Property
    m_iFirstDayOfWeek = CLng(i)
End Property

Public Property Get ErrorMessage()
    ErrorMessage = m_sErrMessage
End Property


'------------------------------------------------------------------------------------------------------------
' Comment: Init some module variables.
'------------------------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
    On Error Resume Next

    If IsEmpty(m_oADO) Then Set m_oADO = New cADO
    If IsEmpty(m_oRs) Then Set m_oRs = Server.CreateObject("ADODB.Recordset")
   
    '// Default: create two calendars
    m_lngOneOrTwo = 2
    '// Default: display events.html in pop up window
    m_lngEventsWindow = 2
    '// 0 = System 1 = Sunday 2 = Monday etc
    m_iFirstDayOfWeek = 0

End Sub

'--------------------------------------------------------------------------------------------------------
' Comment: Make sure ADO objects are dead before we leave.
'--------------------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
    On Error Resume Next
    
    m_oRs.Close
    Set m_oRs = Nothing
    Set m_oADO = Nothing

    Err.Clear

End Sub

'------------------------------------------------------------------------------------------------------------
' Comment: The only public function called by the user.
'------------------------------------------------------------------------------------------------------------
Public Function PrintCalendar()
    On Error Resume Next

    Dim bSuccess

    If Len(m_sPathToDatabase) = 0 Then m_sErrMessage = "Missing parameter: Database path": Exit Function
    If Len(m_sPathToCalendar) = 0 Then m_sErrMessage = "Missing parameter: Calendar path": Exit Function
    If Len(m_sPathToEventsFile) = 0 Then m_sErrMessage = "Missing parameter: Path to events file": Exit Function

    Call SetModuleValues                                                                         '// Set all the various module date variables
    Call SetWeekDayLetters                                                                     '// Set all the weekday letters
    Call GetEvents(m_iThisMonth, m_arrEventsThis)                             '// Get events for this month from DB ..
    Call GetEvents(m_iNextMonth, m_arrEventsNext)                            '// .. and the Events for next month

    m_sCalendar = "<div id=""calendar_frame"">"
    bSuccess = BuildCalendar(1, m_arrEventsThis)                                '// Build calendar html for this month ..
    If m_lngOneOrTwo = 2 Then bSuccess = BuildCalendar(2, m_arrEventsNext)        '// .. and for next month.

    m_sCalendar = (m_sCalendar & "</div>")

    PrintCalendar = CreateFile(m_sPathToCalendar, m_sCalendar, True)   '// Save calendar as html\calendar.html

    Application("ASP_CALENDAR") = ReadFile(m_sPathToCalendar)           '// Cache the calendar in an application variable
    Application("ASP_CALENDAR_CURRENT_DAY") = m_iThisDay                '// Cache current day.
    Application("ASP_CALENDAR_CURRENT_MONTH") = m_iThisMonth        '// Cache current month

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Build the html for our calendar.
'------------------------------------------------------------------------------------------------------------
Private Function BuildCalendar(iMonth, arrEvents)
    On Error Resume Next

    Dim iFirstDayOfMonth
    Dim iDaysInMonth
    Dim sMonthName
    Dim iYear
    Dim iCell, iDay, iCellCount, iMax
		
		iMax = 35    '// 5x7 cells
    iDay = 1
    m_i = 0

'---------------------------- This month or next?
    Select Case iMonth

        Case 1    '// This Month

            iFirstDayOfMonth = m_iFirstDayThisMonth
            iDaysInMonth = m_iDaysThisMonth
            sMonthName = m_sThisMonthName
            iYear = m_iThisYear

        Case 2    '// Next Month

            iFirstDayOfMonth = m_iFirstDayNextMonth
            iDaysInMonth = m_iDaysNextMonth
            sMonthName = m_sNextMonthName
            iYear = m_iNextYear

        Case Else
    End Select

'---------------------------- Start building the table/calendar headings
    If iMonth = 2 Then

        m_sCalendar = (m_sCalendar & "<p class=""view_next_link""><a href=""javascript:toggleLayer('showhide');"" title=""View next month"">")
        m_sCalendar = (m_sCalendar & "View " & m_sNextMonthName & "</a></p>")
        m_sCalendar = (m_sCalendar & "<div id=""showhide"">")
        m_sCalendar = (m_sCalendar & "<table border=""0"" id=""calendar_next"" cellspacing=""0"" cellpadding=""0"">")
        m_sCalendar = (m_sCalendar & "<tr><td colspan=""7"" class=""cal_month"">" & sMonthName & "&nbsp;" & iYear & "</td></tr><tr>")

    Else
        
        '// Calendar this month
        m_sCalendar = (m_sCalendar & "<table border=""0"" id=""calendar_current"" cellspacing=""0"" cellpadding=""0"">")
        m_sCalendar = (m_sCalendar & "<tr><td  colspan=""7"" class=""cal_month"">" & sMonthName & "&nbsp;" & iYear & "</td></tr><tr>")

    End If

'---------------------------- Print the Weekday Labels
    For iCell = 0 To 6
        m_sCalendar = (m_sCalendar & "<td class=""cal_weekday_label"">" & LCase(m_arrWeekDayLetters(iCell)) & "</td>")
    Next
    
    m_sCalendar = (m_sCalendar & "</tr>")

'---------------------------- Start looping the 7 cells
    For iCellCount = 1 To iMax
'----------------------------
				
				If iCellCount Mod 7 = 1 Then m_sCalendar = (m_sCalendar & "<tr>")

        If iCellCount < iFirstDayOfMonth Then
				    m_sCalendar = (m_sCalendar & "<td class=""cal_blanks"">&nbsp;</td>")
				Else
				    If Not PrintEventDay(iDay, iMonth, arrEvents) Then Call PrintDayNumber(iDay, iMonth)
						iDay = (iDay + 1)
				End If
				
				If iCellCount Mod 7 = 0 Then
				    m_sCalendar = (m_sCalendar & "</tr>")
						'// What if there are only 28 days in this month and day 1 is on cell 1?
						If (iDaysInMonth = 28 And iFirstDayOfMonth = 1) And iCellCount = 28 Then Exit For
				End If

        If (iCellCount - (iFirstDayOfMonth - 1))  => iDaysInMonth Then
				    iCell = iCellCount

						Do While iCell < iMax
								m_sCalendar = (m_sCalendar & "<td class=""cal_blanks"">&nbsp;</td>")
								iCell = iCell + 1
						Loop

						Exit For
        End If

'----------------------------
    Next
'----------------------------

    If iMonth = 1 Then m_sCalendar = (m_sCalendar & "</tr></table>")
    If iMonth = 2 Then m_sCalendar = (m_sCalendar & "</table></div>")

    BuildCalendar = (Err.Number = 0)

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Printing the day numbers.
'------------------------------------------------------------------------------------------------------------
Private Sub PrintDayNumber(iDay, iMonth)
    On Error Resume Next

    If (iDay = m_iThisDay) And iMonth = 1 Then 
        m_sCalendar = (m_sCalendar & "<td class=""cal_today"">" & iDay & "</td>")
    Else
        m_sCalendar = (m_sCalendar & "<td class=""cal_day"">" & iDay & "</td>")
    End If

End Sub

'------------------------------------------------------------------------------------------------------------
' Comment: Compare day in event array with current day in month.
'------------------------------------------------------------------------------------------------------------
Private Function PrintEventDay(iDay, iMonth, arrEvents)
    On Error Resume Next

    Dim sEventDayCss
    Dim sCurMonth

    If Not IsSafeArray(arrEvents) Then Exit Function
    If m_i > UBound(arrEvents) Then Exit Function

    If iMonth = 1 Then sCurMonth = m_iThisMonth
    If iMonth = 2 Then sCurMonth = m_iNextMonth

    sEventDayCss = "class=""cal_eventday"""

    If (iDay = m_iThisDay) And iMonth = 1 Then sEventDayCss = "class=""cal_today"""

    If iDay = arrEvents(m_i) Then

        Select Case m_lngEventsWindow

            Case 1    '// New browser window
                m_sCalendar = (m_sCalendar & "<td " & sEventDayCss & _
                                "><a href=""html/events.html#" & sCurMonth & "_" & iDay & _
                                " "" title=""View Event"" target=""_blank"">" & iDay & "</a></td>")

            Case 2    '// Pop up window
                m_sCalendar = (m_sCalendar & "<td " & sEventDayCss & _
                                "><a href=""javascript:pop('html/events.html#" & sCurMonth & "_" _
                                & iDay & "','ASPCalendar',490,440);"" title=""View Event"">" & iDay & "</a></td>")

            Case Else
        End Select
            
        m_i = (m_i + 1)
        PrintEventDay = True

    End If

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Create array with all week letters.
'------------------------------------------------------------------------------------------------------------
Private Sub SetWeekDayLetters()
    On Error Resume Next

    Dim i, j

    j = 1

    For i = 0 To 6
        '// We only need the first letter of the weekday name
        m_arrWeekDayLetters(i) = Left(WeekdayName(j, False, m_iFirstDayOfWeek), 1)
        j = (j + 1)
    Next

End Sub

'------------------------------------------------------------------------------------------------------------
' Comment: Transfer events from recordset to array. More looping, but easy to implement.
'------------------------------------------------------------------------------------------------------------
Private Sub GetEvents(iMonth, arrEvents)
    On Error Resume Next

    Dim iCounter

    iCounter = 0

    With m_oADO
        .DatabaseType = m_sDatabaseType
        .PathToDatabase = m_sPathToDatabase
        '// Return a recordset object
        Set m_oRs = .ExecuteSQL(SQL_GetEvents(iMonth), 2)
    End With

    If IsEmpty(m_oRs) Or m_oRs.EOF Then m_sErrMessage = "No events found.": Exit Sub

		Do While Not m_oRs.EOF

				ReDim Preserve arrEvents(iCounter)
				arrEvents(iCounter) = GetValue(m_oRs, "event_day")
				iCounter = (iCounter + 1)

				m_oRs.MoveNext
		Loop

End Sub

'------------------------------------------------------------------------------------------------------------
' Comment: Set a bunch of module date variables.
'------------------------------------------------------------------------------------------------------------
Private Sub SetModuleValues()
    On Error Resume Next

    Dim dtNextDate

    m_iThisDay = Day(Date)
    m_iThisWeekDay = Weekday(Date, m_iFirstDayOfWeek)
    m_sThisWeekDayName = WeekdayName(m_iThisWeekDay, False, m_iFirstDayOfWeek)
    m_iThisMonth = Month(Date)
    m_sThisMonthName = MonthName(m_iThisMonth)
    m_iThisYear = Year(Date)
    m_iDaysThisMonth = DaysInAnyMonth(m_iThisMonth, m_iThisYear)
    m_iFirstDayThisMonth = Weekday(CDate(DateSerial(Year(Date), Month(Date), 1)), m_iFirstDayOfWeek)
    
    '// Next Month
    dtNextDate = CDate(DateSerial(Year(Date), Month(Date) + 1, 1))

    m_iNextMonth = Month(dtNextDate)
    m_sNextMonthName = MonthName(m_iNextMonth)
    m_iNextYear = Year(dtNextDate)
    m_iFirstDayNextMonth = Weekday(dtNextDate, m_iFirstDayOfWeek)

    If m_iThisMonth < 12 Then
        m_iDaysNextMonth = DaysInAnyMonth(m_iThisMonth + 1, m_iThisYear)
    Else
        m_iDaysNextMonth = DaysInAnyMonth(1, m_iThisYear + 1)
    End If

End Sub

'------------------------------------------------------------------------------------------------------------
' Comment: Build the SQL for getting the events.
'------------------------------------------------------------------------------------------------------------
Private Function SQL_GetEvents(iMonth)
    On Error Resume Next

    SQL_GetEvents = "SELECT DISTINCT" & _
                              " event_day" & _
                              " FROM Events" & _
                              " WHERE (event_month = " & ToSQL(iMonth, "Number", False) & ")" & _
                              " ORDER BY event_day ASC"

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Calculate number of days in month, even in leap year.
'------------------------------------------------------------------------------------------------------------
Private Function DaysInAnyMonth(iMonth, iYear)
    On Error Resume Next

    Select Case (iMonth)

        Case 4, 6, 9, 11
            DaysInAnyMonth = 30

        Case 2

            If ((iYear Mod 4 = 0) And (iYear Mod 100 <> 0)) Or (iYear Mod 400 = 0) Then
                DaysInAnyMonth = 29
            Else
                DaysInAnyMonth = 28
            End If

        Case Else
            DaysInAnyMonth = 31
    End Select

End Function

'============================================================
End Class
'============================================================
%>