<%
'============================================================
' MODULE:     aspcalendar_routines.asp
' APP:            ASPCalendar
' AUTHOR:      www.u229.no
' CREATED:   June 2005
' MODIFIED: Nov 2005
'============================================================
' COMMENT: Common  routines used by cCalendar.asp, cEvents.asp and edit_events.asp.
'                 Edit the first constants if you dont want the default settings.
'============================================================
' ROUTINES:

' - Function ShowCalendar()
' - Function CreateCalendar()
' - Function DeleteOldEvents()
' - Function IsSafeArray(arr)
' - Function CreateFile(sFullPath, sTxt, bOverWrite)
' - Function ReadFile(sFilePath)
' - Function GetCookie()
' - Function LimitTextLength(Txt, Max, Delimeter, Tail)
' - Function ToSQL(Val, Mode, b255)
' - Function GetValue(oRs, sFieldName)
' - Function ToHTML(sTxt)
'============================================================

%>
<!--#include file="cCalendar.asp"-->
<!--#include file="cADO.asp"-->
<!--#include file="cEvents.asp"-->
<%

'============================================================
' SET THESE VALUES TO MATCH YOUR OWN WEB SERVER:
'============================================================
Const PATH_TO_DATABASE = "db/asp_calendar.mdb"     '// The file ending is set to asp just to secure the database.
Const DATABASE_TYPE = "Access"                                       '// This app uses the cADO class. This class only supports Access.
Const PATH_TO_CALENDAR = "html/calendar.html"
Const PATH_TO_EVENTSFILE = "html/events.html"
Const CREATE_ONE_OR_TWO_CALENDARS = 2
'// 0=System. 1=Sunday. 2=Monday. ...etc... 7=Saturday
Const FIRST_DAY_OF_WEEK = 0
'// 0=System.
'// 1=Start with the week in which January 1 occurs (default).
'// 2=Start with the week that has at least four days in the new year.
'// 3=Start with the first full week of the new year.
Const FIRST_WEEK_OF_YEAR = 0
Const OPEN_EVENTS_MODE = 2                                         '// 1) New browser window 2) Pop up window
'// Optional: Set your LCID value here if you want to use a specific national date settings:
'Session.LCID = 1044
'// More info on LCID: http://msdn.microsoft.com/library/default.asp?url=/library/en-us/script56/html/vsmsclcid.asp
'============================================================
' NO EDITING BELOW THIS LINE
'============================================================

'// FILE SYSTEM OBJECT
Const ForReading = 1                '// Open a file for reading only. You can't write to this file.
Const ForWriting = 2                  '// Open a file for writing.
Const ForAppending = 8             '// Open a file and write to the end of the file.
Const TristateUseDefault = -2    '// Opens the file using the system default.
Const TristateTrue = -1             '// Opens the file as Unicode.
Const TristateFalse = 0             '// Opens the file as ASCII.

'------------------------------------------------------------------------------------------------------------
' Comment: Call this routine to include a calendar in your asp page.
'------------------------------------------------------------------------------------------------------------
		Function ShowCalendar()
		On Error Resume Next

		Dim bDone

		bDone = False

		'// Include ASPCalendar.js before the calendar code
		Response.Write "<script type=""text/javascript"" src=""html/ASPCalendar.js""></script>"

		'// If user is admin then print the folder icon
		If GetCookie Then        
				Response.Write "<div><a href=""javascript:pop('edit_events.asp','ASPCalendar',760,600);"" title=""Edit Events"">" & _
				"<img src=""images/edit_events.gif"" width=""18"" height=""17"" alt="""" title=""Edit Events"" class=""cal_edit_events"" /></a></div>"
		End If

		'// Run the calendar code again if web server had a restart and the variable was lost.
		If Len(Application("ASP_CALENDAR")) = 0 Then Call CreateCalendar: bDone = True

		'// Delete old events, if any
		If Application("ASP_CALENDAR_CURRENT_MONTH") <> Month(Date) Then Call DeleteOldEvents

		'// Check to see if the calendar is outdated. If so, create a new one.
		If Application("ASP_CALENDAR_CURRENT_DAY") <> Day(Date) And Not bDone Then Call CreateCalendar

		ShowCalendar = Application("ASP_CALENDAR")

		End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Create a new calendar and save it to application variable and as html.
'------------------------------------------------------------------------------------------------------------
Function CreateCalendar()
    On Error Resume Next

    Dim oCalendar
    
    If IsEmpty(oCalendar) Then Set oCalendar = New cCalendar

    With oCalendar
        .PathToDatabase = Server.MapPath(PATH_TO_DATABASE)
        .DatabaseType = DATABASE_TYPE
        .PathToCalendar = Server.MapPath(PATH_TO_CALENDAR)
        .PathToEventsFile = Server.MapPath(PATH_TO_EVENTSFILE)
        .OneOrTwo = CREATE_ONE_OR_TWO_CALENDARS
        .FirstDayOfWeek = FIRST_DAY_OF_WEEK
        .EventsWindow = OPEN_EVENTS_MODE
        CreateCalendar = .PrintCalendar
        '// If something goes wrong, you could check the .ErrorMessage Property:
'        If Not .CreateCalendar Then Response.Write .ErrorMessage
    End With

    Set oCalendar = Nothing

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Clean up DB. Delete old records.
'------------------------------------------------------------------------------------------------------------
Function DeleteOldEvents()
    On Error Resume Next

    Dim oEvents

    If IsEmpty(oEvents) Then Set oEvents = New cEvents

    With oEvents
        .PathToDatabase = Server.MapPath(PATH_TO_DATABASE)
        .DatabaseType = DATABASE_TYPE
        DeleteOldEvents = .DeleteOldEvents
    End With

    Set oEvents = Nothing

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Returns true if array has values, false if empty.
'------------------------------------------------------------------------------------------------------------
Function IsSafeArray(arr)
    On Error Resume Next

    Dim lUbound

    If Not IsArray(arr) Then Exit Function
    lUbound = UBound(arr, 1)

    IsSafeArray = (Err.Number = 0)
    Err.Clear
        
End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Create a file.

' sFullPath: C:\folder\file.txt
' sTxt: Some text
' bOverWrite: Overwrite file if it already exist? If omitted default is True.
' UniCode: Default is ascii, not unicode.

' (Unicode is not supported on ISS 5 and will return an error.)
'------------------------------------------------------------------------------------------------------------
Function CreateFile(sFullPath, sTxt, bOverWrite)
    On Error Resume Next
    
    Dim oFSO
    Dim oFile

    If IsEmpty(oFSO) Then Set oFSO = Server.CreateObject("Scripting.FileSystemObject")
    Set oFile = oFSO.CreateTextFile(sFullPath, bOverWrite)
    '// Use this line if you need to work with unicode:
    'Set oFile = oFSO.CreateTextFile(sFullPath, bOverWrite, True)
    oFile.Write sTxt
    
    oFile.Close
    Set oFile = Nothing
    Set oFSO = Nothing

    CreateFile = (Err.Number = 0)

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Read from a file (ReadAll)
'------------------------------------------------------------------------------------------------------------
Function ReadFile(sFilePath)
    On Error Resume Next

    Dim oFSO
    Dim oFile
 
    If IsEmpty(oFSO) Then Set oFSO = Server.CreateObject("Scripting.FileSystemObject")
    If Not oFSO.FileExists(sFilePath) Then m_sErrMessage = "File dont exist" & sFilePath: Exit Function

    Set oFile = oFSO.OpenTextFile(sFilePath, ForReading, , TristateUseDefault)
    '// Open the file as Unicode:
    '   Set oFile = oFSO.OpenTextFile(sFilePath, ForReading, , TristateTrue)
    
    ReadFile = oFile.ReadAll

    Set oFile = Nothing
    Set oFSO = Nothing

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Read cookie.
'------------------------------------------------------------------------------------------------------------
Function GetCookie()
    On Error Resume Next
    
    If Request.Cookies("ASPCalendar").HasKeys Then GetCookie = CBool(Request.Cookies("ASPCalendar")("IsAdmin"))

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Limit length of string and cut it at a space character.
'------------------------------------------------------------------------------------------------------------
Function LimitTextLength(Txt, Max, Delimeter, Tail)
    On Error Resume Next

    If Len(Txt) <= Max Then LimitTextLength = Txt: Exit Function
    LimitTextLength = Mid(Txt, 1, InStrRev(Txt, Delimeter, Max - Len(Tail)) - 1) & Tail

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Prepare your user data before inserting them to database.
'------------------------------------------------------------------------------------------------------------
Function ToSQL(Val, Mode, b255)
    On Error Resume Next

    If UCase(Mode) = "NUMBER" Then
        If Not IsNumeric(Val) Then Exit Function
        ToSQL = CDbl(Val)
    Else

        If b255 Then

            '// For Access text fields with maximum length of 255 characters
            If Len(Val) > 255 Then Val = Left(Val, 255)
        End If
        
        ToSQL = "'" & Replace(Val, "'", "''") & "'"    '// Double all single (')

    End If

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Retrieve values from database and convert nulls to empty strings.
'------------------------------------------------------------------------------------------------------------
Function GetValue(oRs, sFieldName)
    On Error Resume Next

    Dim sRet

    If oRs Is Nothing Then GetValue = "": Exit Function

    If (Not oRs.EOF) And (sFieldName <> "") Then

        sRet = oRs(sFieldName)

        If IsNull(sRet) Then sRet = ""

    Else
        sRet = ""
    End If

    GetValue = sRet

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Convert line breaks into html.
'------------------------------------------------------------------------------------------------------------
Function ToHTML(sTxt)
    On Error Resume Next

    ToHTML = Replace(Server.HTMLencode(sTxt & ""), vbCrLf, "<br />")

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Cleaning up html by removing tripple instances of line breaks.
'                 Parameter sLB can be either <br /> or vbCrLf.
'------------------------------------------------------------------------------------------------------------
Function CleanUpLineBreaks(Txt, br)
    On Error Resume Next

    Dim bFlag, sTrippel
    
    sTrippel = (br & br & br)

    Do While bFlag = False

        If InStr(Txt, sTrippel) > 0 Then
            Txt = Replace(Txt, sTrippel, br)
        Else
            bFlag = True
        End If

    Loop

    CleanUpLineBreaks = Txt

End Function
%>