<%'------------------------------------------------------------------------------------------
'-  WEB Calendar Application - Version 3.3 - 25 April 2006 
'-  Copyright  2005-2006 - Livio Siri (http://www.livio.net) - All Rights Reserved.     
'----------------------------------------------------------------------------------------------
	'--- Define events common variables
	Dim sStart_Date, sEnd_Date, sEvent_Title, sEvent_Details, sEvent_Repeat, sEvent_Category
	Dim sMode, bError, sEditor, sEditor_IP, sIP, sEvent_Active, sCalendarMode, sInfoMode
	Dim imgStart_Date, imgEnd_Date, imgEvent_Title, imgEvent_Details, imgEvent_Editor
	Dim sEvent_Email, sEvent_Email_Date, sEvent_ID, sEvent_Date, sEvent_Form
	Dim sCategory_ID, sCategory_Detail, bAddedFields, bCalIcon

	bCalIcon = True '--- Enable/Disable small calendar icon

'--- Lines of code enclosed between '@@@@@@@ allow configuration and editing of eventual new fields added to the database by user
	'@@@@@@@@@@@@@@@@@@@
	'--- Enable additional fields
	bAddedFields = True 

	'--- Define added fields variables
	If bAddedFields Then
		Dim sEvent_Time
		Dim imgEvent_Time
		Dim sEvent_Location
		Dim imgEvent_Location
	End if
	'@@@@@@@@@@@@@@@@@@@

'=== Events Functions and Subs ============================

'------ Events Core ----------------------------------------------------------------
Sub Events()
	sCalendarMode = Request.Querystring("CalendarMode")
	sInfoMode = Request.Querystring("InfoMode")
	If sInfoMode = "LICENSE" Then
		Call ShowLicense()
	End if
	If sInfoMode = "HELP" Then
		Call ShowHelp()
	End if
	If Request.Form("CalendarMode") = "CONFIG" Then
			sCalendarMode = "CONFIG"
	End if
	If Request.Form("CalendarMode") = "EDITCATEGORY" Then
			sCalendarMode = "EDITCATEGORY"
	End if
	sEvent_ID = Request.Querystring("Event_ID")
	sEvent_Date = Request.Querystring("CalDate")
	sEvent_Form = Request.Form("EVENT")
 	sCategory_ID = Request.Querystring("Category_ID")
 	sCategory_Detail = Request.Querystring("sCategory")
	If sEvent_Form <> "" Then
		If Session("bLoginSuccessful") OR (sCalendarMode <> "" AND bGuest = True AND NOT Session("bLoginSuccessful")) Then
			Call Update_Event(sEvent_Form)
		End if
	Else
		If sCalendarMode <> "ADD" AND Request.Querystring("CalDelete") <> "si" AND sCalendarMode <> "CONFIG" AND instr(sCalendarMode, "CATEGORY") = 0 Then
			If Session("bWK") = True Then
				If Len(sEvent_Date) = 0 Then
					Call ShowMonthWeekDayEvents("Monthly")
				Else
					Call ShowMonthWeekDayEvents("Weekly")
				End if
			Else
				If Len(Request.Querystring("CalDate")) = 0 Then
					Call ShowMonthWeekDayEvents("Monthly")
				Else
					Call ShowMonthWeekDayEvents("Dayly")
				End if
			End if
		End if
	End if
	If (sCalendarMode <> "" AND bGuest = True AND NOT Session("bLoginSuccessful")) Then
		If sCalendarMode = "ADD" Then
			sMode = "ADD"	
			Show_Form()
		End if
	End if
	If (sCalendarMode <> "" AND Session("bLoginSuccessful") = True AND bProtect) OR (sCalendarMode <> "" AND NOT bProtect) Then
		If sCalendarMode = "EDIT" Then
			sMode = "EDIT"
			Get_Event(Request.QueryString("Event_ID"))
			Show_Form()
		Elseif sCalendarMode = "ADD" Then
			sMode = "ADD"	
			Show_Form()
		Elseif sCalendarMode = "DELETE" Then
			sMode = "DELETE"	
			Delete_Event()
		Elseif sCalendarMode = "CONFIG" Then
			sMode = "CONFIG"	
			Config_Form()
		Elseif sCalendarMode = "CATEGORY" Then
			sMode = "CATEGORY"	
			Category_Form()
		Elseif sCalendarMode = "ADDCATEGORY" Then
			sMode = "ADDCATEGORY"	
			Category_Form()
		Elseif sCalendarMode = "EDITCATEGORY" Then
			sMode = "EDITCATEGORY"	
			Category_Form()
		Elseif sCalendarMode = "DELETECATEGORY" Then
			sMode = "DELETECATEGORY"	
			Delete_Category()
		End If	
	Else
		If (bProtect AND sCalendarMode <> "" AND NOT Session("bLoginSuccessful") AND NOT bGuest) Then
			W "<b style=""font-family:Verdana;font-size:14px;color:#CC0000;background-color:yellow;"">&nbsp;Login Required </b>"
		End if
	End If		
End Sub '--- Events

'------ Monthly/Weekly/Daily Events ----------------------------------------------------------------
Sub ShowMonthWeekDayEvents(Period)
	Dim dDate, sDate, arrColor, iIndex, i, sColor
	Dim fdow, wDate, wkeDate, wkbDate, jj
	Dim TempWeekDay, WD, mEvents, arrEvents, dEvents
	Dim dpYYYY, dYYYY, dEventsSorted, intGetLastDay
	If IsEmpty(Request.QueryString("CalDate")) OR NOT IsDate(Request.QueryString("CalDate")) Then
		dDate = DateValue(Date())
		sDate = DateValue(Date())
	Else
		dDate = DateValue(Request.QueryString("CalDate"))
		sDate = DateValue(Request.QueryString("CalDate"))
	End If
	If dDate <> Date() Then strOggi = "" End if
	Dim intSMonth, intSYear
	If Len(Request.QueryString("CalMonth")) > 0 AND Len(Request.QueryString("CalYear")) > 0 Then
		intSMonth = Request.QueryString("CalMonth")
		intSYear = Request.QueryString("CalYear")
	Else
		intSMonth = Month(Date)
		intSYear = Year(Date)
	End if
	If Period = "Weekly" Then
		'--- Calculate week range
		TempWeekDay= DateSerial(datepart("yyyy", date), datepart("m", date), 0)
		WD = WeekDay(TempWeekDay)
		fdow = TempWeekDay - (WD+6) mod 7
		fdow = WeekDay(fdow, vbUseSystem) 
		wkeDate = WeekEndDay(dDate, fdow)
		wkbDate = DateAdd("d", -6, wkeDate)
		Write_Table(sEventWindowBGColor)
			W "&nbsp;&nbsp;&nbsp;" & strCalendario & "&nbsp;-&nbsp;<span style=""font-weight:normal;font-size:10px;"">" & datepart("yyyy", dDate) & ", " & strWK & " " & SelectWeekType(dDate) & ", " & wkbDate & " - " & wkeDate & "</span>" 
			W "</td></tr></table>"
	ElseIf Period = "Monthly" Then
		'--- Calculate month range
		intGetLastDay = GetLastDay(intSMonth, intSYear)
		wkbDate = DateValue(LDate("1", intSMonth, intSYear, binternational))
		wkeDate = DateValue(LDate(intGetLastDay, intSMonth, intSYear, binternational))
		Write_Table(sEventWindowBGColor)
			W "&nbsp;&nbsp;&nbsp;" & strCalendario & "&nbsp;-&nbsp;<span style=""font-weight:normal;font-size:10px;"">" & SpecialMonthName(intSMonth, sLanguage) & " " & intSYear & "</span>" 
			W "</td></tr></table>"
	ElseIf Period = "Dayly" Then
		'--- Calculate day
		wkbDate = dDate
		wkeDate = dDate
		Write_Table(sEventWindowBGColor)
			W "&nbsp;&nbsp;&nbsp;" & strCalendario & "&nbsp;-&nbsp;<span style=""font-weight:normal;font-size:10px;"">" & strOggi & " " & SpecialFormatDateTime(dDate, 1) & "</span>" 
			W "</td></tr></table>"
	End if
	Set Rs = Server.CreateObject("ADODB.RecordSet")
	Rs.CursorLocation = 2
	If Session("Event_Category") <> "" Then
		If ((Request.QueryString("CalendarMode") = "EDIT" OR Request.QueryString("CalendarMode") = "DELETE") AND Request.QueryString("Event_ID") <> "" AND Session("bLoginSuccessful")) OR (Request.QueryString("Event_ID") <> "" AND Request.QueryString("CalendarMode") = "INDEX") Then
			sSQL = 	"SELECT * FROM tblEvents WHERE Event_ID = " & Request.QueryString("Event_ID") & " AND Event_Category LIKE ('" & Session("Event_Category") & "') ORDER BY Start_Date " & UCase(sSort_Dir)
		Else
			If Session("bLoginSuccessful") Then
				sSQL = 	"SELECT * FROM tblEvents WHERE Event_Category LIKE ('" & Session("Event_Category") & "') ORDER BY Start_Date " & UCase(sSort_Dir)
			Else
				If LCase(dbType) = "access" Then
					sSQL = 	"SELECT * FROM tblEvents WHERE Event_Active = True AND Event_Category LIKE ('" & Session("Event_Category") & "') ORDER BY Start_Date " & UCase(sSort_Dir)
				Elseif LCase(dbType) = "mssql" Then
					sSQL = 	"SELECT * FROM tblEvents WHERE Event_Active = 'True' AND Event_Category LIKE ('" & Session("Event_Category") & "') ORDER BY Start_Date " & UCase(sSort_Dir)
				End if
			End if
		End if
	Else
		If ((Request.QueryString("CalendarMode") = "EDIT" OR Request.QueryString("CalendarMode") = "DELETE") AND Request.QueryString("Event_ID") <> "" AND Session("bLoginSuccessful")) OR (Request.QueryString("Event_ID") <> "" AND Request.QueryString("CalendarMode") = "INDEX") Then
			sSQL = 	"SELECT * FROM tblEvents WHERE Event_ID = " & Request.QueryString("Event_ID") & " ORDER BY Start_Date " & UCase(sSort_Dir)
		Else
			If Session("bLoginSuccessful") Then
				sSQL = 	"SELECT * FROM tblEvents ORDER BY Start_Date " & UCase(sSort_Dir)
			Else
				If LCase(dbType) = "access" Then
					sSQL = 	"SELECT * FROM tblEvents WHERE Event_Active = True ORDER BY Start_Date " & UCase(sSort_Dir)
				Elseif LCase(dbType) = "mssql" Then
					sSQL = 	"SELECT * FROM tblEvents WHERE Event_Active = 'True' ORDER BY Start_Date " & UCase(sSort_Dir)
				End if
			End if
		End if
	End if
	'--- Store events into array
	On error resume next
	Rs.Open sSQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
		dEvents = Rs.GetRows
	Rs.Close
	On error goto 0
	Set Rs = Nothing
	'--- Sort recursive events by requested month
	If isArray(dEvents) then
		Dim rqYear, rqMonth, dpY, dpM, dpD
		rqYear = Request.QueryString("CalYear")
		rqMonth = Request.QueryString("CalMonth")
		If rqMonth = "" Then rqMonth = Month(Date)
		If rqYear = "" Then rqYear = year(Date)
		for i = 1 to uBound(dEvents, 2)
			dpY = DatePart("yyyy", dEvents(2, i))
			dpM = DatePart("m", dEvents(2, i), 0, 0)
			dpD = DatePart("d", dEvents(2, i))
			If dEvents(9, i) AND int(rqMonth) = int(dpM) Then
				dEvents(2, i) = DateValue(LDate(dpD, dpM, rqYear, bInternational))
			End if
		Next
		arrEvents = SortArray(dEvents, 2, sSort_Dir)
	End if
	bEvents = False	
	If isArray(arrEvents) then
		for i = 0 to uBound(arrEvents, 2)
			For jj = wkbDate to wkeDate
				dDate = DateValue(jj)
				If dDate = sDate Then sColor = "#D00000" Else sColor = "#666666" End if
				if (CDate(arrEvents(2, i)) <= dDate AND CDate(arrEvents(3, i)) >= dDate) OR ((DatePart("d", CDate(arrEvents(2, i))) <= DatePart("d", dDate) AND DatePart("m", CDate(arrEvents(2, i))) <= DatePart("m", dDate) AND DatePart("d", CDate(arrEvents(3, i))) >= DatePart("d", dDate) AND DatePart("m", CDate(arrEvents(3, i))) >= DatePart("m", dDate)) AND arrEvents(9, i)) OR ((DatePart("d", CDate(arrEvents(2, i))) <= DatePart("d", dDate) AND DatePart("m", CDate(arrEvents(2, i))) <= DatePart("m", dDate) AND DatePart("d", CDate(arrEvents(2, i))) >= DatePart("d", dDate) AND DatePart("m", CDate(arrEvents(2, i))) >= DatePart("m", dDate)) AND arrEvents(9, i)) OR ((DatePart("d", CDate(arrEvents(3, i))) <= DatePart("d", dDate) AND DatePart("m", CDate(arrEvents(3, i))) <= DatePart("m", dDate) AND DatePart("d", CDate(arrEvents(3, i))) >= DatePart("d", dDate) AND DatePart("m", CDate(arrEvents(3, i))) >= DatePart("m", dDate)) AND arrEvents(9, i)) OR (DatePart("m", CDate(arrEvents(2, i))) < DatePart("m", dDate) AND DatePart("d", CDate(arrEvents(3, i))) >= DatePart("d", dDate) AND DatePart("m", CDate(arrEvents(3, i))) >= DatePart("m", dDate) AND arrEvents(9, i)) OR (DatePart("m", CDate(arrEvents(3, i))) > DatePart("m", dDate) AND DatePart("d", CDate(arrEvents(2, i))) <= DatePart("d", dDate) AND DatePart("m", CDate(arrEvents(2, i))) <= DatePart("m", dDate) AND arrEvents(9, i)) Then
					bEvents = true
					if mEvents <> arrEvents(6, i) then
						w "<hr size=1 color=" & sColor & ">"
						w "<div style=""font-family:verdana;font-size:10px;color:" & sColor & ";"">"
						If NOT bEvent_Repeat Then
							If CDate(arrEvents(2, i)) <> CDate(arrEvents(3, i)) Then
								If NOT bInternational Then
									If bCalIcon Then
										W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&Event_ID="& Server.URLEncode(arrEvents(0, i)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(arrEvents(2, i)) & "&CalMonth=" & DatePart("m", arrEvents(2, i)) & "&CalYear=" & DatePart("yyyy", arrEvents(2, i)) & """ title="" " & SpecialMonthName(DatePart("m", CDate(arrEvents(2, i))), sLanguage) &" " &  Day(CDate(arrEvents(2, i))) & " - "& SpecialMonthName(DatePart("m", CDate(arrEvents(3, i))), sLanguage) & " "  & Day(CDate(arrEvents(3, i))) & ", " & rqYear & " - " & arrEvents(6, i) & " "" class=LINKSTYLE>"
										W "<IMG SRC=""" & strImgDir & "calendarL.gif"" WIDTH=16 HEIGHT=12 BORDER=0 ALT="" " & SpecialMonthName(DatePart("m", CDate(arrEvents(2, i))), sLanguage) &" " &  Day(CDate(arrEvents(2, i))) & " - "& SpecialMonthName(DatePart("m", CDate(arrEvents(3, i))), sLanguage) & " "  & Day(CDate(arrEvents(3, i))) & ", " & rqYear & " - " & arrEvents(6, i) & " "" align=absmiddle></a>"
									End if
									W strEventRange & "<span style=""color:" & sColor & ";"">" & SpecialMonthName(DatePart("m", CDate(arrEvents(2, i))), sLanguage) &" " &  Day(CDate(arrEvents(2, i))) & " - "& SpecialMonthName(DatePart("m", CDate(arrEvents(3, i))), sLanguage) & " "  & Day(CDate(arrEvents(3, i))) & ", " & rqYear & "</span>"
								Else
									If bCalIcon Then
										W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&Event_ID="& Server.URLEncode(arrEvents(0, i)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(arrEvents(2, i)) & "&CalMonth=" & DatePart("m", arrEvents(2, i)) & "&CalYear=" & DatePart("yyyy", arrEvents(2, i)) & """ title="" " & Day(CDate(arrEvents(2, i))) & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(2, i))), sLanguage) & " - " & Day(CDate(arrEvents(3, i))) & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(3, i))), sLanguage) & ", " & rqYear & " - " & arrEvents(6, i) & " "" class=LINKSTYLE>"
										W "<IMG SRC=""" & strImgDir & "calendarL.gif"" WIDTH=16 HEIGHT=12 BORDER=0 ALT="" " & Day(CDate(arrEvents(2, i))) & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(2, i))), sLanguage) & " - " & Day(CDate(arrEvents(3, i))) & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(3, i))), sLanguage) & ", " & rqYear & " - " & arrEvents(6, i) & " "" align=absmiddle></a>"
									End if
									W strEventRange & " <span style=""color:" & sColor & ";"">" & Day(CDate(arrEvents(2, i))) & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(2, i))), sLanguage) & " - " & Day(CDate(arrEvents(3, i))) & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(3, i))), sLanguage) & ", " & rqYear & "</span>"
								End if
							Else
								If bCalIcon Then
									W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&Event_ID="& Server.URLEncode(arrEvents(0, i)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(arrEvents(2, i)) & "&CalMonth=" & DatePart("m", arrEvents(2, i)) & "&CalYear=" & DatePart("yyyy", arrEvents(2, i)) & """ title="""" class=LINKSTYLE>"
									W "<IMG SRC=""" & strImgDir & "calendar.gif"" WIDTH=16 HEIGHT=12 BORDER=0 ALT="" " & SpecialFormatDateTime(dDate, 1) & " - " & arrEvents(6, i) & " "" align=absmiddle></A>"
								End if
								W SpecialFormatDateTime(dDate, 1)
							End If
						Else
								If bCalIcon Then
									W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&Event_ID="& Server.URLEncode(arrEvents(0, i)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(arrEvents(2, i)) & "&CalMonth=" & DatePart("m", arrEvents(2, i)) & "&CalYear=" & DatePart("yyyy", arrEvents(2, i)) & """ title="""" class=LINKSTYLE>"
									W "<IMG SRC=""" & strImgDir & "calendar.gif"" WIDTH=16 HEIGHT=12 BORDER=0 ALT="" " & SpecialFormatDateTime(dDate, 1) & " - " & arrEvents(6, i) & " "" align=absmiddle></A>"
								End if
							W SpecialFormatDateTime(dDate, 1)
						End if
						W "</div>"
							W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=0 CELLPADDING=1 BGCOLOR=" & sEventTitleBGColor & "><TR><TD>"
								W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=0 BORDER=1 CELLPADDING=0 BGCOLOR=#FFFFFF><TR BGCOLOR=" & sEventTitleBGColor & ">" 
								W "<TD Style=""border-bottom: 1px solid " & sEventTitleBGColor & ";"" width=""100%"">"
								W "<B Style=""Font-Family:Verdana, Tahoma;font-size:10;COLOR:" & sEventTitleForeColor & ";padding-left:5px;"">" & arrEvents(6, i) & "</B></TD>"
								If arrEvents(9, i) Then
									W "<TD bgcolor=#F0F0F0 align=center Style=""border-bottom: 1px solid " & sEventTitleBGColor & ";padding-left:2px;"">"
									W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " ""></TD>" 
								End if
								If arrEvents(11, i) AND (bEmailer OR Session("bLoginSuccessful") OR Session("bGuestLoginSuccessful")) Then
									W "<TD bgcolor=#F0F0F0 align=center Style=""border-bottom: 1px solid " & sEventTitleBGColor & ";padding-left:2px;"">"
									W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " ""></TD>" 
								End if
								If Session("bLoginSuccessful") OR Session("bGuestLoginSuccessful") Then
									If arrEvents(10, i) = False Then
										W "<td bgcolor=#F0F0F0 Style=""border-bottom: 1px solid " & sEventTitleBGColor & ";"" align=right WIDTH=""3%"">"
										W "<IMG SRC=""" & strImgDir & "no.gif"" BORDER=0 HEIGHT=16 WIDTH=16 alt= "" " & strEventInactive & " "" align=right></td>"
									End if
									W "<TD VAlign=top bgcolor=#F0F0F0 align=center Style=""border-bottom: 1px solid " & sEventTitleBGColor & ";font-size:12px;padding-left:2px;"" nowrap>["
									W "<A HREF=""" & sFileName & "?" & RQString & "&CalendarMode=EDIT&Event_ID=" & arrEvents(0, i) & "&CalDate=" & CDate(arrEvents(2, i)) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title="" " & strModEventi & " "">"
									W "<IMG SRC=""" & strImgDir & "edit.gif"" BORDER=0 HEIGHT=11 WIDTH=16 align=absmiddle hspace=2></A>]</TD>" 
									If bEventDelete Then
										W "<TD VAlign=top bgcolor=#F0F0F0 align=center Style=""border-bottom: 1px solid " & sEventTitleBGColor & ";font-size:12px;padding-left:2px;"" nowrap>["
										W "<A HREF=""" & sFileName & "?" & RQString & "&CalendarMode=DELETE&CalDate=" & Server.URLEncode(dDate) & "&Event_ID=" & arrEvents(0, i) & "&Event_Title=" & arrEvents(6, i) &"&Start_Date=" & CDate(arrEvents(2, i)) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title="" " & strDelEventi & " "">"
										W "<IMG SRC=""" & strImgDir & "delete.gif"" BORDER=0 HEIGHT=11 WIDTH=16 align=absmiddle hspace=2></A>]</TD>" 
									End if
								End If
								W "</TR><TR><TD VALIGN=top COLSPAN=5>" 
									W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=0 CELLPADDING=5><TR><TD>" 
									W "<div style=""font-family:verdana, Arial;font-size:10px;COLOR=Navy;"">" 
									W arrEvents(8, i) & "</div>" 

									'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
									'--- Show added fields in the event box
									If (arrEvents(13, i) <> "" OR arrEvents(14, i) <> "") AND bAddedFields Then
										W "<div style=""font-family:Tahoma, Arial, verdana;font-size:11px;COLOR=Gray;"">"
										If arrEvents(13, i) <> "" Then
											W "Event Time: " & arrEvents(13, i) & "<br>" 
										End If
										If arrEvents(14, i) <> "" Then
											W "Location: " & arrEvents(14, i) & "<br>" 
										End If
										W "</div>"
									End if
									'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

									If arrEvents(9, i) OR arrEvents(4, i) <> "" OR CDate(arrEvents(2, i)) <> CDate(arrEvents(3, i)) OR arrEvents(7, i) <> "" Then
										W "<div align=right style=""font-family:Tahoma, Arial, verdana;font-size:10px;COLOR=Gray;"">"
										If arrEvents(4, i) <> "" Then
											W "Posted by: " & arrEvents(4, i) & "&nbsp;" 
'											W "&nbsp;-&nbsp;" & arrEvents(5, i) & "&nbsp;" 
										End If
										If arrEvents(7, i) <> "" Then
											W strEventCategory & ": " & arrEvents(7, i) & "&nbsp;&nbsp;"
										End if
										If CDate(arrEvents(2, i)) <> CDate(arrEvents(3, i)) Then
											If NOT bEvent_Repeat Then mEvents = arrEvents(6, i)  Else mEvents = "" End if
											If NOT bInternational Then
												W strEventRange & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(2, i))), sLanguage) & " " & Day(CDate(arrEvents(2, i))) & " - " & SpecialMonthName(DatePart("m", CDate(arrEvents(3, i))), sLanguage) & " " & Day(CDate(arrEvents(3, i)))
											Else
												W strEventRange & " " & Day(CDate(arrEvents(2, i))) & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(2, i))), sLanguage) & " - " & Day(CDate(arrEvents(3, i))) & " " & SpecialMonthName(DatePart("m", CDate(arrEvents(3, i))), sLanguage) 
											End if
										End If
										W "&nbsp;</div>"
									End If
									W "</TD></TR></TABLE>" 
								W "</TD></TR></TABLE>" 
							W "</TD></TR></TABLE><div style=""font-size:3px;"">&nbsp;</div>" 
					End if
				End if
			next
		next
	End if
	If NOT bEvents Then
		W "<span style=""font-family:verdana;font-size:10px;color:" & sColor & ";"">" & strNoEventi & "</span>"
	End if
	Call ShowV()
End Sub '--- ShowMonthWeekEvents

'-------- Update/Add Event Form --------------------------------------------------------------
Sub Show_Form()
	Dim sButtonMsg, sTitle, spcLanguage, sDateType
	Dim sERValue, sChecked, strCategorySQL, rsCatDetails
	If sMode = "ADD" Then
		If (bGuest = True AND bCheckGuest = False) OR Session("bLoginSuccessful") Then
			sEvent_Active = True
		Else
			sEvent_Active = False
		End if
		sButtonMsg = strAddEventi
	Else
		sButtonMsg = strNewEventi
	End If
	'--- Date Picker Calendar language
	Select Case LCase(Request.Servervariables("HTTP_ACCEPT_LANGUAGE"))
		Case "en"
			spcLanguage = "en"
		Case "it"
			spcLanguage = "it"
		Case "es"
			spcLanguage = "es"
		Case "de"
			spcLanguage = "de"
		Case "no"
			spcLanguage = "no"
		Case "nl"
			spcLanguage = "nl"
		Case Else
			spcLanguage = "en"
	End Select
	sDateType = "dd/mm/yyyy"
	if bInternational = False Then sDateType ="mm/dd/yyyy"
	%><!-- #include file="_popdate.asp"> --><%
	W "<hr size=1 "
	If bEventsPopUp Then W "width=" & intPopUpWidth - 45 & ">" Else W ">" End if
	Write_Table(sEventWindowBGColor)
	W "&nbsp;&nbsp;&nbsp;&nbsp;" & sButtonMsg & "</td></tr></table><br>"
	W "<TABLE CELLSPACING=0 CELLPADDING=5 BORDER=0 style=""font-family:verdana;font-size:10px;"" align=center width=""100%"">"
		W "<FORM NAME=""eventfrm"" ACTION=""" & sFileName & "?" & RQString & "&CalendarMode=" & sMode & "&Event_ID=" & sEvent_ID & "&CalDate=" & sEvent_Date & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ METHOD=POST>"
	W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"" nowrap><B>" & strEventDate & "</B>"
	W "<BR><FONT COLOR=RED><I>" & strRequired & "</I></FONT></TD>"
	W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"">"
	W "<INPUT TYPE=TEXT ID=""startdate"" SIZE=12 MAXLENGTH=12 NAME=""START_DATE"" VALUE=""" & Server.HTMLEncode(sStart_Date) & """ class=cal>"
	W "<input type=image src=""" & strImgDir & "ew_calendar.gif"" alt="" " & strEventDate & " "" onClick=""showCalendar(this,document.getElementById('startdate'),'" & sDateType & "','" & spcLanguage & "',1);return false;"" align=absmiddle>"
	W imgStart_Date & "</TD></TR>"

	W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>" & strEventEndDate & "</B>"
	W "<BR><FONT COLOR=RED><I>" & strOptional & "</I></FONT></TD>"
	W "<TD ALIGN=LEFT nowrap style=""border-bottom:1px solid #CCCCCC;"">"
	W "<INPUT TYPE=TEXT ID=""enddate"" SIZE=12 MAXLENGTH=12 NAME=""END_DATE"" VALUE=""" & Server.HTMLEncode(sEnd_Date) & """ class=cal>"
	W "<input type=image src=""" & strImgDir & "ew_calendar.gif"" alt="" " & strEventEndDate & " "" onClick=""showCalendar(this,document.getElementById('enddate'),'" & sDateType & "','" & spcLanguage & "',1);return false;"" align=absmiddle>"
	W imgEnd_Date & "</TD></TR>"

	W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>" & strEventRepeat & "</B>"
	W "<BR><FONT COLOR=RED><I>" & strOptional & "</I></FONT></TD>"
	W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
	If sEvent_Repeat = True Then
		sChecked = " checked style=""background-color:#F00000;"""
	else
		sChecked = ""
	end if
	W "<INPUT TYPE=checkbox NAME=""EVENT_REPEAT"" " & sChecked & ">"
	W "&nbsp;<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "">" 
	W "</TD></TR>"

	If Session("bLoginSuccessful") Then
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>" & strEventActive & "</B>"
		W "<BR><FONT COLOR=RED><I>" & strOptional & "</I></FONT></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		If sEvent_Active = True Then
			sChecked = " checked style=""background-color:#F00000;"""
		else
			sChecked = ""
		end if
		W "<INPUT TYPE=checkbox NAME=""EVENT_ACTIVE"" " & sChecked & ">"
		If sEvent_Active = False Then w "<IMG SRC=""" & strImgDir & "no.gif"" WIDTH=16 HEIGHT=16 BORDER=0 ALT="" " & strEventInactive & " "" align=absmiddle>" end if
		W "</TD></TR>"
	
		If bEmailer Then
			W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>" & strEventEmail & "</B>"
			W "<BR><FONT COLOR=RED><I>" & strOptional & "</I></FONT></TD>"
			W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
			If sEvent_Email = True Then
				sChecked = " checked style=""background-color:#F00000;"""
			else
				sChecked = ""
			end if
			W "<INPUT TYPE=checkbox NAME=""EVENT_EMAIL"" " & sChecked & ">"
			W "&nbsp;<IMG SRC=""" & strImgDir & "email.gif"" WIDTH=16 HEIGHT=13 BORDER=0 ALT="" " & strEventEmail & " "" align=absmiddle>"
			If sEvent_Email_Date <> "" Then W "&nbsp;" & strEventEmailDate & " " & sEvent_Email_Date
			W "</TD></TR>"
		End if
	Else
		If bCheckGuest = False AND bGuest = True Then w "<INPUT TYPE=hidden NAME=""EVENT_ACTIVE"" value=""on"">"
	End if
	
	W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>" & strEventEditor & "</B>"
	W "<BR><FONT COLOR=RED><I>"
	If bEventEditorName Then W strRequired Else W strOptional
	W "</I></FONT></TD>"
	W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
	W "<INPUT TYPE=TEXT SIZE=35 MAXLENGTH=100 NAME=""EDITOR"" VALUE=""" & sEditor & """ class=cal>" & imgEvent_Editor & "</TD></TR>"
	
	W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>" & strEventCategory & "</B>"
	W "<BR><FONT COLOR=RED><I>" & strOptional & "</I></FONT></TD>"
	W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<Select  NAME=""Event_Category"" class=cal>"
			W "<Option Value="""">" & strSelCat & "</option>"
				Set rsCatDetails = Server.CreateObject("ADODB.Recordset")
				strCategorySQL = "SELECT * FROM tblCategory;"
				rsCatDetails.Open strCategorySQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
				If rsCatDetails.RecordCount <> 0 Then
					'--- Read in category details from the recordset
					For i = 1 to rsCatDetails.RecordCount
						W "<Option Value='" & rsCatDetails("sCategory") & "'"
							If sEvent_Category = rsCatDetails("sCategory") Then W " Selected"
						W ">" & rsCatDetails("sCategory") & "</option>"
						rsCatDetails.MoveNext
					Next
					rsCatDetails.Close
				End If
				Set rsCatDetails = Nothing
		W "</Select></TD></TR>"
	
	'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
	'--- Show added fields in the add/edit form
	If bAddedFields Then
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Event Time</B>"
		W "<BR><FONT COLOR=RED><I>" & strOptional & "</I></FONT></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT SIZE=65 MAXLENGTH=100 NAME=""EVENT_TIME"" VALUE=""" & sEvent_Time & """ class=cal>" & imgEvent_Time & "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Event Location</B>"
		W "<BR><FONT COLOR=RED><I>" & strOptional & "</I></FONT></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT SIZE=65 MAXLENGTH=100 NAME=""EVENT_LOCATION"" VALUE=""" & sEvent_Location & """ class=cal>" & imgEvent_Location & "</TD></TR>"
	End if
	'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>" & strEventTitle & "</B>"
	W "<BR><FONT COLOR=RED><I>" & strRequired & "</I></FONT></TD>"
	W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
	W "<INPUT TYPE=TEXT SIZE=65 MAXLENGTH=100 NAME=""EVENT_TITLE"" VALUE=""" & Server.HTMLEncode(sEvent_Title) & """ class=cal><br>" & imgEvent_Title & "</TD></TR>"

	W "<TR><TD VALIGN=TOP ALIGN=LEFT colspan=2 nowrap><B>" & strEventDetails & "</B>"
	W "&nbsp;<FONT COLOR=RED><I>" & strRequired & "</I></FONT>&nbsp;&nbsp;" & imgEvent_Details & "<BR>"

	'--- External WYSIWYG Editor management -----
		If bHTMLText Then
			Call ExternalEditor()
		End if
		W "<TEXTAREA ROWS=18 COLS=95 NAME=""EVENT_DETAILS"" WRAP=PHYSICAL class=cal>" & Server.HTMLEncode(sEvent_Details) & "</TEXTAREA>"
	'------------------------------------------------------

	W "</TD></TR><TR><TD VALIGN=TOP ALIGN=LEFT>"
	W "&nbsp;</TD><TD VALIGN=TOP ALIGN=LEFT>"
	W "<INPUT TYPE=HIDDEN NAME=""EVENT_EMAIL_DATE"" VALUE=" & sEvent_Email_Date & ">"
	W "<INPUT TYPE=HIDDEN NAME=""EVENT"" VALUE=" & sMode & ">"
	W "<INPUT TYPE=HIDDEN NAME=""EVENT_ID"" VALUE=" & Request.QueryString("EVENT_ID") & ">"
	If (Session("bLoginSuccessful") OR bGuest = True) AND NOT Session("DisableAction") Then
		W "<INPUT TYPE=SUBMIT VALUE="""&sButtonMsg&""" TITLE="""&sButtonMsg&""" style=""cursor:hand;"" class=cal>"
	Else
		W "&nbsp;<b style=""color:red;font-weight:bold;text-decoration:underline;"">" & strSSubDisabled & "</b>&nbsp;"
	End if
	W "&nbsp;<INPUT TYPE=BUTTON onClick='window.location=""" & sFileName & "?" & RQString & """' NAME=button VALUE=""" & strEventExit & """ TITLE=""" & strEventExit & """ style=""cursor:hand;"" class=cal>"
	W "</TD></TR></FORM></TABLE>"
	Call ShowV()
End Sub '--- Show_Form

'--------- Do Update/Add --------------------------------------------------------------
Sub Update_Event(sUpdateMode)
	Dim sErrImage, sTitle, ER, EA, EE
	bError = False
	sErrImage = "<span style=""color:red;background-color:yellow;font-weight:normal;font-family:tahoma;font-size:12px;"">&nbsp;&#171;&nbsp;" & strReqField & "</span>"	
	sStart_Date = Request.Form("START_DATE")
	sEnd_Date = Request.Form("END_DATE")
	sEditor = StripHTML(Request.Form("EDITOR"))
	sEditor_IP = Request.ServerVariables("REMOTE_ADDR")
	sEvent_Category = StripHTML(Request.Form("Event_Category"))
	sEvent_Title = StripHTML(Request.Form("EVENT_TITLE"))
	sEvent_Details = StripHTML(Request.Form("EVENT_DETAILS"))
	sEvent_Repeat = Request.Form("Event_Repeat")
	sEvent_Active = Request.Form("Event_Active")
	'--- Manage required fields
	If NOT IsDate(sStart_Date) Then
		bError = True
		imgStart_Date = sErrImage
	End If 
	If Trim(sEnd_Date) <> "" AND NOT IsDate(sEnd_Date) Then
		bError = True
		imgEnd_Date = sErrImage
	End If
	If Trim(sEvent_Title) = "" Then
		bError = True
		imgEvent_Title = sErrImage
	End If 
	If Trim(sEvent_Details) = "" Then
		bError = True
		imgEvent_Details = sErrImage
	End If 
	If bEventEditorName AND Trim(sEditor) = "" Then
		bError = True
		imgEvent_Editor = sErrImage
	End If 
	'@@@@@@@@@@@@@@@@@@@@@@@
	'--- If added fields are required then uncomment lines
	If Trim(sEvent_Time) = "" AND bAddedFields Then
'		bError = True
'		imgEvent_Time = sErrImage
	End If 
	If Trim(sEvent_Location) = "" AND bAddedFields Then
'		bError = True
'		imgEvent_Location = sErrImage
	End If 
	'@@@@@@@@@@@@@@@@@@@@@@@
	If IsDate(sStart_Date) AND IsDate(sEnd_Date) Then
		If CDate(sStart_Date) > CDate(sEnd_Date) Then
			bError = True
			imgEnd_Date = "<span style=""color:red;background-color:yellow;font-weight:normal;font-family:tahoma;font-size:12px;"">&nbsp;&#171;&nbspError !!</span>"
		End If
	End If
	If bError = False Then
		'--- Do Add/Edit
		Set Rs = Server.CreateObject("ADODB.RecordSet")
			If sUpdateMode = "EDIT" Then
				sTitle = "Event ""<span style=""color:#F00000"">" & StripHTML(Request.Form("EVENT_TITLE")) & "</span>"" Updated"
				sSQL = "SELECT * FROM tblEvents WHERE Event_ID=" & Request.Form("Event_ID")
				Rs.Open sSQL, sCalendarDSN, adOpenKeySet, adLockPessimistic, adCmdText
			Else
				sTitle = "Event Added"
				Rs.Open "tblEvents", sCalendarDSN, adOpenKeySet, adLockPessimistic, adCmdTable
				Rs.AddNew
				Rs("Date_Added") = Now()
			End If
			Rs("Start_Date") = dataDB(Request.Form("START_DATE"))
			If Trim(sEnd_Date) <> "" Then
				Rs("End_Date") = dataDB(Request.Form("END_DATE"))
			Else
				Rs("End_Date") = dataDB(Request.Form("START_DATE"))
			End If	
			Rs("Editor") = StripHTML(Request.Form("EDITOR"))
			Rs("Editor_IP") = Request.ServerVariables("REMOTE_ADDR")
			Rs("Event_Category") = StripHTML(Request.Form("Event_Category"))
			Rs("Event_Title") = StripHTML(Request.Form("EVENT_TITLE"))
			Rs("Event_Details") = StripHTML(Request.Form("EVENT_Details"))
			If Request.Form("Event_Repeat") = "on" Then ER = True Else ER = False End if
			Rs("Event_Repeat") = ER
			If Request.Form("Event_Active") = "on" Then EA = True Else EA = False End if
			Rs("Event_Active") = EA
			If Request.Form("Event_Email") = "on" Then EE = True Else EE = False End if
			Rs("Event_Email") = EE
			If Request.Form("Event_Email_Date") <> "" Then
				Rs("Event_Email_Date") = Request.Form("EVENT_EMAIL_DATE")
			End if

			'@@@@@@@@@@@@@@@@@@@@@@@@
			'--- Update added fields value into the database
			If bAddedFields Then
				Rs("Event_Time") = StripHTML(Request.Form("EVENT_TIME"))
				Rs("Event_Location") = StripHTML(Request.Form("EVENT_LOCATION"))
			End if
			'@@@@@@@@@@@@@@@@@@@@@@@@

			Rs.Update
			Rs.Close
		Set Rs = Nothing
		W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=10 CELLPADDING=0><TR><TD style=""font-family:Verdana;"">"
			W "<H5>" & sTitle & "</H5>"
			W DelayedRefresh(sFileName & "?" & RQString & "&CalDate=" & Server.Urlencode(Request.Form("START_DATE")) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear, 2)
		W "</TD></TR></TABLE>"
	End If	
End Sub	 '--- Update_Event

'------ Get event ----------------------------------------------------------------
Sub Get_Event(lEvent_ID)
	sSQL = "SELECT * FROM tblEvents WHERE Event_ID=" & lEvent_ID
	Set Rs = Server.CreateObject("ADODB.RecordSet")
		Rs.MaxRecords = 1
		Rs.Open sSQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
			If Not Rs.EOF Then
				sStart_Date = sLDate(Rs("Start_Date"), binternational)
				sEnd_Date = sLDate(Rs("End_Date"), binternational)
				sEditor = Rs("Editor")
				sIP = Rs("Editor_IP")
				sEvent_Category = Rs("Event_Category")
				sEvent_Title = Rs("Event_Title")
				sEvent_Details = Rs("Event_Details")
				sEvent_Repeat = Rs("Event_Repeat")
				sEvent_Active = Rs("Event_Active")
				sEvent_Email = Rs("Event_Email")
				sEvent_Email_Date = Rs("Event_Email_Date")

			'@@@@@@@@@@@@@@@@@@@@@@@@@@@
			'--- Get added fields value from database
			If bAddedFields Then
				sEvent_Time = Rs("Event_Time")
				sEvent_Location = Rs("Event_Location")
			End if
			'@@@@@@@@@@@@@@@@@@@@@@@@@@

			Else
				sMode = "ADD"
			End If
		Rs.Close
	Set Rs = Nothing
End Sub	 '--- Get_Event

'--------- Delete Event -------------------------------------------------------------
Sub Delete_Event()
	W "<hr size=1>"
	Write_Table(sEventWindowBGColor)
	W "&nbsp;&nbsp;&nbsp;&nbsp;" & strDelEventi & "</td></tr></table><br>"
	If LCase(Request.Querystring("CalDelete")) <> "si" Then
		'--- Decide if delete
		W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=10 CELLPADDING=0><TR><TD>" 
			W "<div align=center style=""font-family:verdana;font-size:11px;"">"
			W strEventDelete & "<br>"" <b>" & Request.QueryString("Event_Title") & "</b> "", " & Request.Querystring("Start_Date") & " ????<br><br>"
				If Session("bLoginSuccessful") AND NOT Session("DisableAction") Then
					W "<a href=""" & sFileName & "?" & RQString & "&Event_ID=" & Request.QueryString("Event_ID") & "&CalDelete=si&CalendarMode=DELETE&CalDate=" & Request.QueryString("CalDate") & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ style=""background-color:red;color:#FFFFFF;font-weight:bold;font-family:verdana;"" Title="" " & strDelEventi & " "">&nbsp;" & strYes & "&nbsp;</a>"
					W "&nbsp;&nbsp;&nbsp;<a href=""" & sFileName & "?" & RQString & "&CalDate=" & Request.QueryString("CalDate") & "&CalDelete=no&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ style=""background-color:green;color:#FFFFFF;font-weight:bold;font-family:verdana;"" Title="" " & strEventExit & " "">&nbsp;" & strNo & "&nbsp;</a></div>"
				Else
					W "<b style=""color:red;font-weight:bold;text-decoration:underline;"">&nbsp;" & strSSubDisabled & "</b>"
					W "&nbsp;&nbsp;&nbsp;<a href=""" & sFileName & "?" & RQString & "&CalDate=" & Request.QueryString("CalDate") & "&CalDelete=no&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ style=""background-color:green;color:#FFFFFF;font-weight:bold;font-family:verdana;"" Title="" " & strEventExit & " "">&nbsp;" & strNo & "&nbsp;</a></div>"
				End if
			W "<br>"
		W "</TD></TR></TABLE>" 
	Else
		'--- Do delete
		If LCase(dbType) = "access" Then
			sSQL = "DELETE * FROM tblEvents WHERE Event_ID=" & Request.QueryString("Event_ID")
		Elseif LCase(dbType) = "mssql" Then
			sSQL = "DELETE FROM tblEvents WHERE Event_ID=" & Request.QueryString("Event_ID")
		End if
		Set Rs = Server.CreateObject("ADODB.RecordSet")
		Rs.Open sSQL, sCalendarDSN, adOpenKeySet, adLockPessimistic, adCmdText
		Set Rs = Nothing
		W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=10 CELLPADDING=0><TR><TD style=""font-family:Verdana;"">"
			W "<H5>Event Deleted</H5>"
			W DelayedRefresh(sFileName & "?" & RQString & "&refresh=true&CalDate=" & Server.Urlencode(Request.QueryString("CalDate")) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear, 2)
		W "</TD></TR></TABLE>"
	End if
	W "<hr size=1></TD></TR></TABLE>"
	W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
End Sub	 '--- Delete_Event

'------- Configuration Form ---------------------------------------------------------------
Sub Config_Form()
	Dim sButtonMsg, sTitle, sLanguage, sDateType
	Dim sERValue, sChecked
		sButtonMsg = "Calendar Configuration"
		strCalModeConfig = Request.Form("UpdateConfig")
	If strCalModeConfig = "ChangeConfig" Then	
		W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=5 CELLPADDING=0><TR><TD style=""font-family:Verdana;"">"
			W "<H5>Configuration Updated</H5>"
		W "</TD></TR></TABLE>"
	End if
	Write_Table(sEventWindowBGColor)
	W "&nbsp;&nbsp;&nbsp;&nbsp;" & sButtonMsg & "</td></tr></table><hr size=1 color=#CCCCCC>"

		W "<TABLE CELLSPACING=0 CELLPADDING=5 BORDER=0 style=""font-family:verdana;font-size:10px;"" align=center width=""100%"">"
		W "<FORM NAME=""configfrm"" ACTION=""" & sFileName & "?" & RQString & "&CalendarMode=" & sMode & """ METHOD=POST>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<B>Enable Administrator Login</B><br>(Protect events Add/Edit/Delete,<br>Management and Configuration)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bProtect Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<table CELLSPACING=0 CELLPADDING=0 border=0 width=""100%""><tr><td>"
			W "<INPUT TYPE=checkbox NAME=""bProtect"" " & sChecked & ">"
			w "</td><td style=""font-family:verdana;font-size:10px;"" align=right>"
			W "&nbsp;&nbsp;<B>Login User Name</B>&nbsp;"
		W "<INPUT TYPE=TEXT ID=""UserName"" SIZE=16 MAXLENGTH=16 NAME=""UserName"" VALUE=""" & UserName & """ class=cal><br>"
			W "&nbsp;&nbsp;<B>Login Password</B>&nbsp;"
		W "<INPUT TYPE=PASSWORD ID=""Password"" SIZE=16 MAXLENGTH=16 NAME=""Password"" VALUE=""" & Password & """ class=cal>"
			w "</td><td>"
		w "</td></tr></table>"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<B>Allow anyone to add events</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bGuest = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
			W "<INPUT TYPE=checkbox NAME=""bGuest"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<B>Administrator approval required for added events</B><br>(Added events must be approved and activated <br>by the administrator before posting goes live)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bCheckGuest = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
			W "<INPUT TYPE=checkbox NAME=""bCheckGuest"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"">"
		W "<B>Enable Events in a Pop-Up window</B><br>(or in your own event page: <I>unchecked</I>)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bEventsPopUp = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		w "<table CELLSPACING=0 CELLPADDING=0 border=0 width=""100%""><tr><td>"
		W "<INPUT TYPE=checkbox NAME=""bEventsPopUp"" " & sChecked & ">"
			w "</td><td style=""font-family:verdana;font-size:10px;"" align=right>"
			W "&nbsp;&nbsp;<B>Pop-up window width</B>&nbsp;"
		W "<INPUT TYPE=TEXT ID=""intPopUpWidth"" SIZE=4 MAXLENGTH=4 NAME=""intPopUpWidth"" VALUE=""" & intPopUpWidth & """ class=cal><br>"
			W "&nbsp;&nbsp;<B>Pop-up window height</B>&nbsp;"
		W "<INPUT TYPE=TEXT ID=""intPopUpHeight"" SIZE=4 MAXLENGTH=4 NAME=""intPopUpHeight"" VALUE=""" & intPopUpHeight & """ class=cal>"
			w "</td><td>"
		w "</td></tr></table>"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;""><B>Enable Calendar window display</B><br>"
		W "To get access to calendar configuration can be changed on the fly appending the command: CALENDARPAGENAME.asp<B>?Calendar=true</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bShowCalendar = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bShowCalendar"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;""><B>Show bigger Calendar layout</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bBorderDays = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bBorderDays"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"" nowrap><B>Enable Week Column display</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bWeekColumn = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bWeekColumn"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap colspan=2><B>Week numbering type&nbsp;&nbsp;&nbsp;"
		W "<Select  NAME=""sWeekType"" class=cal>"
			W "<Option Value=""vbUseSystem"""
				If sWeekType = "vbUseSystem" Then W " Selected"
			W ">Use National Language Support (NLS) API setting</option>"
			W "<Option Value=""vbFirstJan1"""
				If sWeekType = "vbFirstJan1" Then W " Selected"
			W ">Start with the week in which January 1 occurs</option>"
			W "<Option Value=""vbFirstFourDays"""
				If sWeekType = "vbFirstFourDays" Then W " Selected"
			W ">Start with the week that has at least four days in the new year</option>"
			W "<Option Value=""vbFirstFullWeek"""
				If sWeekType = "vbFirstFullWeek" Then W " Selected"
			W ">Start with the first full week of the new year</option>"
		W "</Select>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;""><B>Default Filter Events display at start</B>"
		W "<br>Can be changed on the fly appending the command: CALENDARPAGENAME.asp<B>?FilterEvents=true</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bFilterEvents = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bFilterEvents"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;""><B>Default Yearly Events display at start</B>"
		W "<br>Can be changed on the fly appending the command: CALENDARPAGENAME.asp<B>?YearlyEvents=true</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bYearlyEvents = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bYearlyEvents"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"">"
		W "<B>Default Upcoming Events display at start</B><br>Can be changed on the fly appending the command: CALENDARPAGENAME.asp<B>?UpcomingEvents=true</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bUpcomingEvents = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<table CELLSPACING=0 CELLPADDING=0 border=0 width=""100%""><tr><td>"
			W "<INPUT TYPE=checkbox NAME=""bUpcomingEvents"" " & sChecked & ">"
			w "</td><td style=""font-family:verdana;font-size:10px;"" align=right>&nbsp;&nbsp;<B>How many Upcoming Events</B>&nbsp;"
			w "</td><td>"
			W "<INPUT TYPE=TEXT ID=""intUpcomingEvents"" SIZE=3 MAXLENGTH=3 NAME=""intUpcomingEvents"" VALUE=""" & intUpcomingEvents & """ class=cal>"
		w "</td></tr></table>"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;""><B>Enable WYSIWYG Editor</B><br>(Refer directly to <a href=""http://WWW.FCKEDITOR.NET/"" TARGET=_BLANK>www.FCKeditor.net</a> for installation, configuration and customization)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bHTMLText = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bHTMLText"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;""><B>Enable Strip HTML from input</B>"
		W "<br>Strip HTML code from input form to avoid malicious code execution. (If the WYSIWYG editor is enabled then bStripHTML is auto forced to <I>unchecked</I>)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bStripHTML = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bStripHTML"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"" nowrap><B>Enable Event Delete command</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bEventDelete = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bEventDelete"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;""><B>Event Editor Name form input required</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bEventEditorName = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bEventEditorName"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;""><B>List long range events day by day</B><br>"
		W "(Or only once = unchecked)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bEvent_Repeat = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bEvent_Repeat"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"" nowrap><B>Event list sort direction</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
		W "<Select  NAME=""sSort_Dir"" class=cal>"
			W "<Option Value=""ASC"""
				If sSort_Dir = "ASC" Then W " Selected"
			W ">Ascending</option>"
			W "<Option Value=""DESC"""
				If sSort_Dir = "DESC" Then W " Selected"
			W ">Descending</option>"
		W "</Select>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"" nowrap><B>Enable Event Email reminder</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap>"
			If bEmailer = True Then sChecked = " checked style=""background-color:#F00000;""" else sChecked = "" end if
		W "<INPUT TYPE=checkbox NAME=""bEmailer"" " & sChecked & ">"
		W "</TD></TR>"

		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Send Email in advance</B><bR>(How many days before event start date)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""intEmailDays"" SIZE=3 MAXLENGTH=3 NAME=""intEmailDays"" VALUE=""" & intEmailDays & """ class=cal>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Email From Subject text</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""sFrom"" SIZE=45 NAME=""sFrom"" VALUE=""" & sFrom & """ class=cal>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Sender Email</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""sAdministratorsEmail"" SIZE=45 NAME=""sAdministratorsEmail"" VALUE=""" & sAdministratorsEmail & """ class=cal>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Email sent to</B><br>(Separated by comma, if more than one)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""sMailRecipient"" SIZE=45 NAME=""sMailRecipient"" VALUE=""" & sMailRecipient & """ class=cal>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Email sent to BCC</B><br>(optional)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""sMailRecipientBCC"" SIZE=45 NAME=""sMailRecipientBCC"" VALUE=""" & sMailRecipientBCC & """ class=cal>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Select Email Server Object</B></TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<Select  NAME=""sMailObject"" class=cal>"
			W "<Option Value=""CDOSYS"""
				If sMailObject = "CDOSYS" Then W " Selected"
			W ">CDOSYS</option>"
			W "<Option Value=""CDONTS"""
				If sMailObject = "CDONTS" Then W " Selected"
			W ">CDONTS</option>"
			W "<Option Value=""JMail"""
				If sMailObject = "JMail" Then W " Selected"
			W ">JMail</option>"
			W "<Option Value=""AspEmail"""
				If sMailObject = "AspEmail" Then W " Selected"
			W ">AspEmail</option>"
		W "</Select>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Email Server Address</B><br>(required for JMail and AspEmail only)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""sMailServerAddress"" SIZE=45 NAME=""sMailServerAddress"" VALUE=""" & sMailServerAddress & """ class=cal>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"" nowrap><B>Select Email format</B><br>(HTML/Text)</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<Select  NAME=""sFormat"" class=cal>"
			W "<Option Value=""HTML"""
				If sFormat = "HTML" Then W " Selected"
			W ">HTML</option>"
			W "<Option Value=""Text"""
				If sFormat = "Text" Then W " Selected"
			W ">Text</option>"
		W "</Select>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"" nowrap><B>Main table background color</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""sEventWindowBGColor"" SIZE=10 NAME=""sEventWindowBGColor"" VALUE=""" & sEventWindowBGColor & """ class=cal>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;border-top:2px solid #FCCCCC;"" nowrap><B>Event title foreground color</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:1px solid #CCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""sEventTitleForeColor"" SIZE=10 NAME=""sEventTitleForeColor"" VALUE=""" & sEventTitleForeColor & """ class=cal>"
		W "</TD></TR>"
		
		W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:3px solid #FCCCCC;"" nowrap><B>Event title background color</TD>"
		W "<TD ALIGN=LEFT style=""border-bottom:3px solid #FCCCCC;"">"
		W "<INPUT TYPE=TEXT ID=""sEventTitleBGColor"" SIZE=10 NAME=""sEventTitleBGColor"" VALUE=""" & sEventTitleBGColor & """ class=cal>"
		W "</TD></TR>"

		W "</TD></TR><TR><TD VALIGN=TOP ALIGN=center colspan=2>"
		W "<INPUT TYPE=HIDDEN NAME=""UpdateConfig"" VALUE=""ChangeConfig"">"
		If Session("bLoginSuccessful") AND NOT Session("DisableAction") Then
			W "<INPUT TYPE=SUBMIT VALUE="""&strUpdate&""" TITLE="" " & strUpdate & " "" style=""cursor:hand;"" class=cal>"
		Else
			W "&nbsp;<b style=""color:red;font-weight:bold;text-decoration:underline;"">" & strSSubDisabled & "</b>&nbsp;"
		End if
		W "&nbsp;<INPUT TYPE=BUTTON onClick='window.location=""" & sFileName & "?" & RQString & """' NAME=button VALUE=""" & strEventExit & """ TITLE=""" & strEventExit & """ style=""cursor:hand;"" class=cal>"
	W "</TD></TR></FORM></TABLE>"
	Call ShowV()
End Sub '--- Config_Form

'----------------------------------------------------------------------
Sub ShowLicense()
	Write_Table(sEventWindowBGColor)
		W "&nbsp;&nbsp;&nbsp;License</span>" 
		W "</TD></TR></TABLE>" 
		W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=0 CELLPADDING=8 style=""border: solid 1px #999999;"">"
		W "<TR><TD style=""font-family:Verdana;font-size:10px;background-color:#FFFFFF;"">" 
		W Replace(FileRead("license.txt"), VbCrLf, "<br>")
		W "</iframe></TD></TR></TABLE>"
	W "</TD></TR></TABLE><div style=""font-size:3px;"">&nbsp;</div>" 
End Sub '--- ShowLicense

'----------------------------------------------------------------------
Sub ShowHelp()
	Write_Table(sEventWindowBGColor)
		W "&nbsp;&nbsp;&nbsp;Web Calendar Help</span>" 
		W "</TD></TR></TABLE>" 
		W "<iframe id=""myframe"" src=""" & sScriptDir & "webcalendarreadme.htm"" scrolling=yes marginwidth=0 marginheight=0 frameborder=0 vspace=0 hspace=0 width=""100%"" height=600 style=""border: solid 1px #999999;""></iframe>"
	W "</TD></TR></TABLE><div style=""font-size:3px;"">&nbsp;</div>" 
End Sub '--- ShowHelp

'----------------------------------------------------------------------
Sub ShowV()
	'--- WARNING: REMOVING CREDITS AND LINKS TO LIVIO.NET WILL VIOLATE THE LICENSE AGREEMENT
	W "<hr size=1 color=#CCCCCC><div style=""font-family:Tahoma;font-size:10px;color:#666666;"" align=right>Powered by "
	W "<a href=""http://www.livio.net/"" target=_blank style=""font-family:Tahoma;font-size:10px;color:#666666;text-decoration:none;font-weight:bold;"" title="" Livio.net Open Source ASP Scripts "" >Livio.net</a> Web Calendar v" & ICalVersion & "&nbsp;</div>"
	W "</TD></TR></TABLE>" 
	W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
	Session.LCID = ActualLCID
End Sub '--- ShowV

'------ Get last day in the week ------------------------------------------------------------------
Private Function WeekEndDay(inputdate, day)
	WeekEndDay = inputdate - (Weekday(inputdate, vbUseSystem) - 7)
End function '--- WeekEndDay

'------ Date Type MM/DD/YYYY, DD/MM/YYYY --------------------------------------------------
Private Function sLDate(varDate, international)
	Dim myYear
	Dim myDay
	Dim myMonth
	vardate=DateValue(varDate)
	myYear = Year(varDate)
	myDay = Day(varDate)
	myMonth = Month(varDate)
	If international Then
		sLDate = myDay & "/"& myMonth & "/" & myYear 
	Else
		sLDate = myMonth & "/" & myDay & "/"& myYear
	End if 
End Function '--- sLDate

'------- Database compliant date format ----------------------------------------------------
Private Function dataDB(varDate)
	Dim myYear
	Dim myDay
	Dim myMonth
	vardate=DateValue(varDate)
	myYear = Year(varDate)
	myDay = Day(varDate)
	myMonth = Month(varDate)
	dataDB = myYear & "/"& myMonth & "/" & myday 
End Function '--- dataDB

'------- Delayed Refresh ---------------------------------------------------------------
Private function DelayedRefresh(URL, timer)
	DelayedRefresh = 	"<meta http-equiv=""Refresh"" content=""" & timer & "; URL="  &  URL & """>"	
end function '--- DelayedRefresh

'------- Transforms URL to Links ---------------------------------------------------------------
Private Function LinkURLs(ByRef asContent)
	Dim loRegExp	' Regular Expression Object (Requires vbScript 5.0 and above)
	' If no content was received, exit the function
	If asContent = "" Then Exit Function
	' Create Regular Expression object
	Set loRegExp = New RegExp
	' Keep finding links after the first one.				
	loRegExp.Global = True
	' Ignore upper/lower case
	loRegExp.IgnoreCase = True
	' Look for URLs
	loRegExp.Pattern = "((ht|f)tps?://\S+[/]?[^\.])([\.]?.*)"
	' Link URLs
	LinkURLs = loRegExp.Replace(asContent, "<A href=""$1"" target=_blank>$1</A>$3")
	' Look for email addresses
	loRegExp.Pattern = "(\S+@\S+.\.\S\S\S?)"
	' Link email addresses
	LinkURLs = loRegExp.Replace(LinkURLs, "<A href=""mailto:$1"">$1</A>")
	' Release regular expression object
	Set loRegExp = Nothing
End Function '--- LinkURLs

'-------- Remove HTML from text --------------------------------------------------------------
Private function StripHTML(ByRef asHTML)
	If bStripHTML Then
		Dim loRegExp	' Regular Expression Object
		' Create built In Regular Expression object
		Set loRegExp = New RegExp
		' Keep finding pattern after the first one.				
		loRegExp.Global = True
		' Set the pattern To look For HTML tags
		loRegExp.Pattern = "<[^>]*>"
		' Return the original String stripped of HTML
		StripHTML = loRegExp.Replace(asHTML, "")
		' Release object from memory
		Set loRegExp = Nothing
	Else
		StripHTML = asHTML
	End if
End function '--- StripHTML

'-------- Read text file -----------------------------------------------------------------
Private Function FileRead(byVal pathname)
	dim objFSO, objFile, tmp
	pathname = Server.MapPath(sScriptDir & pathname)
	Set objFSO = Server.CreateObject("Scripting.FileSystemObject")
	Set objFile = objFSO.OpenTextFile(pathname, 1, False)
		tmp = objFile.ReadAll
		If Err Then
			FileRead = Null
		Else
			FileRead = tmp
		End If
	objFile.Close
	Set objFile = Nothing
	Set objFSO = Nothing
End Function '--- FileRead

'------- Write formatted title Table ------------------------------------------------------------------
Sub Write_Table(sValue)
	W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=0 CELLPADDING=10 style=""border: outset 1px; Background-color:" & sValue & ";""><TR><TD>"
		W "<TABLE border=0 cellpadding=0 cellspacing=0 width=""100%"" bgcolor=#FFFFFF><tr>"
		W "<td background=""" & strImgDir & "nav_scale.gif"" style=""font-family:verdana,tahoma;font-size:11px;font-weight:bold;color :#4D6185;border: 1px solid #999999;"" height=21>"
End Sub '--- Write_Table

'-------- Category Form --------------------------------------------------------------
Sub Category_Form()
	Dim sButtonMsg, sTitle, spcLanguage, sDateType, sModeTemp
	Dim sERValue, sChecked, sTitleMsg
	If sMode = "ADDCATEGORY" Then
		sButtonMsg = strAddCat
		sTitleMsg = strAddCat
		sModeTemp = "CATEGORY"
	Else
		sButtonMsg = strNewCat
		sTitleMsg = strCatConf
		sModeTemp = sMode
	End If
	Write_Table(sEventWindowBGColor)
	W "&nbsp;&nbsp;&nbsp;&nbsp;" & sTitleMsg & "</td></tr></table><hr size=1 color=#CCCCCC>"
	W "<TABLE CELLSPACING=0 CELLPADDING=5 BORDER=0 style=""font-family:verdana;font-size:10px;"" align=center>"
		W "<FORM NAME=""categoryfrm"" ACTION=""" & sFileName & "?" & RQString & "&CalendarMode=" & sModeTemp & "&Category_ID=" & sCategory_ID & "&Category_Detail='" & sCategory_Detail & "'&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ METHOD=POST>"
			If sMode = "ADDCATEGORY" Then
				W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid " & sEventTitleBGColor & ";"" nowrap>"
				W "<INPUT TYPE=TEXT SIZE=45 MAXLENGTH=100 NAME=""sCategory"" class=cal></td>"
				W "<td style=""font-size:10px;border-bottom:1px solid " & sEventTitleBGColor & ";"">< Add</td>"
				W "<INPUT TYPE=HIDDEN NAME=""UpdateCategory"" VALUE=""AddCategory"">"
			Else
				'--- Add category icon
				W "<TR>"
				If bEventsPopUp Then
					W "<TD style=""font-size:13px;border-bottom:1px solid " & sEventTitleBGColor & ";"">&nbsp;</TD><td style=""font-size:13px;border-bottom:1px solid " & sEventTitleBGColor & ";"" nowrap>[<A HREF=""#"" Title="" " & strAddCat & " "" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=ADDCATEGORY','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddCat & " ""></A>]</td>"
				Else
					W "<TD style=""font-size:13px;border-bottom:1px solid " & sEventTitleBGColor & ";"">&nbsp;</TD><td style=""font-size:13px;border-bottom:1px solid " & sEventTitleBGColor & ";"" nowrap>[<A HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=ADDCATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ Title="" " & strAddCat & " ""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddCat & " ""></A>]</td>"
				End if
				W "<INPUT TYPE=HIDDEN NAME=""UpdateCategory"" VALUE=""EditCategory"">"
			End if
		W "</TR>"
		Call ReadCategoryDetails()
		W "<TR><TD VALIGN=TOP ALIGN=LEFT colspan=2>"
	If Session("bLoginSuccessful") AND NOT Session("DisableAction") Then
		W "<INPUT TYPE=SUBMIT VALUE="""&sButtonMsg&""" TITLE="""&sButtonMsg&""" style=""cursor:hand;"" class=cal>"
	Else
		W "&nbsp;<b style=""color:red;font-weight:bold;text-decoration:underline;"">" & strSSubDisabled & "</b>&nbsp;"
	End if
	W "&nbsp;<INPUT TYPE=BUTTON onClick='window.location=""" & sFileName & "?" & RQString & """' NAME=button VALUE=""" & strEventExit & """ TITLE=""" & strEventExit & """ style=""cursor:hand;"" class=cal>"
	W "</TD></TR></FORM></TABLE>"
	W "<TABLE CELLSPACING=0 CELLPADDING=5 BORDER=0 style=""font-family:verdana;font-size:10px;"" align=center>"
	W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-top:1px solid " & sEventTitleBGColor & ";"">"
	W "(The event category can be changed on the fly by appending the following command: HTTP://www.YOURSITE.com/YOURCALENDARPAGENAME.asp<B>?Category=YOURCATEGORY</B>)"
	W "</TD></TR></TABLE>"
	Call ShowV()
End Sub '--- Category_Form

'--------- Delete Category -------------------------------------------------------------
Sub Delete_Category()
	W "<hr size=1>"
	Write_Table(sEventWindowBGColor)
	W "&nbsp;&nbsp;&nbsp;&nbsp;" & strDelCat & "</td></tr></table><br>"
	If LCase(Request.Querystring("CatDelete")) <> "si" Then
		'--- Decide if delete or not
		W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=10 CELLPADDING=0><TR><TD>" 
			W "<div align=center style=""font-family:verdana;font-size:11px;"">"
			W strCatDelete & "<br> <b>" & Request.QueryString("Category_Detail") & "</b> ????<br><br>"
				If Session("bLoginSuccessful") AND NOT Session("DisableAction") Then
					W "<a href=""" & sFileName & "?" & RQString & "&Category_ID=" & Request.QueryString("Category_ID") & "&CatDelete=si&CalendarMode=DELETECATEGORY&CalDate=" & Request.QueryString("CalDate") & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ style=""background-color:red;color:#FFFFFF;font-weight:bold;font-family:verdana;"" Title="" " & strDelCat & " "">&nbsp;" & strYes & "&nbsp;</a>"
					W "&nbsp;&nbsp;&nbsp;<a href=""" & sFileName & "?" & RQString & "&CatDelete=no&CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ style=""background-color:green;color:#FFFFFF;font-weight:bold;font-family:verdana;"" Title="" " & strEventExit & " "">&nbsp;" & strNo & "&nbsp;</a></div>"
				Else
					W "<b style=""color:red;font-weight:bold;text-decoration:underline;"">&nbsp;" & strSSubDisabled & "</b>"
					W "&nbsp;&nbsp;&nbsp;<a href=""" & sFileName & "?" & RQString & "&CatDelete=no&CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ style=""background-color:green;color:#FFFFFF;font-weight:bold;font-family:verdana;"" Title="" " & strEventExit & " "">&nbsp;" & strNo & "&nbsp;</a></div>"
				End if
			W "<br>"
		W "</TD></TR></TABLE>" 
	Else
		'--- Do delete
		If LCase(dbType) = "access" Then
			sSQL = "DELETE * FROM tblCategory WHERE Category_ID=" & Request.QueryString("Category_ID")
		Elseif LCase(dbType) = "mssql" Then
			sSQL = "DELETE FROM tblCategory WHERE Category_ID=" & Request.QueryString("Category_ID")
		End if
		Set Rs = Server.CreateObject("ADODB.RecordSet")
		Rs.Open sSQL, sCalendarDSN, adOpenKeySet, adLockPessimistic, adCmdText
		Set Rs = Nothing
		W "<TABLE WIDTH=""100%"" BORDER=0 CELLSPACING=10 CELLPADDING=0><TR><TD style=""font-family:Verdana;"">"
			W "<H5>Category Deleted</H5>"
			W DelayedRefresh(sFileName & "?" & RQString & "&refresh=true&calendarmode=CATEGORY&CalDate=" & Server.Urlencode(Request.QueryString("CalDate")) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear, 1)
		W "</TD></TR></TABLE>"
	End if
	W "<hr size=1></TD></TR></TABLE>"
	W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
End Sub	 '--- Delete_Category

%>
