<%'------------------------------------------------------------------------------------------
'-  WEB Calendar Application - Version 3.3 - 15 April 2006 
'-  Copyright  2005-2006 - Livio Siri (http://www.livio.net) - All Rights Reserved.     
'----------------------------------------------------------------------------------------------
	'--- Define common variables
	Dim UserName, Password, bProtect, dBCalendar, dbCalRemotePath, dBCalLocalPath, sScriptDir
	Dim sCalendarEventsPage, bUpcomingEvents, intUpcomingEvents, bEventEditorName, bWeekColumn
	Dim sDB, sCalendarDSN, dbCalendarConnOLE, RS, sSQL, bEvents, strUpdate, strCalModeConfig
	Dim dbCalPath, ActualLCID, binternational, bEventsPopUp, sLanguage, RQString
	Dim ICalVersion, sCalendarPath, intThisMonth, intThisYear, tempDate, sEXTEditorDir
	Dim sFrom, sMailRecipient, sMailRecipientBCC, sMailObject, sMailServerAddress, sEventTitleForeColor
	Dim sFormat, sAdministratorsEmail, intEmailDays, bEmailer, bShowCalendar, sWeekType
	Dim strAcceptLanguage, strPos, bStripHTML, bHTMLText, bEventDelete, dbType, sMSSQLDBName
	Dim sEventWindowBGColor, sEventTitleBGColor, rsCalConfigDetails, intWeek, strImgDir
	Dim intPopUpWidth, intPopUpHeight, bBorderDays, strCatModeConfig, sSort_Dir, bEvent_Repeat
	Dim strSSubDisabled, rsCatConfigDetails, rsCatRC, bFilterEvents, bGuest, bCheckGuest
	Dim sMSSQLServerName, sMSSQLUserName, sMSSQLPassword, dbMSSQLCalendarConnOLE
	'--- Define language variables
	Dim strEventi, strClicca, strEventi2, strEventiPassati, strNoEventi
	Dim strMesePre, strMeseNex, strAnnoPre, strAnnoNex, strAddEventi
	Dim strNewEventi, strDelEventi, strModEventi, strCalendario, strOggi
	Dim strFormError, strReqField, strRequired, strOptional, strEventDate
	Dim strEventEndDate, strEventEditor, strEventTitle, strEventDetails, strEventExit
	Dim strEventDelete, strYes, strNo, strEventRepeat, strEventActive
	Dim strEventInactive, strEventUpcoming, strEventRange, strEventManager
	Dim strAllEvents, strShowUp, strHideUp, strEventUp, strPageControl
	Dim strPagep, strFirstpTitle, strPrevpTitle, strNextpTitle, strLastpTitle
	Dim strOfp, strAll, strNorfp, strShowWK, strHideWK, strWK
	Dim strEventEmail, strEventEmailDate, bYearlyEvents, strCalConf
	Dim strYShowUp, strYHideUp,  strFShowUp, strFHideUp, strFilterEvents, strEvents
	Dim strCatDelete, strCatConf, strNewCat, strDelCat, strAddCat, strEventCategory
	Dim strSelCat, strCat, strCategoria, strEShowUp, strEHideUp
 
'=== Common Functions and Subs ============================

'--- Initialize Common ------------------------------------------------------
Sub Common_Init()
	'--- database connection

	If LCase(dbType) = "access" Then
		If request.servervariables("HTTP_HOST") = "127.0.0.1" OR request.servervariables("HTTP_HOST") = "localhost" then dbCalPath = dBCalLocalPath Else dbCalPath = dbCalRemotePath End if
		sCalendarDSN = dbCalendarConnOLE & dbCalPath & dBCalendar & ";"
	Elseif LCase(dbType) = "mssql" Then
		sCalendarDSN = dbMSSQLCalendarConnOLE
	Elseif LCase(dbType) = "mysql" Then
		sCalendarDSN = dbMySQLCalendarConnOLE
	End if

	'--- Select the locale ID date format
	Call SelectDateFormat()

	'--- read configuration from database
	Call ReadConfigDetails()

	If bHTMLText Then bStripHTML = False
	If NOT bProtect then Session("bLoginSuccessful") = True
	sCalendarPath = Request.ServerVariables("SCRIPT_NAME")
	If sCalendarEventsPage = "" Then sCalendarEventsPage = sCalendarPath End if
	PreserveQueryString()
End Sub '--- Common_Init

'---- Check if the Calendar Array contains a field---------------------------
Function Onlist(StrField, TheArray)
	Dim count
	If isArray(TheArray) Then
		For count = LBound(TheArray) to UBound(TheArray)
			If lcase(StrField) = lcase(TheArray(Count)) Then
				Onlist = True
			End If
		Next
	End If
End Function '--- Onlist

'------ Preserve QueryString from outside the calendar ------------------------------------
Function PreserveQueryString()
	Dim aIgnoreList, field, count
	'--- Array of QueryStrings used inside Calendar routines
	aIgnoreList = Array("c", "CalendarMode", "Infomode", "CalDate", "CalMonth", "CalYear", "CalhWK", "Event_ID", "Event_Title", "Start_Date", "UpcomingEvents", "CalPage", "CalLogoff", "YearlyEvents", "Calendar", "CalLogin", "CalDelete", "Category_ID", "CatDelete", "Category_Detail", "Category", "sCategory", "refresh")
	'--- Check if a foreign QueryString value is passed to the calendar
	For i = 1 To Request.QueryString.Count
		if NOT Onlist(LCase(Request.QueryString.Key(i)), aIgnoreList) Then
			RQString = RQString & "&" & Server.URLEncode(Request.QueryString.Key(i)) & "=" & Server.URLEncode(Request.QueryString.Item(i))
		End if
	Next
	if Len(RQString) <> 0 Then
		'--- If foreign QueryString available then add it
		RQString = Mid(RQString, 2)
	Else
		'--- else add a dummy QueryString
		RQString = "dummy=dummy"
	End if
End Function '--- PreserveQueryString

'------- Get client language ---------------------------------------------------
Sub GetLanguage()
	ActualLCID = Session.LCID
	strAcceptLanguage = Request.ServerVariables("HTTP_ACCEPT_LANGUAGE")
	strPos = InStr(1, strAcceptLanguage, ",")
	If strPos > 0 Then strAcceptLanguage = Left(strAcceptLanguage, strPos - 1) End If
End Sub '--- GetLanguage

'------- Select the locale ID date format ---------------------------------------------------
Sub SelectDateFormat()
	Dim ddDate, mmDate, yyDate, tdDate, tmDate, aDate, strDate
	ddDate = trim(day(date))
	mmDate = trim(month(date))
	yyDate = trim(year(date))
	If ddDate = mmDate then
		tempDate = Date + 1
		ddDate = ddDate + 1
	Else
		tempDate = Date
	End if
	If instr(tempDate, "/") > 0 Then
		aDate = split(tempdate, "/", -1, 1)
	ElseIf instr(tempDate, "-") > 0 Then
		aDate = split(tempdate, "-", -1, 1)
	ElseIf instr(tempDate, ".") > 0 Then
		aDate = split(tempdate, ".", -1, 1)
	End if
	If Len(ddDate) = 1 Then ddDate = "0" & ddDate End if
	If Len(mmDate) = 1 Then mmDate = "0" & mmDate End if
	If Len(aDate(0)) = 1 Then aDate(0) = "0" & aDate(0) End if
	If Len(aDate(1)) = 1 Then aDate(1) = "0" & aDate(1) End if
	'--- bInternational: False=MM/DD/YYYY, True=DD/MM/YYYY
	if ddDate = aDate(0) AND mmDate = aDate(1) AND yyDate = aDate(2) Then bInternational = True Else bInternational = False End if
End Sub '--- SelectDateFormat

'------- Select Week Type ---------------------------------------------------------------
Function SelectWeekType(vDate)
	Dim intWeek
	'--- Select your week number presentation:
	Select Case sWeekType
		Case "vbUseSystem"
			intWeek = DatePart("ww", DateValue(vDate), vbUseSystem, vbUseSystem) '--- Use National Language Support (NLS) API setting.
		Case "vbFirstJan1"
			intWeek = DatePart("ww", DateValue(vDate), vbUseSystem, vbFirstJan1) '--- Start with the week in which January 1 occurs.
		Case "vbFirstFourDays"
			intWeek = DatePart("ww", DateValue(vDate), vbUseSystem, vbFirstFourDays) '--- Start with the week that has at least four days in the new year. (ISO 8601)
		Case "vbFirstFullWeek"
			intWeek = DatePart("ww", DateValue(vDate), vbUseSystem, vbFirstFullWeek) '--- Start with the first full week of the new year.
	End Select
	SelectWeekType = intWeek
End Function '--- SelectWeekType

'----- Response.Write replacer -----------------------------------------------------------------
Sub W(Str)
  Response.Write(Str & Vbcrlf)
End Sub

'----- Response.End replacer -----------------------------------------------------------------
Sub re()
  Response.End
End Sub

'----------Read or update the configuration in the database ----------------------------------------------------------
Sub ReadConfigDetails()
	Dim strConfigSQL, bField
	Dim Field, T_Item
	strCalModeConfig = Request.Form("UpdateConfig")
	Set rsCalConfigDetails = Server.CreateObject("ADODB.Recordset")
	strConfigSQL = "SELECT * FROM tblConfig;"
	On error resume next
	rsCalConfigDetails.Open strConfigSQL, sCalendarDSN, adOpenKeySet, adLockPessimistic, adCmdText
	If Err.number <> 0 Then
		w "<B STYLE=""color:crimson;"">ERROR NUMBER:</b> (" & Hex(Err.number) & ")<br>"
		w "<B STYLE=""color:crimson;"">ERROR SOURCE:</b> (" & Err.source & ")<br>"
		w "<B STYLE=""color:crimson;"">ERROR DESCRIPTION:</b> (" & Err.description & ")</span><br>"
	re
	End if
	On Error goto 0
		If NOT rsCalConfigDetails.EOF Then
			'--- Read in the config details from the recordset
			Call Config_Details
			If strCalModeConfig = "ChangeConfig" Then	
				'--- Update configuration
				If Request.Form("bProtect") = "" Then
					bField = False
				ElseIf Request.Form("bProtect") = "on" Then
					bField = True
				End if
				rsCalConfigDetails("bProtect") = bField
				rsCalConfigDetails("Username") = Replace(Request.form("Username"), "'", "")
				rsCalConfigDetails("Password") = Replace(Request.form("Password"), "'", "")
				If Request.Form("bGuest") = "" Then
					bField = False
				ElseIf Request.Form("bGuest") = "on" Then
					bField = True
				End if
				rsCalConfigDetails("bGuest") = bField
				If Request.Form("bCheckGuest") = "" Then
					bField = False
				ElseIf Request.Form("bCheckGuest") = "on" Then
					bField = True
				End if
				rsCalConfigDetails("bCheckGuest") = bField
				If Request.Form("bShowCalendar") = "" Then
					Session("bShowCalendar") = False
					bField = False
				ElseIF Request.Form("bShowCalendar") = "on" Then
					Session("bShowCalendar") = True
					bField = True
				End if
				rsCalConfigDetails("bShowCalendar") = bField
				If Request.Form("bEventsPopUp") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bEventsPopUp") = bField
				If Request.Form("bUpcomingEvents") = "" Then
					Session("bUpcomingEvents") = False
					bField = False
				ElseIF Request.Form("bUpcomingEvents") = "on" Then
					Session("bUpcomingEvents") = True
					bField = True
				End if
				rsCalConfigDetails("intPopUpWidth") = Request.form("intPopUpWidth")
				rsCalConfigDetails("intPopUpHeight") = Request.form("intPopUpHeight")
				rsCalConfigDetails("bUpcomingEvents") = bField
				rsCalConfigDetails("intUpcomingEvents") = Request.form("intUpcomingEvents")
				If Request.Form("bFilterEvents") = "" Then
					Session("bFilterEvents") = False
					bField = False
				ElseIF Request.Form("bFilterEvents") = "on" Then
					Session("bFilterEvents") = True
					bField = True
				End if
				rsCalConfigDetails("bFilterEvents") = bField
				If Request.Form("bYearlyEvents") = "" Then
					Session("bYearlyEvents") = False
					bField = False
				ElseIF Request.Form("bYearlyEvents") = "on" Then
					Session("bYearlyEvents") = True
					bField = True
				End if
				rsCalConfigDetails("bYearlyEvents") = bField
				If Request.Form("bWeekColumn") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bWeekColumn") = bField
				rsCalConfigDetails("sWeekType") = Request.form("sWeekType")
				If Request.Form("bHTMLText") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bHTMLText") = bField
				If Request.Form("bStripHTML") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bStripHTML") = bField
				If Request.Form("bEventDelete") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bEventDelete") = bField
				If Request.Form("bEventEditorName") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bEventEditorName") = bField
				If Request.Form("bEmailer") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bEmailer") = bField
				If Request.Form("bBorderDays") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bBorderDays") = bField
				rsCalConfigDetails("intEmailDays") = Request.form("intEmailDays")
				rsCalConfigDetails("sFrom") = Request.form("sFrom")
				rsCalConfigDetails("sAdministratorsEmail") = Request.form("sAdministratorsEmail")
				rsCalConfigDetails("sMailRecipient") = Request.form("sMailRecipient")
				rsCalConfigDetails("sMailRecipientBCC") = Request.form("sMailRecipientBCC")
				rsCalConfigDetails("sMailObject") = Request.form("sMailObject")
				rsCalConfigDetails("sMailServerAddress") = Request.form("sMailServerAddress")
				rsCalConfigDetails("sFormat") = Request.form("sFormat")
				rsCalConfigDetails("sEventTitleBGColor") = Request.form("sEventTitleBGColor")
				rsCalConfigDetails("sEventTitleForeColor") = Request.form("sEventTitleForeColor")
				rsCalConfigDetails("sEventWindowBGColor") = Request.form("sEventWindowBGColor")
				If Request.Form("bEvent_Repeat") <> "on" Then bField = False Else bField = True End if
				rsCalConfigDetails("bEvent_Repeat") = bField
				rsCalConfigDetails("sSort_Dir") = Request.form("sSort_Dir")
				rsCalConfigDetails.Update
				rsCalConfigDetails.Requery	
				'--- Read in the updated config details from the recordset
				Call Config_Details
			End If
		End If
	'--- Reset Server Objects
	rsCalConfigDetails.Close
	Set rsCalConfigDetails = Nothing
End Sub '--- ReadConfigDetails

'------- Store Configuration ----------------------------------------------------------------
Sub Config_Details()
	On Error Resume next
	Username = rsCalConfigDetails("Username")
	Password = rsCalConfigDetails("Password")
	bProtect = rsCalConfigDetails("bProtect")
	bGuest = rsCalConfigDetails("bGuest")
	bCheckGuest = rsCalConfigDetails("bCheckGuest")
	bShowCalendar = rsCalConfigDetails("bShowCalendar")
	bEventsPopUp = rsCalConfigDetails("bEventsPopUp")
	intPopUpWidth = rsCalConfigDetails("intPopUpWidth")
	intPopUpHeight = rsCalConfigDetails("intPopUpHeight")
	bUpcomingEvents = rsCalConfigDetails("bUpcomingEvents")
	intUpcomingEvents = rsCalConfigDetails("intUpcomingEvents")
	bFilterEvents = rsCalConfigDetails("bFilterEvents")
	bYearlyEvents = rsCalConfigDetails("bYearlyEvents")
	bWeekColumn = rsCalConfigDetails("bWeekColumn")
	sWeekType = rsCalConfigDetails("sWeekType")
	bHTMLText = rsCalConfigDetails("bHTMLText")
	bStripHTML = rsCalConfigDetails("bStripHTML")
	bEventDelete = rsCalConfigDetails("bEventDelete")
	bEventEditorName = rsCalConfigDetails("bEventEditorName")
	bEmailer = rsCalConfigDetails("bEmailer")
	intEmailDays = rsCalConfigDetails("intEmailDays")
	sFrom = rsCalConfigDetails("sFrom")
	sAdministratorsEmail = rsCalConfigDetails("sAdministratorsEmail")
	sMailRecipient = rsCalConfigDetails("sMailRecipient")
	sMailRecipientBCC = rsCalConfigDetails("sMailRecipientBCC")
	sMailObject = rsCalConfigDetails("sMailObject")
	sMailServerAddress = rsCalConfigDetails("sMailServerAddress")
	sFormat = rsCalConfigDetails("sFormat")
	sEventTitleBGColor = rsCalConfigDetails("sEventTitleBGColor")
	sEventTitleForeColor = rsCalConfigDetails("sEventTitleForeColor")
	sEventWindowBGColor = rsCalConfigDetails("sEventWindowBGColor")
	bBorderDays = rsCalConfigDetails("bBorderDays")
	bEvent_Repeat = rsCalConfigDetails("bEvent_Repeat")
	sSort_Dir = rsCalConfigDetails("sSort_Dir")
	If Request.Querystring("CalhWK") = "ok" Then Session("bWK") = True End if
	If bWeekColumn AND Len(Request.QueryString("CalhWK")) = 0 Then Session("bWK") = False end If
	If Err.number <> 0 Then
		w "<B STYLE=""color:crimson;"">ERROR NUMBER:</b> (" & Hex(Err.number) & ")<br>"
		w "<B STYLE=""color:crimson;"">ERROR SOURCE:</b> (" & Err.source & ")<br>"
		w "<B STYLE=""color:crimson;"">ERROR DESCRIPTION:</b> (" & Err.description & ")</span><br>"
		W "ERROR: probably your Calendar Database is not updated to the latest version<br>"
	re
	End if
	On Error goto 0
End Sub '--- Config_Details

'----------Read or update the category configuration in the database ----------------------------------------------------------
Sub ReadCategoryDetails()
	Dim strCategorySQL, sCategory()
	strCatModeConfig = Request.Form("UpdateCategory")
	Set rsCatConfigDetails = Server.CreateObject("ADODB.Recordset")
		If strCatModeConfig = "EditCategory" Then	
			strCategorySQL = "SELECT * FROM tblCategory;"
			rsCatConfigDetails.Open strCategorySQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
			rsCatRC = rsCatConfigDetails.RecordCount
			If rsCatRC <> 0 Then
				'--- Read in category details from the recordset
				For i = 1 to rsCatRC
					REDIM PRESERVE sCategory(1, i)
					sCategory(0, i) = rsCatConfigDetails("Category_ID")
					sCategory(1, i) = rsCatConfigDetails("sCategory")
					rsCatConfigDetails.MoveNext
				Next
				rsCatConfigDetails.Close
			End If
				'--- Update category
				For i = 1 to rsCatRC
					strCategorySQL = "SELECT * FROM tblCategory WHERE Category_ID = " & sCategory(0, i) & ";"
					rsCatConfigDetails.Open strCategorySQL, sCalendarDSN, adOpenKeySet, adLockPessimistic, adCmdText
						rsCatConfigDetails("sCategory") = Request.form(""&sCategory(1, i)&"")
					rsCatConfigDetails.Update
					rsCatConfigDetails.Close
				Next
		ElseIf strCatModeConfig = "AddCategory" Then	
			'--- Add category
			rsCatConfigDetails.Open "tblCategory", sCalendarDSN, adOpenKeySet, adLockPessimistic, adCmdTable
			If Request.form("sCategory") <> "" Then
				rsCatConfigDetails.AddNew
					rsCatConfigDetails("sCategory") = Request.form("sCategory")
				rsCatConfigDetails.Update
			Else
				W "<div style=""font-family:Tahoma;font-size:11px;""><B style=""color:#F00000"">Error:</B> The field is empty</div>"
			End if
			rsCatConfigDetails.Close
		End if
		If rsCatConfigDetails.State = &H00000001 then
			rsCatConfigDetails.Close
		End if
			'--- Read in updated category details from the recordset
			strCategorySQL = "SELECT * FROM tblCategory ORDER BY sCategory ASC;"
			rsCatConfigDetails.Open strCategorySQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
				rsCatRC = rsCatConfigDetails.RecordCount
				If rsCatRC <> 0 Then
					For i = 1 to rsCatRC
						REDIM PRESERVE sCategory(1, i)
						sCategory(0, i) = rsCatConfigDetails("Category_ID")
						sCategory(1, i) = rsCatConfigDetails("sCategory")
						W "<TR><TD VALIGN=TOP ALIGN=LEFT style=""border-bottom:1px solid " & sEventTitleBGColor & ";"" nowrap>"
						W "<INPUT TYPE=TEXT SIZE=45 MAXLENGTH=100 NAME=""" & sCategory(1, i) & """ VALUE=""" & sCategory(1, i) & """ class=cal></td>"
						If bEventDelete Then
							W "<TD VAlign=top bgcolor=#F0F0F0 align=center Style=""border-bottom: 1px solid " & sEventTitleBGColor & ";font-size:12px;padding-left:2px;"" nowrap>["
							W "<A HREF=""" & sFileName & "?" & RQString & "&CalendarMode=DELETECATEGORY&Category_ID=" & sCategory(0, i) & "&Category_Detail='" & sCategory(1, i) & "'&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title="" " & strDelCat & " "">"
							W "<IMG SRC=""" & strImgDir & "delete.gif"" BORDER=0 HEIGHT=11 WIDTH=16 align=absmiddle hspace=2></A>]</TD></tr>" 
						End if
						rsCatConfigDetails.MoveNext
					Next
					rsCatConfigDetails.Close
				End If
	'--- Reset Server Objects
	Set rsCatConfigDetails = Nothing
End Sub '--- ReadCategoryDetails

'------- Sort Array by column ----------------------------------------------------------
Function SortArray(values(), intSortCol, sSort_Dir)
	Dim i 
	Dim j 
	Dim value 
	Dim value_j 
	dim min
	dim max
	dim temp
	dim datatype
	dim intComp
	dim intA
	dim intCheckIndex
	Dim strDirection
	strDirection = Left(sSort_Dir, 1)

	On Error Resume next
	min = lbound(values,2)
	max = ubound(values,2)
	  
	'--- check to see what direction you want to sort.
	if lcase(strDirection) = "d" then
		intComp = -1
	else
		intComp = 1
	end if
	  
	if intSortCol < 0 or intSortCol > ubound(values,1) then
		arraysort = values
		exit function
	end if
	'--- find the first item which has valid data in it to sort
	intCheckIndex = min
	while len(trim(values(intSortCol,intCheckIndex))) = 0 and intCheckIndex < ubound(values,2)
		intCheckIndex = intCheckIndex + 1
	wend
	if isDate(trim(values(intSortCol,intCheckIndex))) then
		datatype = 1
	else
		if isNumeric(trim(values(intSortCol,intCheckIndex))) then
			datatype = 2
		else
			datatype = 0
		end if
	end if
	For i = min To max - 1
		value = values(intSortCol,i)
		value_j = i
		For j = i + 1 To max
			select case datatype
				case 0
					'--- See if values(j) is smaller. works with strings now.
					If strComp(values(intSortCol,j),value,vbTextCompare) = intComp Then
						'--- Save the new smallest value.
						value = values(intSortCol,j)
						value_j = j
					End If
				case 1
					if intComp = -1 then
						if DateDiff("s",values(intSortCol,j),value) > 0 then
							'--- Save the new smallest value.
							value = values(intSortCol,j)
							value_j = j
						end if
					else
						if DateDiff("s",values(intSortCol,j),value) < 0 then
							'--- Save the new smallest value.
							value = values(intSortCol,j)
							value_j = j
						end if
					end if
				case 2
					if intComp = -1 then
						if cdbl(values(intSortCol,j)) < cdbl(value) then
							'--- Save the new smallest value.
							value = values(intSortCol,j)
							value_j = j
						end if
					else
						if cdbl(values(intSortCol,j)) > cdbl(value) then
							'--- Save the new smallest value.
							value = values(intSortCol,j)
							value_j = j
						end if
					end if
			end select
		Next 'j
		If value_j <> i Then
			'--- Swap items i and value_j.
			for intA = 0 to ubound(values,1)
				temp = values(intA,value_j)
				values(intA,value_j) = values(intA,i)
				values(intA,i) = temp
			next '--- intA
		End If
	Next 'i
	SortArray = values
End Function

'--------- Date Type MM/DD/YYYY, DD/MM/YYYY ------------------------------------
Function LDate(myDay, myMonth, myYear, international)
	If international Then
		LDate = myDay & "/"& myMonth & "/" & myYear 
	Else
		LDate = myMonth & "/" & myDay & "/"& myYear
	End if 
End Function '--- LDate

'-------- Adapt Date to MSSQL Query ------------------------------------------------
Function convMSSQLDate(theDate)
	Dim Itemp, sTemp, dteArray
	If TRIM(theDate) <> "" Then
		sTemp = cdate(theDate)
		dteArray = Split(sTemp,"/",-1,1)
		If LenB(dteArray(2)) = 2 Then
			dteArray(2) = "20" & dteArray(2)
		End If
		convMSSQLDate =dteArray(2) & "/" & dteArray(1) & "/" &  dteArray(0)
	Else
		convMSSQLDate = Trim(theDate)
	End If
End Function

'-------- Get Las Day of the month ----------------------------------------------------
Function GetLastDay(intMonthNum, intYearNum)
	Dim dNextStart
	If CInt(intMonthNum) = 12 Then
		dNextStart =  "1/1/" & intYearNum
	Else
		dNextStart = LDate("1", intMonthNum + 1, intYearNum, binternational)
	End If
	GetLastDay = Day(DateValue(dNextStart) - 1)
End Function '--- GetLastDay
	
'------ Turkish (or special) languages -----------------------------------------------------------------------
	sLanguage = UCase(strAcceptLanguage)
'------- Get Custom Month Name ---------------------------------------------------------------------
Function SpecialMonthName(intMonthNum, sLanguage)
	Dim arrMonth
	Select Case sLanguage
		Case "TR" '--- Turkish
			arrMonth = Array("Ocak", "Subat", "Mart", "Nisan", "Mayis", "Haziran", "Temmuz", "Agustos", "Eyll", "Ekim", "Kasim", "Aralik")
			SpecialMonthName = arrMonth(intMonthNum - 1)
		Case "SL" '--- Slovenian
			arrMonth = Array("januar", "februar", "marec", "april", "maj", "junij", "julij", "avgust", "september", "oktober", "november", "december")
			SpecialMonthName = arrMonth(intMonthNum - 1)
		Case else
			SpecialMonthName = MonthName(intMonthNum)
	End Select
End Function '--- SpecialMonthName

'------- Get Custom Week Day Name ---------------------------------------------------------------
Function SpecialWeekDayName(intDayNum, sLanguage)
	Dim arrWeekDay, sWeekDayName(), hj
	Select Case sLanguage
		Case "TR" '--- Turkish
			arrWeekDay = Array("Pazar", "Pazartesi", "Sali", "arsamba", "Persembe", "Cuma", "Cumartesi")
			For hj = 1 to 7
				Redim Preserve sWeekDayName(hj)
				sWeekDayName(hj) = arrWeekDay(hj - 1)
			Next
			SpecialWeekDayName = sWeekDayName(intDayNum)
		Case "SL" '--- Slovenian
			arrWeekDay = Array("Nedelja", "Ponedeljek", "Torek", "Sreda", "Cetrtek", "Petek", "Sobota")
			For hj = 1 to 7
				Redim Preserve sWeekDayName(hj)
				sWeekDayName(hj) = arrWeekDay(hj - 1)
			Next
			SpecialWeekDayName = sWeekDayName(intDayNum)
		Case else
			SpecialWeekDayName = WeekDayName(intDayNum)
	End Select
End Function '--- SpecialWeekDayName

'--------- Format Custom Date Time --------------------------------------------------------------
Function SpecialFormatDateTime(dsDate, sFormat)
	Dim sfDay, sfMonth
	sfDay = trim(day(dsDate))
	sfMonth = trim(month(dsDate))
	Select Case sLanguage
		Case "TR" '--- Turkish
			If sFormat = 1 OR UCase(sFormat) = "VBLONGDATE" Then
				SpecialFormatDateTime = SpecialWeekDayName(WeekDay(dsDate), sLanguage) & " " & sfDay & " " & SpecialMonthName(sfMonth, sLanguage) & " " & year(dsDate)
			Else
				SpecialFormatDateTime = sfDay & "/" & sfMonth & "/" & year(dsDate)
			End if
		Case "SL" '--- Slovenian
			If sFormat = 1 OR UCase(sFormat) = "VBLONGDATE" Then
				SpecialFormatDateTime = SpecialWeekDayName(WeekDay(dsDate), sLanguage) & " " & sfDay & " " & SpecialMonthName(sfMonth, sLanguage) & " " & year(dsDate)
			Else
				SpecialFormatDateTime = sfDay & "/" & sfMonth & "/" & year(dsDate)
			End if
		Case else
			SpecialFormatDateTime = FormatDateTime(dsDate, 1)
	End Select
End Function '--- SpecialFormatDateTime

%>