<%'------------------------------------------------------------------------------------------
'-  WEB Calendar Application - Version 3.3 - 25 April 2006 
'-  Copyright  2005-2006 - Livio Siri (http://www.livio.net) - All Rights Reserved.     
'----------------------------------------------------------------------------------------------
	'--- Define calendar common variables
	Dim intFirstWeekDay, intlastday, intPrevMonth, intPrevYear, intNextMonth, intNextYear
	Dim intLastMonth, LastMonthDate, NextMonthDate, intPrintDay, dfirstday, dLastday
	Dim EndRows, intLoopDay, dToday, tToday, ActualDate, sToday, cStart, cEnd
	Dim dFirstNext, dLastNext, dNextRC, dintNextMonth, dintNextYear, dintLastDay
	Dim dN10, dNext10(), dNext10sorted, dAllSorted, dNextRCA, dAllEvents(), dNAll
	Dim UE, strPrintDay, strNextMonthDate, strLastMonthDate, sFileName, bAllEvents, sMonthName
	Dim intDNDay, intDNMonth, intDNYear, sDNToday, i, bWK, WD, WK
	Dim datToday, datFirstday, TempWeekDay, nFirstWeekDay
	Dim strFirstp
	Dim strPrevp
	Dim strNextp
	Dim strNextpEv
	Dim strLastp
	Dim strimgFirstMon
	Dim strimgPrevMon
	Dim strimgNextMon
	Dim strimgNextMonEv
	Dim strimgLastMon
	Dim strimgFirstMoff
	Dim strimgPrevMoff
	Dim strimgNextMoff
	Dim strimgNextMoffEv
	Dim strimgLastMoff
	Dim bEmptyTable
	Dim intMonthT
	Dim intMonthTemp
	Dim bHiddenEvents
	Dim bWKcolumn

'=== Calendars Functions and Subs ============================

'--- Initialize Calendar ------------------------------------------------------
Sub CalendarInit()
	'--- If logoff then close sessions
		If Request.Querystring("CalLogoff") Then
			Session("bLoginSuccessful") = False
			Session.abandon
			Response.redirect sCalendarPath
		End if
		sFileName = GetFileName(server.mappath(sCalendarPath))
	'--- Filter events by category
		If Request.Form("Select_Category") = "submitted" Then
			Session("Event_Category") = Request.Form("Event_Category")
			If LCase(Request.Form("Event_Category")) = "all" Then
				Session("Event_Category") = ""
			End if
		End if
		Call CheckCategory()
	'--- Filter Events status
		if Request.form("hfilter") = "ok" Then
			If Session("bFilterEvents") = False OR Session("bFilterEvents") = "" OR ISNULL(Session("bFilterEvents")) Then
				Session("bFilterEvents") = True
			else
				Session("bFilterEvents") = False
			end if
        end if
		If Session("bFilterEvents") = "" OR ISNULL(Session("bFilterEvents")) Then Session("bFilterEvents") = bYearlyEvents else bYearlyEvents = Session("bFilterEvents") End if
		If len(Request.QueryString("FilterEvents")) > 0 Then Session("bFilterEvents") = Request.QueryString("FilterEvents") End If
	'--- Yearly Events status
		if Request.form("hyear") = "ok" Then
			If Session("bYearlyEvents") = False OR Session("bYearlyEvents") = "" OR ISNULL(Session("bYearlyEvents")) Then
				Session("bYearlyEvents") = True
			else
				Session("bYearlyEvents") = False
			end if
        end if
		If Session("bYearlyEvents") = "" OR ISNULL(Session("bYearlyEvents")) Then Session("bYearlyEvents") = bYearlyEvents else bYearlyEvents = Session("bYearlyEvents") End if
		If len(Request.QueryString("YearlyEvents")) > 0 Then Session("bYearlyEvents") = Request.QueryString("YearlyEvents") End if
	'--- Hidden Events status
		bHiddenEvents = False
		if Request.form("hevents") = "ok" Then
			If Session("bHiddenEvents") = False OR Session("bHiddenEvents") = "" OR ISNULL(Session("bHiddenEvents")) Then
				Session("bHiddenEvents") = True
			else
				Session("bHiddenEvents") = False
			end if
        end if
		If Session("bHiddenEvents") = "" OR ISNULL(Session("bHiddenEvents")) Then Session("bHiddenEvents") = bHiddenEvents else bHiddenEvents = Session("bHiddenEvents") End if
	'--- Upcoming Events status
		if Request.form("hnext") = "ok" Then
			If Session("bUpcomingEvents") = False OR Session("bUpcomingEvents") = "" OR ISNULL(Session("bUpcomingEvents")) Then
				Session("bUpcomingEvents") = True
			else
				Session("bUpcomingEvents") = False
			end if
        end if
		If Session("bUpcomingEvents") = "" OR ISNULL(Session("bUpcomingEvents")) Then Session("bUpcomingEvents") = bUpcomingEvents else bUpcomingEvents = Session("bUpcomingEvents") end if
		If len(Request.QueryString("UpcomingEvents")) > 0 Then Session("bUpcomingEvents") = Request.QueryString("UpcomingEvents") End if
	'--- Event Manager status
		if Request.form("emgr") = "ok" Then
			bAllEvents = Session("bAllEvents")
			If bAllEvents = False OR bAllEvents = "" OR ISNULL(bAllEvents) Then
				bAllEvents = True
			else
				bAllEvents = False
			end if
			Session("bAllEvents") = bAllEvents
		End if 
	'--- Week Column status
		bWKcolumn = bWeekColumn
		if Request.form("hwk") = "ok" Then
			If Session("bWK") = False OR Session("bWK") = "" OR ISNULL(Session("bWK")) Then
				Session("bWK") = True
			else
				Session("bWK") = False
			end if
        end if
		If Session("bWK") = "" OR ISNULL(Session("bWK")) OR Session("bWK") = False Then Session("bWK") = bWeeKColumn else bWeeKColumn = Session("bWK") end if
	'--- Calendar status
		If Session("bShowCalendar") = "" OR ISNULL(Session("bShowCalendar")) Then Session("bShowCalendar") = bShowCalendar else bShowCalendar = Session("bShowCalendar") End if
		If len(Request.QueryString("Calendar")) > 0 Then
			If LCase(Request.QueryString("Calendar")) = "true" OR LCase(Request.QueryString("Calendar")) = "false" Then
				Session("bShowCalendar") = Request.QueryString("Calendar")
			End if
		End if
	'--- Navigation 
		strimgFirstMon = strimgDir & "2first.gif" '--- OnMouseOver
		strimgPrevMon = strimgDir & "2prev.gif" '--- OnMouseOver
		strimgNextMon = strimgDir & "2next.gif" '--- OnMouseOver
		strimgNextMonEv = strimgDir & "2nextEv.gif" '--- OnMouseOver
		strimgLastMon = strimgDir & "2last.gif" '--- OnMouseOver
		strimgFirstMoff = strimgDir & "22first.gif" '--- OnMouseOut
		strimgPrevMoff = strimgDir & "22prev.gif" '--- OnMouseOut
		strimgNextMoff = strimgDir & "22next.gif" '--- OnMouseOut
		strimgNextMoffEv = strimgDir & "22nextEv.gif" '--- OnMouseOut
		strimgLastMoff = strimgDir & "22last.gif" '--- OnMouseOut
		strFirstp = "<img src=""" & strimgFirstMoff & """ align=absmiddle border=1 alt="" " & strAnnoPre & " "" name=""strimgFirst"" style=""border-color:black;"">"
		strPrevp = "<img src=""" & strimgPrevMoff & """ align=absmiddle border=1 alt="" " & strMesePre & " "" name=""strimgPrev"" style=""border-color:black;"">"
		strNextp = "<img src=""" & strimgNextMoff & """ align=absmiddle border=1 alt="" " & strMeseNex & ". " & strNoEventi & " "" name=""strimgNext"" style=""border-color:black;"">"
		strNextpEv = "<img src=""" & strimgNextMoffEv & """ align=absmiddle border=1 alt="" " & strMeseNex & "." & vbcrlf & " " & Replace(strEventi2, "%1", dNextRCA) & " "" name=""strimgNextEv"" style=""border-color:black;"">"
		strLastp = "<img src=""" & strimgLastMoff & """ align=absmiddle border=1 alt="" " & strAnnoNex & " "" name=""strimgLast"" style=""border-color:black;"">"
		'--- Date controls
		ActualDate = Date()
		If IsEmpty(Request.Querystring("CalMonth")) OR NOT IsNumeric(Request.Querystring("CalMonth")) Then
		  datToday = ActualDate
		  intThisMonth = Month(datToday)
		ElseIf CInt(Request.Querystring("CalMonth")) < 1 OR CInt(Request.Querystring("CalMonth")) > 12 Then
		  datToday = ActualDate
		  intThisMonth = Month(datToday)
		Else
		  intThisMonth = CInt(Request.Querystring("CalMonth"))
		End If
		If IsEmpty(Request.Querystring("CalYear")) OR NOT IsNumeric(Request.Querystring("CalYear")) Then
		  datToday = ActualDate
		  intThisYear = Year(datToday)
		Else
		  intThisYear = CInt(Request.Querystring("CalYear"))
		End If
		sMonthName = SpecialMonthName(intThisMonth, sLanguage)
		intMonthTemp = intThisMonth

		datFirstDay = DateSerial(intThisYear, intThisMonth, 1)
		intFirstWeekDay = WeekDay(datFirstDay, vbUseSystem)
		intLastDay = GetLastDay(intThisMonth, intThisYear)
		intPrevMonth = intThisMonth - 1
		If intPrevMonth = 0 Then
			intPrevMonth = 12
			intPrevYear = intThisYear - 1
		Else
			intPrevYear = intThisYear	
		End If
		intNextMonth = intThisMonth + 1
		If intNextMonth > 12 Then
			intNextMonth = 1
			intNextYear = intThisYear + 1
		Else
			intNextYear = intThisYear
		End If

		LastMonthDate = GetLastDay(intPrevMonth, intThisYear) - intFirstWeekDay + 2

		NextMonthDate = 1
		intPrintDay = 1

		TempWeekDay= DateSerial(datepart("yyyy", date), datepart("m", date), 0)
		WD = WeekDay(TempWeekDay)
		nFirstWeekDay = TempWeekDay - (WD+6) mod 7
		nFirstWeekDay = WeekDay(nFirstWeekDay, vbUseSystem) 
	 
		dFirstDay = DateValue(LDate("1", intThisMonth, intThisYear, binternational))
		dLastDay = DateValue(LDate(intLastDay, intThisMonth, intThisYear, binternational))
'			If LCase(dbType) = "mssql" Then
'				dFirstDay = convMSSQLDate(dFirstDay)
'				dLastDay = convMSSQLDate(dLastDay)
'			End if

		If intThisMonth = 12 Then
			dintNextMonth = 1
			dintNextYear = intThisYear + 1
		Else
			dintNextMonth = intThisMonth + 1
			dintNextYear = intThisYear
		End if
		dintLastDay = GetLastDay(dintNextMonth, dintNextYear)
		dFirstNext = DateValue(LDate("1", dintNextMonth, dintNextYear, binternational))
		dLastNext = DateValue(LDate(dintLastDay, dintNextMonth, dintNextYear, binternational))
End Sub '--- CalendarInit

'------------ Store events into arrays -----------------------------------------------------
Sub StoreEvents()
	Set Rs = Server.CreateObject("ADODB.RecordSet")
	If Session("Event_Category") <> "" Then
		sSQL = 	"SELECT * FROM tblEvents WHERE Event_Category LIKE ('" & Session("Event_Category") & "') ORDER BY Start_Date ASC"
	Else
		sSQL = 	"SELECT * FROM tblEvents ORDER BY Start_Date ASC"
	End if
	Rs.Open sSQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
	If rs.RecordCount <> 0 Then
		Do While Not rs.EOF
			if (Rs("Start_date") >= dfirstNext AND Rs("End_date") <= dLastNext) _
			OR (Rs("Start_date") >= dFirstNext AND Rs("Start_date") <= dLastNext) _
			OR (Rs("End_date") >= dFirstNext AND Rs("End_date") <= dLastNext) _
			OR (DatePart("d", Rs("Start_Date")) >= DatePart("d", dFirstNext) _
			AND DatePart("m", Rs("Start_Date")) >= DatePart("m", dFirstNext) _
			AND DatePart("d", Rs("End_Date")) <= DatePart("d", dLastNext) _
			AND DatePart("m", Rs("Start_Date")) <= DatePart("m", dLastNext) _
			AND Rs("Event_Repeat") = True) _
			OR (DatePart("d", Rs("Start_Date")) >= DatePart("d", dFirstNext) _
			AND DatePart("m", Rs("Start_Date")) >= DatePart("m", dFirstNext) _
			AND DatePart("d", Rs("Start_Date")) <= DatePart("d", dLastNext) _
			AND DatePart("m", Rs("Start_Date")) <= DatePart("m", dLastNext) _
			AND Rs("Event_Repeat") = True) _
			OR (DatePart("d", Rs("End_Date")) >= DatePart("d", dFirstNext) _
			AND DatePart("m", Rs("End_Date")) >= DatePart("m", dFirstNext) _
			AND DatePart("d", Rs("End_Date")) <= DatePart("d", dLastNext) _
			AND DatePart("m", Rs("End_Date")) <= DatePart("m", dLastNext) _
			AND Rs("Event_Repeat") = True) Then
				dNextRC = dNextRC + 1
				If Rs("Event_Active") Then dNextRCA = dNextRCA + 1
			End if
			'--- Store upcoming events into array
			If (Rs("start_date") >= Date) OR (Rs("end_date") >= Date) OR (Rs("Event_Repeat") = True) Then
				dN10 = dN10 + 1
				REDIM PRESERVE dNext10(7, dN10)
				intDNDay = Day(Rs("Start_Date"))
				intDNMonth = Month(Rs("Start_Date"))
				If (Rs("start_date") >= Date) OR (Rs("end_date") >= Date) Then
					intDNYear = Year(Rs("Start_Date"))
				Else
					intDNYear = Year(Date)
				End if
				sDNToday = LDate(intDNDay, intDNMonth, intDNYear, binternational)  
				dNext10(0, dN10) = sDNToday
				dNext10(1, dN10) = Rs("Event_Title")
				dNext10(2, dN10) = Rs("Event_Active")
				dNext10(3, dN10) = Rs("Event_Repeat")
				dNext10(4, dN10) = Rs("Event_Email")
				dNext10(5, dN10) = Rs("Event_Email_Date")
				dNext10(6, dN10) = Rs("End_Date")
				dNext10(7, dN10) = Rs("Event_ID")
			End if
			'--- Store all events into array
				dNAll = dNAll + 1
				REDIM PRESERVE dAllEvents(9, dNAll)
				intDNDay = Day(Rs("Start_Date"))
				intDNMonth = Month(Rs("Start_Date"))
				intDNYear = Year(Rs("Start_Date"))
				sDNToday = LDate(intDNDay, intDNMonth, intDNYear, binternational)  
				dAllEvents(0, dNAll) = sDNToday
				dAllEvents(1, dNAll) = Rs("Event_Title")
				dAllEvents(2, dNAll) = Rs("Event_Active")
				dAllEvents(3, dNAll) = Rs("Event_Repeat")
				dAllEvents(4, dNAll) = Rs("Event_Email")
				dAllEvents(5, dNAll) = Rs("Event_Email_Date")
				dAllEvents(6, dNAll) = Rs("Event_Details")
				dAllEvents(7, dNAll) = Rs("Event_ID")
				dAllEvents(8, dNAll) = Rs("Start_Date")
				dAllEvents(9, dNAll) = Rs("End_Date")
			Rs.MoveNext
		Loop
	else
		bEmptyTable = True
	end if
	Rs.Close
	'--- Email reminder 
	If bEmailer Then
		Call EmailEvents()
	End if
	Set Rs = Nothing
	If bBorderDays Then
		W "<link href=""" & sScriptDir & "includes/_style30.css"" rel=""stylesheet"" type=""text/css"">"
	Else
		W "<link href=""" & sScriptDir & "includes/_style31.css"" rel=""stylesheet"" type=""text/css"">"
	End if
		'--- Sort arrays by column
	If isArray(dNext10) Then
		dNext10sorted = SortArray(dNext10, 0, sSort_Dir)
	End if
	If isArray(dAllEvents) then
		dAllSorted = SortArray(dAllEvents, 0, sSort_Dir)
	End if
End Sub '--- Store events

'------- Display the Calendar -------------------------------------------------
Sub TheCalendar()
	If Session("bShowCalendar") Then
		If instr(dFirstDay, ".") > 0 then
			dFirstDay = replace(dFirstDay, ".", "/")
			dLastDay = replace(dLastDay, ".", "/")
		end if
		W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 align=center><tr><td valign=top align=center style=""font-size:5px;"">" '--- Main table
	'--- Login form
		If bProtect AND Request.Querystring("CalLogin") Then
			'--- If not already logged in, show the login form
			if Not Session("bLoginSuccessful") AND NOT Request.Form("Exit") = strEventExit then
				Call Login()
			end if
		End if
		W "<div style=""font-size:13px;font-family:Verdana;font-weight:bold;color:#FF4500;"" align=center>" & strCalendario & "</div>"
		W "<table BORDER=1 CELLSPACING=1 CELLPADDING=0 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 align=center><tr><td align=center>" '--- Calendar Table
			W "<table WIDTH=""100%"" BORDER=0 CELLPADDING=0 CELLSPACING=1 BGCOLOR=#FFFFFF><tr>" '--- Nav Table
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=16>"
				W "<A href=""" & sFileName & "?" & RQString & "&CalMonth=" & IntThisMonth & "&CalYear=" & IntThisYear - 1 & """" & _
					" title="" " & strAnnoPre & " """ & _
					" onMouseOver=""document.strimgFirst.src='" & strimgFirstMon & "'""" & _
					" onMouseOut=""document.strimgFirst.src='" & strimgFirstMoff & "'"">" & strFirstp & "</A></TD>"
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=16>"
				W "<A href=""" & sFileName & "?" & RQString & "&CalMonth=" & IntPrevMonth & "&CalYear=" & IntPrevYear & """" & _
					" title="" " & strMesePre & " """ & _
					" onMouseOver=""document.strimgPrev.src='" & strimgPrevMon & "'""" & _
					" onMouseOut=""document.strimgPrev.src='" & strimgPrevMoff & "'"">" &  strPrevp & "</A></TD>"
				W "<td ALIGN=CENTER VALIGN=MIDDLE CLASS=ACTC background=""" & strImgDir & "nav_scale.gif"" style=""color:#4D6185;"">" & sMonthName & "<br>" & intThisYear & "</td>"
			if dNextRCA > 0 Then
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=lightgreen width=16>"
				W "<A href=""" & sFileName & "?" & RQString & "&CalMonth=" & IntNextMonth & "&amp;CalYear=" & IntNextYear & """" & _
					" title="" " & strMeseNex & "." & vbcrlf & " " & Replace(strEventi2, "%1", dNextRCA) & " """ & _
					" onMouseOver=""document.strimgNextEv.src='" & strimgNextMonEv & "'""" & _
					" onMouseOut=""document.strimgNextEv.src='" & strimgNextMoffEv & "'"">" & strNextpEv & "</A>"
			Else
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=15>"
				W "<A href=""" & sFileName & "?"&RQString&"&CalMonth="&IntNextMonth&"&amp;CalYear="&IntNextYear&"""" & _
					" title="" " & strMeseNex & ". " & strNoEventi & " """ & _
					" onMouseOver=""document.strimgNext.src='" & strimgNextMon & "'""" & _
					" onMouseOut=""document.strimgNext.src='" & strimgNextMoff & "'"">" & strNextp & "</A>"
			End if
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=15>"
				W "<A href=""" & sFileName & "?"&RQString&"&CalMonth="&IntThisMonth&"&amp;CalYear="&IntThisYear+1&"""" & _
					" title="" " & strAnnoNex & " """ & _
					" onMouseOver=""document.strimgLast.src='" & strimgLastMon & "'""" & _
					" onMouseOut=""document.strimgLast.src='" & strimgLastMoff & "'"">" & strLastp & "</A>"
			W "</tr></table>"
		W "</td></tr><tr><td>"
			If bBorderDays Then
				W "<table BORDER=0 CELLPADDING=1 CELLSPACING=1 ALIGN=center BGCOLOR=#FFFFFF><tr>" '--- Week Day Name and Days Table
			Else
				W "<table BORDER=0 CELLPADDING=0 CELLSPACING=1 ALIGN=center BGCOLOR=#FFFFFF><tr>" '--- Week Day Name and Days Table
			End if
			If nFirstWeekDay = 7 Then
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(2, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(2, sLanguage), 2)&"</a></td>"
			Else
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore style=""background-color:#D0D0D0;"" TITLE="" "&SpecialWeekDayName(1, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;color:navy;"">"&Left(SpecialWeekDayName(1, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(2, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(2, sLanguage), 2)&"</a></td>"
			End if
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(3, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(3, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(4, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(4, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(5, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(5, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(6, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(6, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore style=""background-color:#D0D0D0;"" TITLE="" "&SpecialWeekDayName(7, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(7, sLanguage), 2)&"</a></td>"
			If nFirstWeekDay = 7 Then
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore style=""background-color:#D0D0D0;"" TITLE="" "&SpecialWeekDayName(1, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(1, sLanguage), 2)&"</a></td>"
			End if
				If bWeekColumn Then
					W "<td ALIGN=center CLASS=ACTB Style=""background-color: #F0F0F0;padding-left:1px;"" TITLE="" " & strWK & " " & intThisYear & " "">"
					W "<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"
					W "<IMG SRC=""" & strImgDir & "drop2.gif"" WIDTH=12 HEIGHT=10 BORDER=0 ALT="" " & strWK & " " & intThisYear & " "" align=absmiddle></a></td>"
				End if
			W "</tr>"
		EndRows = False
		Do While EndRows = False
			W "<TR>"
			For intLoopDay = 1 to 7
				If intFirstWeekDay > 1 Then
					strLastMonthDate = "&nbsp;" & LastMonthDate & "&nbsp;"
					If ((intLoopDay = 1 OR intLoopDay = 7) AND NOT bInternational) OR ((intLoopDay = 6 OR intLoopDay = 7) AND bInternational) Then
						Write_TD strLastMonthDate, "NONH"
					Else
						Write_TD strLastMonthDate, "NON"
					End if
					LastMonthDate = LastMonthDate + 1
					intFirstWeekDay = intFirstWeekDay - 1
				Else
					if NextMonthDate < 10 Then strNextMonthDate =  "&nbsp;0" & NextMonthDate & "&nbsp;" Else strNextMonthDate = "&nbsp;" & NextMonthDate & "&nbsp;" End if
					If intPrintDay > intLastDay Then
						If ((intLoopDay = 1 OR intLoopDay = 7) AND NOT bInternational) OR ((intLoopDay = 6 OR intLoopDay = 7) AND bInternational) Then
							Write_TD strNextMonthDate, "NONH"
						Else
							Write_TD strNextMonthDate, "NON"
						End if
						NextMonthDate = NextMonthDate + 1
						EndRows = True 
					Else
						If intPrintDay = intLastDay Then
							EndRows = True
						End If
						sToday = LDate(intPrintDay, intThisMonth, intThisYear, binternational)  
						dToday = DateValue(sToday)  
						tToday = SpecialWeekDayName(WeekDay(DateValue(sToday)), sLanguage) & ", " & intPrintDay & " " & sMonthName & ", " & intThisYear
						if intPrintDay < 10 Then strPrintDay =  "&nbsp;0" & intPrintDay & "&nbsp;" Else strPrintDay = "&nbsp;" & intPrintDay & "&nbsp;" End if
						bEvents = False

		If Session("Event_Category") <> "" Then
			If LCase(dbType) = "access" Then
				sSQL = 	"SELECT DISTINCT Start_Date, End_Date, Event_Repeat FROM tblEvents WHERE " & _
							"((Start_Date >= #" & dFirstDay & "# AND Start_Date <= #" & dLastDay & "#)" & _
							" OR " & _
							"(End_Date >= #" & dFirstDay & "# AND End_Date <= #" & dLastDay & "#)" & _
							" OR " & _
							"(Start_Date < #" & dFirstDay & "# AND End_Date >= #" & dLastDay & "#)"  & _
							" OR " & _
							"(Event_Repeat = True))" & _
							" AND " & _
							"(Event_Active = True)" & _
							" AND " & _
							"(Event_Category LIKE ('" & Session("Event_Category") & "'))" & _
							" ORDER BY Start_Date ASC"
			Elseif LCase(dbType) = "mssql" Then
				sSQL = 	"SELECT DISTINCT Start_Date, End_Date, Event_Repeat FROM tblEvents WHERE " & _
							"((Start_Date >= '" & dFirstDay & "' AND Start_Date <= '" & dLastDay & "')" & _
							" OR " & _
							"(End_Date >= '" & dFirstDay & "' AND End_Date <= '" & dLastDay & "')" & _
							" OR " & _
							"(Start_Date < '" & dFirstDay & "' AND End_Date >= '" & dLastDay & "')"  & _
							" OR " & _
							"(Event_Repeat = 'True'))" & _
							" AND " & _
							"(Event_Active = 'True')" & _
							" AND " & _
							"(Event_Category LIKE ('" & Session("Event_Category") & "'))" & _
							" ORDER BY Start_Date ASC"
			End if
		Else
			If LCase(dbType) = "access" Then
				sSQL = 	"SELECT DISTINCT Start_Date, End_Date, Event_Repeat FROM tblEvents WHERE " & _
							"((Start_Date >= #" & dFirstDay & "# AND Start_Date <= #" & dLastDay & "#)" & _
							" OR " & _
							"(End_Date >= #" & dFirstDay & "# AND End_Date <= #" & dLastDay & "#)" & _
							" OR " & _
							"(Start_Date < #" & dFirstDay & "# AND End_Date >= #" & dLastDay & "#)"  & _
							" OR " & _
							"(Event_Repeat = True))" & _
							" AND " & _
							"(Event_Active = True)" & _
							" ORDER BY Start_Date ASC"
			Elseif LCase(dbType) = "mssql" Then
				sSQL = 	"SELECT DISTINCT Start_Date, End_Date, Event_Repeat FROM tblEvents WHERE " & _
							"((Start_Date >= '" & dFirstDay & "' AND Start_Date <= '" & dLastDay & "')" & _
							" OR " & _
							"(End_Date >= '" & dFirstDay & "' AND End_Date <= '" & dLastDay & "')" & _
							" OR " & _
							"(Start_Date < '" & dFirstDay & "' AND End_Date >= '" & dLastDay & "')"  & _
							" OR " & _
							"(Event_Repeat = 'True'))" & _
							" AND " & _
							"(Event_Active = 'True')" & _
							" ORDER BY Start_Date ASC"
			End if
		End if
		Set Rs = Server.CreateObject("ADODB.RecordSet")
		Rs.Open sSQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText

						If NOT Rs.EOF Then
							Do While NOT Rs.EOF AND bEvents = False

								if (Rs("Start_Date") <= dToday AND Rs("End_Date") >= dToday) _
								OR ((DatePart("d", Rs("Start_Date")) <= DatePart("d", dToday) _
								AND DatePart("m", Rs("Start_Date")) <= DatePart("m", dToday) _
								AND DatePart("d", Rs("End_Date")) >= DatePart("d", dToday) _
								AND DatePart("m", Rs("End_Date")) >= DatePart("m", dToday)) _
								AND Rs("Event_Repeat")) _
								OR ((DatePart("d", Rs("Start_Date")) <= DatePart("d", dToday) _
								AND DatePart("m", Rs("Start_Date")) <= DatePart("m", dToday) _
								AND DatePart("d", Rs("Start_Date")) >= DatePart("d", dToday) _
								AND DatePart("m", Rs("Start_Date")) >= DatePart("m", dToday)) _
								AND Rs("Event_Repeat")) _
								OR ((DatePart("d", Rs("End_Date")) <= DatePart("d", dToday) _
								AND DatePart("m", Rs("End_Date")) <= DatePart("m", dToday) _
								AND DatePart("d", Rs("End_Date")) >= DatePart("d", dToday) _
								AND DatePart("m", Rs("End_Date")) >= DatePart("m", dToday)) _
								AND Rs("Event_Repeat")) _
								OR (DatePart("m", Rs("Start_Date")) < DatePart("m", dToday) _
								AND DatePart("d", Rs("End_Date")) >= DatePart("d", dToday) _
								AND DatePart("m", Rs("End_Date")) >= DatePart("m", dToday) _
								AND Rs("Event_Repeat")) _
								OR (DatePart("m", Rs("End_Date")) > DatePart("m", dToday) _
								AND DatePart("d", Rs("Start_Date")) <= DatePart("d", dToday) _
								AND DatePart("m", Rs("Start_Date")) <= DatePart("m", dToday) _
								AND Rs("Event_Repeat")) Then

										If dToday = ActualDate Then
											tToday = strOggi & ": " & tToday
											If bEventsPopUp Then
												Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='EVENTTODAY' title=' " & tToday & " " + vbCrLf + " " & strEventi & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
											Else
												Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='EVENTTODAY' title=' " & tToday & " " + vbCrLf + " " & strEventi & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
											End if
										ElseIf dToday < ActualDate Then
											If bEventsPopUp Then
												Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='PASSEDEVENT' title=' " & tToday & " " + vbCrLf + " " & strEventiPassati & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
											Else
												Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='PASSEDEVENT' title=' " & tToday & " " + vbCrLf + " " & strEventiPassati & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
											End if
										Else
											If Rs("Event_Repeat") Then
												If bEventsPopUp Then
													Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='RECURSIVEEVENT' title=' " & tToday & " " + vbCrLf + " " &  Replace(strEventi2, "%1", "")  & " " + vbCrLf + " (" & strEventRepeat & ") " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
												Else
													Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='RECURSIVEEVENT' title=' " & tToday & " " + vbCrLf + " " &  Replace(strEventi2, "%1", "")  & " " + vbCrLf + " (" & strEventRepeat & ") " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
												End if
											Else
												If bEventsPopUp Then
													Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='EVENT' title=' " & tToday & " " + vbCrLf + " " &  Replace(strEventi2, "%1", "")  & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
												Else
													Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='EVENT' title=' " & tToday & " " + vbCrLf + " " &  Replace(strEventi2, "%1", "")  & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
												End if
											End if
										End if
										bEvents = True
								Else	
									Rs.MoveNext
								End If
							Loop
							Rs.MoveFirst
						End If
						If bEvents = False Then
							Dim sCss
							If datepart("w", sToday) = 7 OR datepart("w", sToday) = 1 then sCss = "SD" Else sCss = "ACT" End if
							If dToday = ActualDate Then
								tToday = strOggi & ": " & tToday
								If bEventsPopUp Then
									Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='NOEVENTTODAY' title=' " & tToday & " " + vbCrLf +" " & strNoEventi & " '>" & strPrintDay & "</A>", sCss
								Else
									Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='NOEVENTTODAY' title=' " & tToday & " " + vbCrLf +" " & strNoEventi & " '>" & strPrintDay & "</A>", sCss
								End if
							Else
								If bEventsPopUp Then
									Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='NOEVENT' title=' " & tToday & " " + vbCrLf + " " & strNoEventi & " '>" & strPrintDay & "</A>", sCss
								Else
									Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='NOEVENT' title=' " & tToday & " " + vbCrLf + " " & strNoEventi & " '>" & strPrintDay & "</A>", sCss
								End if
							End if
						End If
					End If 
						intPrintDay = intPrintDay + 1
				End If
			Next
			If bWeekColumn Then
				If bEventsPopUp Then
					Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "&CalhWK=ok','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='NOEVENT' title=' " & intThisYear & ", " & strWK & " " & SelectWeekType(sToday) & " ' style=""Color:#FF0003;"">" & SelectWeekType(sToday) & "</A>", "NON"
				Else
					Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "&CalhWK=ok"" CLASS='NOEVENT' title=' " & intThisYear & ", " & strWK & " " & SelectWeekType(sToday) & " ' style=""Color:#FF0003;"">" & SelectWeekType(sToday) & "</a>", "NON"
				End if
			End if
			W "</TR>"
		Loop 
		Rs.Close
		Set Rs = Nothing
			W "</table>"
		W "</td></tr><tr><td style=""font-size:11px;"" align=center BGCOLOR=#E9E9E9 background=""" & strImgDir & "nav_scale.gif"">"

			W "<table cellpadding=0 cellspacing=0 border=0 align=center background=""" & strImgDir & "nav_scale.gif""><tr>" '--- Icons Table
			If bProtect Then
				If Session("bLoginSuccessful") Then
					'--- Logout
					W "<td><a href=""" & sFileName & "?" & RQString & "&CalLogoff=True""><img src=""" & strImgDir & "keyoff.gif"" width=18 height=14 alt="" Logout "" align=absmiddle hspace=2 border=0></a></td>"
				Else
					'--- Login
					W "<td><a href=""" & sFileName & "?" & RQString & "&CalLogin=True&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "&CalDate=" & Request.QueryString("CalDate") & """>"
					W "<img src=""" & strImgDir & "key.gif"" width=18 height=14 alt="" Login "" align=absmiddle hspace=2 border=0></a></td>"
				End if
			End if
			   '--- Toggle hide Year
					W "<FORM name=""frmHideYear"" action=""" & sFileName & "?" & RQString & """ method=POST>"
					W "<td valign=top><input type=""checkbox"" style=""cursor:hand;width=17px;"" name=""hideyear"" value=""Enable"" onClick=""this.form.submit();"""
					If Session("bYearlyEvents") Then W " checked title="" " & strYHideUp & " "">" Else W " title="" " & strYShowUp & " "">" End if
					W "</td><input type=""hidden"" name=""hyear"" value=""ok"">"
					W "</form>"
			   '--- Toggle hide Filter
				If CountCategory() > 0 Then
					W "<FORM name=""frmHideFilter"" action=""" & sFileName & "?" & RQString & """ method=POST>"
					W "<td valign=top><input type=""checkbox"" style=""cursor:hand;width=17px;"" name=""hidefilter"" value=""Enable"" onClick=""this.form.submit();"""
					If Session("bFilterEvents") Then W " checked title="" " & strFHideUp & " "">" Else W " title="" " & strFShowUp & " "">" End if
					W "</td><input type=""hidden"" name=""hfilter"" value=""ok"">"
					W "</form>"
				End if
			   '--- Toggle hide Next10
					W "<FORM name=""frmHideNext10"" action=""" & sFileName & "?" & RQString & """ method=POST>"
					W "<td valign=top><input type=""checkbox"" style=""cursor:hand;width=17px;"" name=""hidenext10"" value=""Enable"" onClick=""this.form.submit();"""
					If Session("bUpcomingEvents") Then W " checked title="" " & Replace(strHideUp, "%1", intUpcomingEvents) & " "">" Else W " title="" " & Replace(strShowUp, "%1", intUpcomingEvents) & " "">" End if
					W "</td><input type=""hidden"" name=""hnext"" value=""ok"">"
					W "</form>"
			   '--- Toggle weekly view
				If NOT bWKColumn Then
					W "<FORM name=""frmWK"" action=""" & sFileName & "?" & RQString & """ method=POST>"
					W "<td valign=top><input type=""checkbox"" style=""cursor:hand;width=17px;"" name=""WK"" value=""Enable"" onClick=""this.form.submit();"""
					If Session("bWK") Then W " checked title="" " & strHideWK & " "">" Else W " title="" " & strShowWK & " "">" End if
					W "</td><input type=""hidden"" name=""hwk"" value=""ok"">"
					W "</form>"
				End if
				If bGuest = True AND NOT Session("bLoginSuccessful") Then
					'--- Add event
					If bEventsPopUp Then
						W "<td style=""font-size:13px;"" nowrap>[<A HREF=""#"" Title="" " & strAddEventi & " "" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=ADD','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
					Else
						W "<td style=""font-size:13px;"" nowrap>[<A HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=ADD&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ Title="" " & strAddEventi & " ""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
					End if
				End if
				'--- WARNING: REMOVING CREDITS AND LINKS TO LIVIO.NET YOU WILL VIOLATE THE LICENSE AGREEMENT
				W "<td valign=center><a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""cursor:hand;""><img src=""" & strImgDir & "h.gif"" width=16 height=14 alt="" Help "" align=absmiddle hspace=2 border=0></a></td>"
			W "</tr></table>"

		If Session("bLoginSuccessful") Then
			W "</td></tr><tr><td style=""font-size:11px;"" align=center BGCOLOR=#E9E9E9 background=""" & strImgDir & "nav_scale.gif"">"
			W "<table cellpadding=0 cellspacing=0 border=0 align=center background=""" & strImgDir & "nav_scale.gif""><tr>" '--- Icons Table
			If bProtect Then
				If Session("bLoginSuccessful") Then
					'--- Event manager
					W "<FORM name=""frmAllEvents"" action=""" & sFileName & "?" & RQString & """ method=POST><td>"
					W "<input type=""image"" src=""" & strImgDir & "setup.gif"" HEIGHT=14 width=16 border=0 align=absmiddle hspace=2 style=""cursor:hand;"" name=""eventmgr"" onClick=""this.form.frmAllEvents.submit();"" alt="" " & strEventManager & " "">"
					W "<input type=""hidden"" name=""emgr"" value=""ok"">"
					W "</td></form>"
					'--- Configuration manager
					If bEventsPopUp Then
						W "<td><A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=CONFIG&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strCalConf & " '>"
						W "<IMG SRC=""" & strImgDir & "opties.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCalConf & " "" align=absmiddle></A></td>"
						W "<td><A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strCatConf & " '>"
						W "<IMG SRC=""" & strImgDir & "categories.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCatConf & " "" align=absmiddle></A></td>"
					Else
						W "<td><A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=CONFIG&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title='  " & strCalConf & " '>"
						W "<IMG SRC=""" & strImgDir & "opties.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCalConf & " "" align=absmiddle></A></td>"
						W "<td><A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title='  " & strCatConf & " '>"
						W "<IMG SRC=""" & strImgDir & "categories.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCatConf & " "" align=absmiddle></A></td>"
					End if
					'--- Add event
					If bEventsPopUp Then
						W "<td style=""font-size:13px;"" nowrap>[<A HREF=""#"" Title="" " & strAddEventi & " "" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=ADD','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
					Else
						W "<td style=""font-size:13px;"" nowrap>[<A HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=ADD&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ Title="" " & strAddEventi & " ""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
					End if
				End if
			Else
				'--- Event manager
				W "<FORM name=""frmAllEvents"" action=""" & sFileName & "?" & RQString & """ method=POST><td>"
					W "<input type=""image"" src=""" & strImgDir & "setup.gif"" HEIGHT=14 width=16 border=0 align=absmiddle hspace=2 style=""cursor:hand;"" name=""eventmgr"" onClick=""this.form.frmAllEvents.submit();"" alt="" " & strEventManager & " "">"
				W "<input type=""hidden"" name=""emgr"" value=""ok"">"
				W "</td></form>"
				'--- Configuration manager
				If bEventsPopUp Then
					W "<td><A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=CONFIG&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strCalConf & " '>"
					W "<IMG SRC=""" & strImgDir & "opties.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCalConf & " "" align=absmiddle></A></td>"
					W "<td><A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strCatConf & " '>"
					W "<IMG SRC=""" & strImgDir & "categories.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCatConf & " "" align=absmiddle></A></td>"
				Else
					W "<td><A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=CONFIG&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title='  " & strCalConf & "  '>"
					W "<IMG SRC=""" & strImgDir & "opties.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCalConf & " "" align=absmiddle></A></td>"
					W "<td><A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title='  " & strCatConf & "  '>"
					W "<IMG SRC=""" & strImgDir & "categories.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCatConf & " "" align=absmiddle></A></td>"
				End if
				'--- Add event
				If bEventsPopUp Then
					W "<td style=""font-size:13px;"" nowrap>[<A HREF=""#"" Title="" " & strAddEventi & " "" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=ADD','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
				Else
					W "<td style=""font-size:13px;"" nowrap>[<A HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=ADD&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ Title="" " & strAddEventi & " ""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
				End if
			End if
			W "</tr></table>"
		End if

			W "</td></tr></table>"
		W "</td></tr></table>" '--- Main table end
		W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
	End if '--- Session("bShowCalendar")
End Sub '--- TheCalendar

'--- Display events filter ---------------------------------------------------
Sub FilterEvents()
		If Session("bFilterEvents") OR Request.Querystring("FilterEvents") Then
			Call SelCategory(False)
		End if
End Sub

'--- Display Upcoming or All events ---------------------------------------------------
Sub NextEvents()
		If Session("bLoginSuccessful") And Session("bAllEvents") Then
			Call AllEvents()
		Else 
			If Session("bUpcomingEvents") OR Request.Querystring("UpcomingEvents") Then
				Call UpcomingEvents()
			End if
		End if
End Sub

'--------- Write formatted Table Data ----------------------------------------------------------------
Sub Write_TD(sValue, sClass)
	W "<TD ALIGN='center' WIDTH=12 HEIGHT=14 CLASS='" & sClass & "'>" & sValue & "</TD>"
End Sub

'-------- Upcoming Events box ---------------------------------------------------
Sub UpcomingEvents()
	Dim dTemp10, d10
	Dim rYear, rMonth, dY, dM, dD
	if dN10 > 0 Then
		d10 = 0
		for UE = 0 to dN10 
			If dNext10sorted(2, UE) = True And DateDiff("s", dNext10sorted(6, UE), Date) <= 0 Then 
				d10 = d10 + 1
				If d10 = intUpcomingEvents Then Exit for
			End if
		next
		W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 align=center width=""100%""><tr><td valign=top align=center>"
		W "<table BORDER=1 CELLSPACING=1 CELLPADDING=3 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 width=""100%"" style=""font-family:tahoma;font-size:10px;"">"
		W "<tr><td background=""" & strImgDir & "nav_scale.gif"" style=""font-family:tahoma;font-size:10px;font-weight:bold;color :#4D6185;"" align=center>"
		W Replace(strEventUpcoming, "%1", d10)
		'--- Sort arrays by column
		for UE = 0 to dN10 
			rYear = Request.QueryString("CalYear")
			rMonth = Request.QueryString("CalMonth")
			If rMonth = "" Then rMonth = Month(Date)
			If rYear = "" Then rYear = year(Date)
			dY = DatePart("yyyy", dNext10sorted(0, UE))
			dM = DatePart("m", dNext10sorted(0, UE), 0, 0)
			dD = DatePart("d", dNext10sorted(0, UE))
			If dNext10sorted(3, UE) = True AND int(rMonth) = int(dM) Then
				dNext10sorted(0, UE) = DateValue(LDate(dD, dM, rYear, bInternational))
			End if
			If dNext10sorted(2, UE) = True And DateDiff("s", dNext10sorted(6, UE), Date) <= 0 Then 
				dTemp10 = dTemp10 + 1
				If dTemp10 > intUpcomingEvents Then Exit for
				w "</td></tr><tr><td>"
					If bEventsPopUp Then
						W ShortDate(dNext10sorted(0, UE), dNext10sorted(6, UE))
						If dNext10sorted(3, UE) = True Then W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "" align=absmiddle>" End if
						If dNext10sorted(4, UE) = True AND bEmailer Then W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " "" align=absmiddle>" End if
'						W "<br>"
						W "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?Event_ID="& Server.URLEncode(dNext10sorted(7, UE)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(dNext10sorted(0, UE)) & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strEventUp & " " + vbCrLf + " " & dNext10sorted(0, UE) & " ' class=LINKSTYLE>" & dNext10sorted(1, UE) & "</A>"
					Else
						W ShortDate(dNext10sorted(0, UE), dNext10sorted(6, UE))
						If dNext10sorted(3, UE) = True Then W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "" align=absmiddle>" End if
						If dNext10sorted(4, UE) = True AND bEmailer Then W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " "" align=absmiddle>" End if
'						W "<br>"
						W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&Event_ID="& Server.URLEncode(dNext10sorted(7, UE)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(dNext10sorted(0, UE)) & "&CalMonth=" & DatePart("m", dNext10sorted(0, UE)) & "&CalYear=" & DatePart("yyyy", dNext10sorted(0, UE)) & """ title=' " & strEventUp & " " + vbCrLf + " " & dNext10sorted(0, UE) & " ' class=LINKSTYLE>" & dNext10sorted(1, UE) & "</A>"
					End if
				W "</td></tr>"
			End if
		next
		W "</table>"
		W "</td></tr></table>"
		W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
	else
		W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 align=center width=""100%""><tr><td valign=top align=center>"
		W "<table BORDER=1 CELLSPACING=1 CELLPADDING=3 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 width=""100%"" style=""font-family:tahoma;font-size:10px;"">"
		W "<tr><td background=""" & strImgDir & "nav_scale.gif"" style=""font-weight:bold;color :#4D6185;"" align=center>"
		W "<span style=""font-size:9;"">0 upcoming events</span>&nbsp;&nbsp;"
		W "</td></tr></table>"
		W "</td></tr></table>"
		W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
	end if
End Sub '--- UpcomingEvents

'------- All Events management box -------------------------------------------------------------
Sub AllEvents()
	Dim intCurrentPage, intLastPage, intPageSize, intLast, dSNAll
	intPageSize = 10
	If dNAll > 0 Then
		for UE = 1 to dNAll
			If NOT dAllSorted(2, UE) Then
				dSNAll = dSNAll + 1
			End if
		next
		If NOT Session("bHiddenEvents") Then dSNAll = dNAll 
		W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 align=center width=""100%""><tr><td valign=top align=center>"
		W "<table BORDER=1 CELLSPACING=1 CELLPADDING=0 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 width=""100%"" style=""font-family:tahoma;font-size:11px;""><tr>"
		W "<td background=""" & strImgDir & "nav_scale.gif"" style=""font-weight:bold;color :#4D6185;font-size :10px;"" align=center height=21px>"
			W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 style=""font-family:tahoma;font-size:11px;"">"
			W "<tr><td style=""font-weight:bold;color :#4D6185;font-size :10px;"" align=center>"
			W Replace(strAllEvents, "%1", dSNAll) & "&nbsp;"
				If Session("bLoginSuccessful") Then 
					'--- Toggle all/hidden events
					W "</td><FORM name=""frmHiddenEvents"" action=""" & sFileName & "?" & RQString & """ method=POST><td valign=top>"
					W "<input type=""checkbox"" style=""cursor:hand;width=17px;"" name=""hiddenevents"" value=""Enable"" onClick=""this.form.submit();"""
					If Session("bHiddenEvents") Then W " checked title="" " & strEShowUp & " "">" Else W " title="" " & strEHideUp & " "">" End if
					W "<input type=""hidden"" name=""hevents"" value=""ok"">"
					W "</td></form>"
				End if
			W "</td></tr></table>"
		W "</td></tr></table>"
		W "<table BORDER=1 CELLSPACING=1 CELLPADDING=3 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 width=""100%"" style=""font-family:tahoma;font-size:11px;"">"
		If len(Request.Querystring("CalPage")) > 0 then intCurrentPage = CLng(Request.Querystring("CalPage")) Else intCurrentPage = 1 End if

		for UE = 1 to dNAll
			If (UE =< (intCurrentPage * intPageSize) AND UE > ((intCurrentPage * intPageSize) - intPageSize) AND NOT Session("bHiddenEvents")) OR (dSNAll =< (intCurrentPage * intPageSize) AND dSNAll > ((intCurrentPage * intPageSize) - intPageSize) AND Session("bHiddenEvents")) Then
				If Session("bLoginSuccessful") Then 
					If Session("bHiddenEvents") Then '--- Show hidden events only
						intLast = dSNAll
						If NOT dAllSorted(2, UE) Then  '--- IF Event NOT active
							w "<tr><td>"
							If bEventsPopUp Then
								W "<span style=""background-color:yellow;color:#F00000;"">" &  ShortDate(dAllSorted(0, UE), dAllSorted(9, UE))
								If dAllSorted(3, UE) = True Then W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "" align=absmiddle>" End if
								If dAllSorted(4, UE) = True Then W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " "" align=absmiddle>" End if
								W "<IMG SRC=""" & strImgDir & "no.gif"" BORDER=0 HEIGHT=16 WIDTH=16 alt= "" " & strEventInactive & " "" align=absmiddle></span>"
'								W "<br>"
								W "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?Event_ID="& Server.URLEncode(dAllSorted(7, UE)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(dAllSorted(0, UE)) & "&CalMonth=" & DatePart("m", dAllSorted(0, UE)) & "&CalYear=" & DatePart("yyyy", dAllSorted(0, UE)) & "&CalPage=" & intCurrentPage & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strEventUp & " " + vbCrLf + " " & dAllSorted(0, UE) & " ' class=LINKSTYLE>" & dAllSorted(1, UE) & "</A> "
							Else
								W "<span style=""background-color:yellow;color:#F00000;"">" &  ShortDate(dAllSorted(0, UE), dAllSorted(9, UE))
								If dAllSorted(3, UE) = True Then W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "" align=absmiddle>" End if
								If dAllSorted(4, UE) = True Then W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " "" align=absmiddle>" End if
								W "<IMG SRC=""" & strImgDir & "no.gif"" BORDER=0 HEIGHT=16 WIDTH=16 alt= "" " & strEventInactive & " "" align=absmiddle></span>"
'								W "<br>"
								W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&Event_ID="& Server.URLEncode(dAllSorted(7, UE)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(dAllSorted(0, UE)) & "&CalMonth=" & DatePart("m", dAllSorted(0, UE)) & "&CalYear=" & DatePart("yyyy", dAllSorted(0, UE)) & "&CalPage=" & intCurrentPage & """ title=' " & strEventUp & " " + vbCrLf + " " & dAllSorted(0, UE) & " ' class=LINKSTYLE>" & dAllSorted(1, UE) & "</A> "
							End if
						End if
					Else '--- NOT Session("bHiddenEvents")
						intLast = UE
						If NOT dAllSorted(2, UE) Then '--- IF Event NOT active
							w "<tr><td>"
							If bEventsPopUp Then
								W "<span style=""background-color:yellow;color:#F00000;"">" &  ShortDate(dAllSorted(0, UE), dAllSorted(9, UE))
								If dAllSorted(3, UE) = True Then W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "" align=absmiddle>" End if
								If dAllSorted(4, UE) = True Then W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " "" align=absmiddle>" End if
								W "<IMG SRC=""" & strImgDir & "no.gif"" BORDER=0 HEIGHT=16 WIDTH=16 alt= "" " & strEventInactive & " "" align=absmiddle></span>"
'								W "<br>"
								W "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?Event_ID="& Server.URLEncode(dAllSorted(7, UE)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(dAllSorted(0, UE)) & "&CalMonth=" & DatePart("m", dAllSorted(0, UE)) & "&CalYear=" & DatePart("yyyy", dAllSorted(0, UE)) & "&CalPage=" & intCurrentPage & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strEventUp & " " + vbCrLf + " " & dAllSorted(0, UE) & " ' class=LINKSTYLE>" & dAllSorted(1, UE) & "</A> "
							Else
								W "<span style=""background-color:yellow;color:#F00000;"">" &  ShortDate(dAllSorted(0, UE), dAllSorted(9, UE))
								If dAllSorted(3, UE) = True Then W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "" align=absmiddle>" End if
								If dAllSorted(4, UE) = True Then W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " "" align=absmiddle>" End if
								W "<IMG SRC=""" & strImgDir & "no.gif"" BORDER=0 HEIGHT=16 WIDTH=16 alt= "" " & strEventInactive & " "" align=absmiddle></span>"
'								W "<br>"
								W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&Event_ID="& Server.URLEncode(dAllSorted(7, UE)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(dAllSorted(0, UE)) & "&CalMonth=" & DatePart("m", dAllSorted(0, UE)) & "&CalYear=" & DatePart("yyyy", dAllSorted(0, UE)) & "&CalPage=" & intCurrentPage & """ title=' " & strEventUp & " " + vbCrLf + " " & dAllSorted(0, UE) & " ' class=LINKSTYLE>" & dAllSorted(1, UE) & "</A> "
							End if
						Else 
							w "<tr><td>"
							If bEventsPopUp Then
								W ShortDate(dAllSorted(0, UE), dAllSorted(9, UE))
								If dAllSorted(3, UE) = True Then W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "" align=absmiddle>" End if
								If dAllSorted(4, UE) = True Then W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " "" align=absmiddle>" End if
'								W "<br>"
								W "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?Event_ID="& Server.URLEncode(dAllSorted(7, UE)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(dAllSorted(0, UE)) & "&CalMonth=" & DatePart("m", dAllSorted(0, UE)) & "&CalYear=" & DatePart("yyyy", dAllSorted(0, UE)) & "&CalPage=" & intCurrentPage & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strEventUp & " " + vbCrLf + " " & dAllSorted(0, UE) & " ' class=LINKSTYLE>" & dAllSorted(1, UE) & "</A>"
							Else
								W ShortDate(dAllSorted(0, UE), dAllSorted(9, UE))
								If dAllSorted(3, UE) = True Then W "<IMG SRC=""" & strImgDir & "repeat1.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventRepeat & " "" align=absmiddle>" End if
								If dAllSorted(4, UE) = True Then W "<IMG SRC=""" & strImgDir & "email.gif"" BORDER=0 HEIGHT=13 WIDTH=16 alt= "" " & strEventEmail & " "" align=absmiddle>" End if
'								W "<br>"
								W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&Event_ID="& Server.URLEncode(dAllSorted(7, UE)) & "&CalendarMode=INDEX&CalDate="& Server.URLEncode(dAllSorted(0, UE)) & "&CalMonth=" & DatePart("m", dAllSorted(0, UE)) & "&CalYear=" & DatePart("yyyy", dAllSorted(0, UE)) & "&CalPage=" & intCurrentPage & """ title=' " & strEventUp & " " + vbCrLf + " " & dAllSorted(0, UE) & " ' class=LINKSTYLE>" & dAllSorted(1, UE) & "</A>"
							End if
						End if
					End if
				End if
			End if
		next
		intLastPage = int(dSNAll/intPageSize)
		if dSNAll mod intPageSize <> 0 then intLastPage = intLastPage + 1
		if intLastPage = 0 then intLastPage = 1
		w "</td></tr><tr><td>"
		Call PageNav(intCurrentPage, intLastPage)
		W "<div align=center style=""font-size:10px;font-family:tahoma;"">Events " & ((intCurrentPage * intPageSize) - intPageSize) + 1 & " to " & intLast & " of " & dSNAll & "</div>"
		W "</td></tr>"
		W "</table>"
		W "</td></tr></table>"
	Else
		W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 align=center width=""100%""><tr><td valign=top align=center>"
		W "<table BORDER=1 CELLSPACING=1 CELLPADDING=3 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 width=""100%"" style=""font-family:tahoma;font-size:10px;"">"
		W "<tr><td background=""" & strImgDir & "nav_scale.gif"" style=""font-weight:bold;color :#4D6185;"" align=center>"
		W "<span style=""font-size:9;"">0 " & Replace(strAllEvents, "%1", dSNAll) & "</span>&nbsp;&nbsp;"
		W "</td></tr></table>"
		W "</td></tr></table>"
	End if
	W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
End Sub '--- AllEvents

'-------- Yearly Events Box ------------------------------------------------------------
Sub YearlyEvents()
	If Session("bYearlyEvents") Then
		Dim nr, nr1, intLast, mevent(12), yEvents
		If dNAll > 0 Then
			yEvents = 0
			for UE = 0 to dNAll
				If (intThisYear = DatePart("yyyy", dAllEvents(8, UE), 0, 0) AND dAllEvents(3, UE) = False) OR (dAllEvents(3, UE) = True) Then
					for nr = 1 to 12
						If dAllEvents(2, UE) = True AND (DatePart("m", dAllEvents(9, UE), 0, 0) = nr OR DatePart("m", dAllEvents(0, UE), 0, 0) = nr) Then
								mevent(nr) = True
								yEvents = yEvents + 1
						End if
					next
				End if
			next
		End if
		If dNAll > 0 AND yEvents > 0 Then
			W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 align=center width=""100%""><tr><td valign=top align=center>"
			W "<table BORDER=1 CELLSPACING=1 CELLPADDING=1 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 width=""100%"" style=""font-family:tahoma;font-size:10px;"">"
			W "<tr><td background=""" & strImgDir & "nav_scale.gif"" colspan=3>"
				W "<table WIDTH=""100%"" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=#FFFFFF><tr>"
					W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=16>"
						W "<A href=""" & sFileName & "?" & RQString & "&CalMonth=" & IntThisMonth & "&CalYear=" & IntThisYear - 1 & """" & _
							" title="" " & strAnnoPre & " """ & _
							" onMouseOver=""document.strimgFirst.src='" & strimgFirstMon & "'""" & _
							" onMouseOut=""document.strimgFirst.src='" & strimgFirstMoff & "'"">" & strFirstp & "</A></TD>"
					W "<td ALIGN=CENTER VALIGN=MIDDLE CLASS=ACTC background=""" & strImgDir & "nav_scale.gif"" style=""color:#4D6185;font-family:tahoma;font-size:10px;font-weight:bold;"">" & intThisYear &  " - " & yEvents & " " & strEvents & "</td>"
						W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=15>"
						W "<A href=""" & sFileName & "?"&RQString&"&CalMonth="&IntThisMonth&"&amp;CalYear="&IntThisYear+1&"""" & _
							" title="" " & strAnnoNex & " """ & _
							" onMouseOver=""document.strimgLast.src='" & strimgLastMon & "'""" & _
							" onMouseOut=""document.strimgLast.src='" & strimgLastMoff & "'"">" & strLastp & "</A>"
					W "</td></tr></table>"
				W "</td></tr>"
					for nr = 1 to 12
						If mevent(nr) = True Then
							w "</td>"
							If nr = 4 OR nr = 7 Or nr = 10 Then w "</tr><tr>" End if
							W "<td align=center bgcolor=#DCEEDC"
							If nr = intThisMonth Then W " Style=""border-right:1px #F00000 solid;border-top:1px #F00000 solid;border-bottom:1px #F00000 solid;border-left:4px #F00000 solid;""" End if
							W ">"
								If bEventsPopUp Then
									W "&nbsp;<A target=_self HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalMonth=" & nr & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & SpecialMonthName(nr, sLanguage) & " " & intThisYear & ", " & Replace(strEventi2, "%1", "") & " ' class=LINKSTYLE>"
									W left(SpecialMonthName(nr, sLanguage), 3) & "</a>&nbsp;"
'									W SpecialMonthName(nr, sLanguage) & "</a>&nbsp;"
								Else
									W "&nbsp;<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalMonth=" & nr & "&CalYear=" & intThisYear & """ title=' " & SpecialMonthName(nr, sLanguage) & " " & intThisYear & ", " & Replace(strEventi2, "%1", "") & " ' class=LINKSTYLE>"
									W left(SpecialMonthName(nr, sLanguage), 3) & "</a>&nbsp;"
'									W SpecialMonthName(nr, sLanguage) & "</a>&nbsp;"
								End if
						Else
							w "</td>"
							If nr = 4 OR nr = 7 Or nr = 10 Then w "</tr><tr>" End if
							W "<td align=center"
							If nr = intThisMonth Then W " Style=""border-right:1px #F00000 solid;border-top:1px #F00000 solid;border-bottom:1px #F00000 solid;border-left:4px #F00000 solid;""" End if
							W ">"
								If bEventsPopUp Then
									W "&nbsp;<A target=_self HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalMonth=" & nr & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & SpecialMonthName(nr, sLanguage) & " " & intThisYear & ", " & strNoEventi & " ' class=LINKSTYLE>"
									W left(SpecialMonthName(nr, sLanguage), 3) & "</a>&nbsp;"
'									W SpecialMonthName(nr, sLanguage) & "</a>&nbsp;"
								Else
									W "&nbsp;<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalMonth=" & nr & "&CalYear=" & intThisYear & """ title=' " & SpecialMonthName(nr, sLanguage) & " " & intThisYear & ", " & strNoEventi & " ' class=LINKSTYLE>"
									W left(SpecialMonthName(nr, sLanguage), 3) & "</a>&nbsp;"
'									W SpecialMonthName(nr, sLanguage) & "</a>&nbsp;"
								End if
						End if
					next
				W "</td></tr></table>"
			W "</td></tr></table>"
			W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
		else
			W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 align=center width=""100%""><tr><td valign=top align=center>"

			W "<table BORDER=1 CELLSPACING=1 CELLPADDING=1 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 width=""100%"" style=""font-family:tahoma;font-size:10px;"">"
			W "<tr><td background=""" & strImgDir & "nav_scale.gif"">"

				W "<table WIDTH=""100%"" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=#FFFFFF><tr><td background=""" & strImgDir & "nav_scale.gif"">"
						W "<A href=""" & sFileName & "?" & RQString & "&CalMonth=" & IntThisMonth & "&CalYear=" & IntThisYear - 1 & """" & _
							" title="" " & strAnnoPre & " """ & _
							" onMouseOver=""document.strimgFirst.src='" & strimgFirstMon & "'""" & _
							" onMouseOut=""document.strimgFirst.src='" & strimgFirstMoff & "'"">" & strFirstp & "</A></TD>"
					W "<td ALIGN=CENTER VALIGN=MIDDLE CLASS=ACTC background=""" & strImgDir & "nav_scale.gif"" style=""color:#4D6185;font-family:tahoma;font-size:10px;font-weight:bold;"" nowrap width=""100%"">" & intThisYear & " - 0 " & strEvents & "</td>"
						W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=15>"
						W "<A href=""" & sFileName & "?"&RQString&"&CalMonth="&IntThisMonth&"&amp;CalYear="&IntThisYear+1&"""" & _
							" title="" " & strAnnoNex & " """ & _
							" onMouseOver=""document.strimgLast.src='" & strimgLastMon & "'""" & _
							" onMouseOut=""document.strimgLast.src='" & strimgLastMoff & "'"">" & strLastp & "</A>"
					W "</td></tr></table>"
					W "</td></tr></table>"
					W "</td></tr></table>"
				W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
		end if
	End if
End Sub '--- YearlyEvents

'-------- Email reminder ------------------------------------------------------------
Sub EmailEvents()
	Dim stSQL, sSubject, sEmailBody, d5UETemp, d5UETemp1, d8UETemp, d8UETemp1, goEmail
	'--- set go email to false
	goEmail = False
		if dNAll > 0 Then '-- if there are some stored events
			for UE = 0 to dNAll '--- loop through all stored events
				If IsDate(dAllEvents(5, UE)) Then '--- if any date has been strored for that event means it has been already sent in the past, then check it
					d5UETemp = DateDiff("yyyy", dAllEvents(5, UE), Now()) '--- Calculate how many years ago
					d5UETemp1 = DateAdd("yyyy", d5UETemp, dAllEvents(5, UE)) '--- Add year to temp event date
					If d5UETemp > 0 Then '--- If it is an yearly recursive event already sent, but more than one year ago
						If DateDiff("d", Now(), d5UETemp1 + intEmailDays) <= intEmailDays AND dAllEvents(4, UE) AND dAllEvents(2, UE) Then
						'--- if days difference is inside the selected days range AND event is active AND event has to be emailed
							goEmail = True
							Call Emailer(sSubject, sEmailBody) '--- call emailer routines
						End if
					End if
				Else '--- event never sent
					d8UETemp = DateDiff("yyyy", dAllEvents(8, UE), Now()) '--- Calculate how many years ago
					d8UETemp1 = DateAdd("yyyy", d8UETemp, dAllEvents(8, UE)) '--- Add year to temp event date
					If d8UETemp <> 0 AND dAllEvents(3, UE) Then '--- If it is an yearly recursive event not yet sent
						If DateDiff("d", Now(), d8UETemp1) <= intEmailDays AND dAllEvents(4, UE) AND dAllEvents(2, UE) Then
						'--- if days difference is inside the selected days range AND event is active AND event has to be emailed
							goEmail = True
							Call Emailer(sSubject, sEmailBody) '--- call emailer routines
						End if
					Else '--- It is a non recursive upcoming event not yet emailed
						If DateDiff("d", Now(), dAllEvents(8, UE), UE + intEmailDays) <= intEmailDays AND dAllEvents(4, UE) AND dAllEvents(2, UE) Then
						'--- if days difference is inside the selected days range AND event is active AND event has to be emailed
							goEmail = True
							Call Emailer(sSubject, sEmailBody) '--- call emailer routines
						End if
					End if
				End if
				If goEmail Then
					'--- store the email sending date in the database
					stSQL = "SELECT * FROM tblEvents WHERE Event_ID=" & dAllEvents(7, UE)
					Rs.Open stSQL, sCalendarDSN, adOpenKeySet, adLockPessimistic, adCmdText
						Rs("Event_Email_Date") = Now()
						Rs.Update
					Rs.Close
					goEmail = False '--- force goEmail to false for the next loop
				End if
			next
		end if
End Sub '--- EmailEvents

'------------ Send email -------------------------------------------------
Sub Emailer(sSubject, sEmailBody)
	If NOT Session("DisableAction") Then
		Dim bHTMLemail
		If sFormat = "HTML" Then bHTMLEmail = true
		'--- build the email text
		sSubject = sFrom & " " & dAllEvents(1, UE)
		If sFormat = "HTML" Then '--- (added to prepare a customized HTML text for email)
			sEmailBody = "Upcoming event reminder<br>" & strEventDate & ": " & SpecialFormatDateTime(dAllEvents(8, UE), 1) & "<br><br>" & strEventTitle & ": " & dAllEvents(1, UE) & "<br><br>" & strEventDetails & ": " & Replace(dAllEvents(6, UE),vbCrlf,"<br>")
		Else
			sEmailBody = "Upcoming event reminder<br>" & strEventDate & ": " & SpecialFormatDateTime(dAllEvents(8, UE), 1) & "<br><br>" & strEventTitle & ": " & dAllEvents(1, UE) & "<br><br>" & strEventDetails & ": " & Replace(dAllEvents(6, UE),vbCrlf,"<br>")
		End If
'		On error resume next
		Select Case sMailObject
			'--------------------
			Case "CDOSYS"
				DIM iMsg, Flds, iConf
				Set iMsg = CreateObject("CDO.Message")
				Set iConf = CreateObject("CDO.Configuration")
				Set Flds = iConf.Fields
					Flds("http://schemas.microsoft.com/cdo/configuration/urlgetlatestversion") = True
					Flds.Update
						With iMsg
						   Set .Configuration = iConf
						   .To = smailrecipient
						   .Bcc = smailrecipientBcc
						   .From = sAdministratorsEmail
						   .Sender = sAdministratorsEmail
						   .Subject = sSubject
						If bHTMLEmail Then
						   .HTMLBody = sEmailBody
						Else
						   .TextBody = sEmailBody
						End if
						   .Send
						End With
				Set iMsg = Nothing
				Set iConf = Nothing
				Set Flds = Nothing
			'--------------------
			Case "JMail"
			   Dim JMail
			   Set JMail = Server.CreateObject("JMail.SMTPMail") 
				With JMail
					.ServerAddress = smailserveraddress
					.Sender = sAdministratorsEmail 
					.Subject = sSubject
					.AddRecipient smailrecipient
				If len(smailrecipientBcc) > 0 Then
					.AddRecipientBcc smailrecipientBcc
				End if
				If bHTMLEmail Then
					.ContentType = "text/html" 
					.Body = sEmailBody
				Else
					.ContentType = "text/plain" 
					.Body = sEmailBody
				End if
					.Priority = 1
					.AddHeader "Originating-IP", Request.ServerVariables("REMOTE_ADDR")
					.Execute
				End With
				Set JMail = nothing 
			'--------------------
			Case "CDONTS"
			   Dim objMail
			   Set objMail = CreateObject("CDONTS.NewMail") 
				With obJMail
				   .From = sAdministratorsEmail
				   .To = smailrecipient
				   .Bcc = smailrecipientBcc
				   .Subject = sSubject
				   .Body = sEmailBody
				   .Send 
				End With
				Set objMail = nothing 
			'--------------------
			Case "AspEmail"
			   Dim objAspEmail
			   Set objAspEmail = Server.CreateObject("Persits.MailSender")
				With objAspEmail
					.Host = smailserveraddress 		'Out going SMTP mail server address
					.Port = 25									'Out going mail server port
					.From = sAdministratorsEmail 		'Who the e-mail is from
					.AddAddress smailrecipient			'Who the e-mail is sent to
					.AddBcc smailrecipientBcc			'The Bcc subject of the e-mail
					.Subject = sSubject					'The subject of the e-mail
					If bHTMLEmail Then
						.IsHTML = True						'Set the e-mail body to HTML
						.Body = sEmailBody 				'The main HTML body of the e-mail
					Else
						.IsHTML = False						'Set the e-mail body to TXT
						.Body = sEmailBody 				'The main TXT body of the e-mail
					End if
					If NOT serveraddress = "" Then .Send	'Send the e-mail
				End With										'Close the server mail object
				Set objAspEmail = Nothing
		End select
'		On error goto 0
	End If
End Sub '--- Emailer

'----------------------------------------------------------------------------------------
'-  ASP Page Navigation Function - Version 2.0 - 01 June 2005 
'-  Copyright  2005 - Livio Siri (http://www.livio.net) - All Rights Reserved.     
'----------------------------------------------------------------------------------------
Public Function PageNav(ByRef intCurrentPage, ByVal intLastPage)
	'--- Define variables
	Dim strQueryString
	Dim strScript
	Dim strSel
	Dim strPaging
	'--- Assumes that the paging request variable is named 'page'
	If Not IsEmpty(Request.Querystring("CalPage")) Then
		if IsNumeric(Request.Querystring("CalPage")) Then
			intCurrentPage = CLng(Request.Querystring("CalPage"))
		End if
	End if
	'--- Page limit control
	If intCurrentPage > intLastPage Then
		intCurrentPage = intLastPage
	ElseIf intCurrentPage < 1 Then 
		intCurrentPage = 1
	End if
	strFirstp = "<img src=""" & strimgFirstMoff & """ align=absmiddle border=1 alt="" " & strFirstpTitle & strPagep &" "" name=""strimgFirst"" style=""border-color:black;"">"
	strPrevp = "<img src=""" & strimgPrevMoff & """ align=absmiddle border=1 alt="" " & strPrevpTitle & "(" & strPagep & intCurrentPage - 1 & strOfp & intLastPage & ") "" name=""strimgPrev"" style=""border-color:black;"">"
	strNextp = "<img src=""" & strimgNextMoff & """ align=absmiddle border=1 alt="" " & strNextpTitle & "(" & strPagep & intCurrentPage + 1 & strOfp & intLastPage & ") "" name=""strimgNext"" style=""border-color:black;"">"
	strLastp = "<img src=""" & strimgLastMoff & """ align=absmiddle border=1 alt="" " & strLastpTitle & "(" & strPagep & intLastPage & strOfp & intLastPage & ") "" name=""strimgLast"" style=""border-color:black;"">"
	'--- Include the result into a Table and define text style
	strPaging = "<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 align=center style=""font-family:verdana,arial;font-size:11px;""><TBODY>"
	strPaging = strPaging & "<form method=POST name=""frmPage"" action=""" & sFileName & "?" & RQString & """><TR><TD valign=middle align=center>"
	If intLastPage = 1 Then
		'--- If there is only one page then tell it
		strPaging = strPaging & strAll
	Else
		'--- Show page navigation
		For i = 1 To Request.QueryString.Count
			if LCase(Request.QueryString.Key(i)) <> "calpage" Then
				strQueryString = strQueryString & "&" & Server.URLEncode(Request.QueryString.Key(i)) & "=" & Server.URLEncode(Request.QueryString.Item(i))
			End if
		Next
		For i = 1 To Request.Form.Count
			if LCase(Request.Form.Key(i)) <> "calpage" Then
				strQueryString = strQueryString & "&" & Server.URLEncode(Request.Form.Key(i)) & "=" & Server.URLEncode(Request.Form.Item(i))
			End if
		Next
		if Len(strQueryString) <> 0 Then
			strQueryString = "?" & Mid(strQueryString, 2) & "&"
		Else
			strQueryString = "?"
		End if
		strScript = Request.ServerVariables("SCRIPT_NAME") & strQueryString
		If intCurrentPage <> 1 Then 
			If intCurrentPage > 2 Then
				strPaging = strPaging & "<A href=""" & strScript & "CalPage=1"" title=""" & strFirstpTitle & strPagep &"""" & _
													" onMouseOver=""document.strimgFirst.src='" & strimgFirstMon & "'""" & _
													" onMouseOut=""document.strimgFirst.src='" & strimgFirstMoff & "'"">" & _
														strFirstp & "</A>&nbsp;</TD><TD valign=middle>"
			End if
			strPaging = strPaging & "<A href=""" & strScript & "CalPage=" & intCurrentPage - 1 & """ title=""" & strPrevpTitle & "(" & strPagep & intCurrentPage - 1 & ")""""" & _
												" onMouseOver=""document.strimgPrev.src='" & strimgPrevMon & "'""" & _
												" onMouseOut=""document.strimgPrev.src='" & strimgPrevMoff & "'"">" & _
													strPrevp & "</A>&nbsp;</TD><TD valign=middle>"
		End if
		strPaging = strPaging & "</td><TD valign=middle><select name=""CalPage"" style=""font-family:verdana,arial;font-size:12px;height:18px;background-color:#F3F3F3;color:red;border:solid 1px black;font-weight:bold;"" onchange=""document.location = '" & strScript & "CalPage=' + document.frmPage.CalPage.value;"">"
		For i = 1 to intLastPage
			if i = intCurrentPage Then strSel = " selected style=""color:red;""" Else strSel = " style=""color:black;""" End if
			strPaging = strPaging & "<option value=" & i & strSel & ">" & i & "</option>"
		Next
		strPaging = strPaging & "</select>"
		strPaging = strPaging & "<input type=hidden name=CalMonth value=" & Request.Querystring("CalMonth") & ">"
		strPaging = strPaging & "<input type=hidden name=CalYear value=" & Request.Querystring("CalYear") & ">"
		If intCurrentPage <> intLastPage Then
			strPaging = strPaging & "</TD><TD valign=middle>&nbsp;<A href=""" & strScript & "CalPage=" & intCurrentPage + 1 & """ title=""" & strNextpTitle & "(" & strPagep & intCurrentPage + 1 & ")""""" & _
											" onMouseOver=""document.strimgNext.src='" & strimgNextMon & "'""" & _
											" onMouseOut=""document.strimgNext.src='" & strimgNextMoff & "'"">" & _
												strNextp & "</A>"
			If intCurrentPage < intLastPage - 1 Then 
				strPaging = strPaging & "</TD><TD valign=middle>&nbsp;<A href=""" & strScript & "CalPage=" & intLastPage & """ title=""" & strLastpTitle & "(" & strPagep & intLastPage & ")""""" & _
													" onMouseOver=""document.strimgLast.src='" & strimgLastMon & "'""" & _
													" onMouseOut=""document.strimgLast.src='" & strimgLastMoff & "'"">" & _
														strLastp & "</A>"
			End if
		End if
	End if
	strPaging = strPaging & "</TD></TR></form></TBODY></TABLE>"
	PageNav = Response.Write(strPaging)
End Function '-- PageNav

'-------- Login Form --------------------------------------------------------------------------------
Sub Login()
	'--- Define variables
	Dim bLoginSuccessful, strError
	Dim sUserName, sPassword
	'--- If NO login then show login
	If Not Session("bLoginSuccessful") then
		'--- If Login Form has been submitted
		If Request.Form("Status") = "FormSubmitted" then
			sUserName = replace(Request("txtUserName"),"'","")
			sPassword = replace(Request("txtPassword"),"'","")
			'--- Check for username and password
			If sUserName = UserName AND sPassword = Password then
				bLoginSuccessful = True
			Else
				bLoginSuccessful = False
				strError = " Login refused"
			End if
			Session("bLoginSuccessful") = bLoginSuccessful
		End if
		'--- Show login form
		If NOT bLoginSuccessful Then
			W "<table border=0 cellpadding=0 cellspacing=1 align=center width=""100%"" style=""border:1px solid #999999;background-color:#FFFFFF;font-family:verdana;font-size:10px;"">"
				W "<form action=""" & sFileName & "?" & RQString & "&CalLogin=True"" method=POST name=frmLogin>"
				W "<tr><td align=center bgcolor=#FFFFFF>"
					W "<table border=0 cellpadding=2 cellspacing=0 style=""border:1px solid #999999"" width=""100%"" style=""font-family:verdana;font-size:10px;"">"
					W "<tr><td align=center bgcolor=#F0F0F0 background=""" & strImgDir & "nav_scale.gif"">"
					W "<div style=""color:#4D6185;font-size:10px;"">"
					'--- Show error when credentials are incorrect 
					if strError <> "" then W "<b style=""color:red;font-weight:bold;"">" & strError Else W "<b>Calendar Login</b>" End if
					W "</div></td></tr></table>" 
			W "</td></tr><tr><td>"
			'--- Write the login form
				W "<table border=0 cellpadding=2 cellspacing=0 style=""font-family:verdana;font-size:10px;"" align=center><tr>"
					W "<td align=right nowrap style=""font-family:verdana;font-size:10px;""><b>User:</b></td>"
					W "<td><input type=Text name=txtUserName size=17 Class=BUT></td></tr><tr>"
					W "<td align=right style=""font-family:verdana;font-size:10px;""><b>Pswd:</b></td>"
					W "<td><input type=Password name=txtPassword size=17 Class=BUT></td>"
					W "<tr><td>&nbsp;</td><td align=center>"
					W "<input type=submit size=23 name=Login value=Login style=""font-weight:bold;cursor:hand;color :#4D6185;"" title="" Send login "" Class=BUT>"
					W "<input type=submit size=23 name=Exit value=" & strEventExit & " style=""font-weight:bold;cursor:hand;color :#4D6185;"" title="" " & strEventExit & " "" Class=BUT>"
					W "<input type=hidden name=Status value=FormSubmitted>"
				W "</td></form></tr></table>"
			W "</td></tr></table>&nbsp;"
		End if
	Else
		W "You are already logged in !!"
	End if
End Sub '--- Login

'------- Get the file name from path -----------------------------------------
Public function GetFileName(ByVal strGetPath)
	Dim nPos, strFilename, strDir
	strFilename = ""
	strGetPath = cstr(strGetPath)
	if Not len(strGetPath) = 0 Then
		nPos = InStrRev(strGetPath, "\", Len(strGetPath))
		if nPos > 0 Then
			strFilename = Right(strGetPath, Len(strGetPath) - nPos)
			'Response.Write strFilename
		End if
		nPos = InstrRev(strGetPath, "\", Len(strGetPath) - nPos)
		if nPos > 0 Then
			strDir = Right(strGetPath, Len(strGetPath) - nPos)
		Else
			strDir = ""
		End if 
	End if
	GetFilename = strFilename
End function '--- GetFileName

'-------- Format Date display ---------------------------------------------------
Function ShortDate(inDate, inEDate)
	Dim inDay, inMonth, inYear, inEDay, inEMonth, bMulti, inSDay
	inEDay = Day(inEDate)
	inEMonth = SpecialMonthName(Month(inEDate), sLanguage)
	inDay = Day(inDate)
	inMonth = SpecialMonthName(Month(inDate), sLanguage)
'	inYear = right(Year(inDate), 2)
	inYear = Year(inDate)
	if len(inDay) = 1 then inDay = "0" & inDay End if
	inSDay = inDay
	if len(inMonth) = 1 then inMonth = "0" & inMonth End if
	if len(inEDay) = 1 then inEDay = "0" & inEDay End if
	if len(inEMonth) = 1 then inEMonth = "0" & inEMonth End if
	if len(inEDay) > 0 AND inDay <> inEDay then inSDay = inSDay & "-" & inEDay End if
	if len(inEMonth) > 0 AND inMonth <> inEMonth then bMulti = True End if
	If bMulti Then
		If bInternational Then
			ShortDate = "<span style=""font-family:Tahoma, Verdana, Arial; font-size:10px;"">" & inDay & "/" & inMonth & " - " &  inEDay & "/" & inEMonth & ", " & inYear & "</span>"
		Else
			ShortDate = "<span style=""font-family:Tahoma, Verdana, Arial; font-size:10px;"">" & inMonth & "/" & inDay & " - " & inEMonth & "/" & inEDay & ", " & inYear & "</span>"
		End if
	Else
		If bInternational Then
			ShortDate = "<span style=""font-family:Tahoma, Verdana, Arial; font-size:10px;"">" & inSDay & "/" & inMonth & "/" & inYear & "</span>"
		Else
			ShortDate = "<span style=""font-family:Tahoma, Verdana, Arial; font-size:10px;"">" & inMonth & "/" & inSDay & "/" & inYear & "</span>"
		End if
	End if
End Function '--- ShortDate

'-------- Category select ---------------------------------------------------
Sub SelCategory(bFull)
	Dim rsCatDetails, strCategorySQL, sSelect, sWidth
	If CountCategory() > 0 Then
		If bEventsPopUp Then
			W "<script language=""javascript"" type=""text/javascript"">"
				W "<!--"
				W "function sendme(){ "
				W "window.open('','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes');"
				W "document.selcatfrm.target = 'calendarpop';"
				W "var a = window.setTimeout('document.selcatfrm.submit();',500);"
				W "}"
				W "// -->"
			W "</script>"
		End If
		If Not bFull Then
			W "<TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 style=""font-family:verdana;font-size:10px;"" align=center width=""100%"" bgcolor=#FFFFFF>"
			If bEventsPopUp Then
				W "<FORM NAME=""selcatfrm"" ACTION=""" & sScriptDir & "popevents.asp?" & RQString & "&CalDate=" & sEvent_Date & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ METHOD=POST target=""calendarpop"">"
			Else
				W "<FORM NAME=""selcatfrm"" ACTION=""" & sFileName & "?" & RQString & "&CalDate=" & sEvent_Date & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ METHOD=POST>"
			End if
		Else
			W "<TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 style=""font-family:verdana;font-size:10px;"" bgcolor=#FFFFFF>"
			If bEventsPopUp Then
				W "<FORM NAME=""selcatfrm1"" ACTION=""" & sScriptDir & "popevents.asp?" & RQString & "&CalDate=" & sEvent_Date & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ METHOD=POST target=""calendarpop"">"
			Else
				W "<FORM NAME=""selcatfrm1"" ACTION=""" & sFileName & "?" & RQString & "&CalDate=" & sEvent_Date & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ METHOD=POST>"
			End if
		End if
		W "<TR><TD VALIGN=TOP>"
			If Not bFull Then
				W "<table BORDER=1 CELLSPACING=1 CELLPADDING=1 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 width=""100%"" style=""font-family:tahoma;font-size:10px;"">"
				W "<tr><td CLASS=ACTC background=""" & strImgDir & "nav_scale.gif"" style=""color:#4D6185;"" align=center height=20>"
				W strFilterEvents
				W "</td></tr></table>"
				W "</td></tr><tr><td>"
				If bEventsPopUp Then
					W "<Select  NAME=""Event_Category"" class=cal style=""width:100%;border: 1px solid #CCCCCC;"" size=" & CountCategory() + 1 & " onChange=""sendme();"">"
				Else
					W "<Select  NAME=""Event_Category"" class=cal style=""width:100%;border: 1px solid #CCCCCC;"" size=" & CountCategory() + 1 & " onChange=""document.selcatfrm.submit();"">"
				End If
			Else
				If bEventsPopUp Then
					W "<Select  NAME=""Event_Category"" class=cal style=""border: 1px solid #CCCCCC;"" onChange=""sendme();"">"
				Else
					If Not bFull Then
						W "<Select  NAME=""Event_Category"" class=cal style=""border: 1px solid #CCCCCC;"" onChange=""document.selcatfrm.submit();"">"
					Else
						W "<Select  NAME=""Event_Category"" class=cal style=""border: 1px solid #CCCCCC;"" onChange=""document.selcatfrm1.submit();"">"
					End if
				End If
			End if
		If Session("Event_Category") = "" Then sSelect = " Selected" Else sSelect = " style=""color:#4D6185;""" End if
		W "<Option " & sSelect & " Value="""">" & strCat & "</option>"
			Set rsCatDetails = Server.CreateObject("ADODB.Recordset")
			strCategorySQL = "SELECT * FROM tblCategory ORDER BY sCategory ASC;"
			rsCatDetails.Open strCategorySQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
			If rsCatDetails.RecordCount <> 0 Then
				'--- Read in category details from the recordset
				For i = 1 to rsCatDetails.RecordCount
					If Session("Event_Category") = rsCatDetails("sCategory") Then sSelect = " Selected" Else sSelect = " style=""color:#4D6185;""" End if
					W "<Option " & sSelect & " Value='" & rsCatDetails("sCategory") & "'>" & rsCatDetails("sCategory") & "</option>"
					rsCatDetails.MoveNext
				Next
				rsCatDetails.Close
			End If
		Set rsCatDetails = Nothing
		W "</Select>"
		W "<INPUT TYPE=HIDDEN NAME=""Select_Category"" VALUE=""submitted"">"
		W "</TD></FORM></FORM></TR></TABLE>"
		If Not bFull Then W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>" End if
	End if
End sub '--- SelCategory

'-------- Categories counter---------------------------------------------------
Function CountCategory()
	Dim rsCatDetails, strCategorySQL
	Set rsCatDetails = Server.CreateObject("ADODB.Recordset")
	strCategorySQL = "SELECT * FROM tblCategory;"
	rsCatDetails.Open strCategorySQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
		rsCatRC = rsCatDetails.RecordCount
	rsCatDetails.Close
	Set rsCatDetails = Nothing
	CountCategory = rsCatRC
End Function '--- CountCategory

'-------- Category check---------------------------------------------------
Sub CheckCategory()
	Dim rsCatDetails, strCategorySQL
	Set rsCatDetails = Server.CreateObject("ADODB.Recordset")
	strCategorySQL = "SELECT * FROM tblCategory;"
	rsCatDetails.Open strCategorySQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
	For i = 1 to rsCatDetails.RecordCount
		If LCase(Request.QueryString("Category")) = LCase(rsCatDetails("sCategory")) Then
			Session("Event_Category") = rsCatDetails("sCategory")
			Exit For
		ElseIf LCase(Request.QueryString("Category")) = "all" Then
			Session("Event_Category") = ""
			Exit For
		End if
		rsCatDetails.MoveNext
	Next
	rsCatDetails.Close
	Set rsCatDetails = Nothing
End Sub '--- CheckCategory

'------- Display the Yearly Calendar -------------------------------------------------
Sub TheYearlyCalendar()
	Dim dFirstDayOfYear, dLastDayOfYear
	If Session("bShowCalendar") Then
		Dim nr, nr1, intLast, mevent(12), yEvents
		If dNAll > 0 Then
			yEvents = 0
			for UE = 0 to dNAll
				If (intThisYear = DatePart("yyyy", dAllEvents(8, UE), 0, 0) AND dAllEvents(3, UE) = False) OR (dAllEvents(3, UE) = True) Then
					for nr = 1 to 12
						If dAllEvents(2, UE) = True AND (DatePart("m", dAllEvents(9, UE), 0, 0) = nr OR DatePart("m", dAllEvents(0, UE), 0, 0) = nr) Then
								mevent(nr) = True
								yEvents = yEvents + 1
						End if
					next
				End if
			next
		End if
		If yEvents = 0 Then yEvents = "0"
	W "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 align=center><tr><td valign=top align=center style=""font-size:5px;"">" '--- Main table
		'--- Login form
		If bProtect AND Request.Querystring("CalLogin") Then
			'--- If not already logged in, show the login form
			if Not Session("bLoginSuccessful") AND NOT Request.Form("Exit") = strEventExit then
				Call Login()
			end if
		End if
		W "<table BORDER=1 CELLSPACING=1 CELLPADDING=0 BGCOLOR=#FFFFFF BORDERCOLOR=#999999 align=center><tr><td align=center>" '--- Calendar Table

			W "<table WIDTH=""100%"" BORDER=0 CELLPADDING=0 CELLSPACING=1 BGCOLOR=#FFFFFF><tr>" '--- Nav Table
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=16>"
				W "<A href=""" & sFileName & "?" & RQString & "&CalMonth=" & IntThisMonth & "&CalYear=" & IntThisYear - 1 & """" & _
					" title="" " & strAnnoPre & " """ & _
					" onMouseOver=""document.strimgFirst.src='" & strimgFirstMon & "'""" & _
					" onMouseOut=""document.strimgFirst.src='" & strimgFirstMoff & "'"">" & strFirstp & "</A></TD>"
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=16>"
				W "<A href=""" & sFileName & "?" & RQString & "&CalMonth=" & IntPrevMonth & "&CalYear=" & IntPrevYear & """" & _
					" title="" " & strMesePre & " """ & _
					" onMouseOver=""document.strimgPrev.src='" & strimgPrevMon & "'""" & _
					" onMouseOut=""document.strimgPrev.src='" & strimgPrevMoff & "'"">" &  strPrevp & "</A></TD>"
				W "</td><td align=left VALIGN=MIDDLE CLASS=ACTC background=""" & strImgDir & "nav_scale.gif"" style=""color:#4D6185;"">"

			W "<table cellpadding=0 cellspacing=0 border=0 align=center background=""" & strImgDir & "nav_scale.gif""><tr>" '--- Icons Table
				W "<td ALIGN=right VALIGN=MIDDLE CLASS=ACTC background=""" & strImgDir & "nav_scale.gif"" style=""color:#4D6185;"">"
					W "<IMG SRC=""" & strImgDir & "calendar.gif"" WIDTH=16 HEIGHT=12 BORDER=0 ALT="" " & strCalendario & " " & intThisYear & " Powered by Livio.net "" align=absmiddle>&nbsp;"
				W intThisYear &  " - " & yEvents & " " & strEvents & " - "
				If CountCategory() > 0 Then W strCategoria & ":&nbsp;&nbsp;" End if 
				W "</td><td align=left VALIGN=MIDDLE CLASS=ACTC background=""" & strImgDir & "nav_scale.gif"" style=""color:#4D6185;"" nowrap>"
					Call SelCategory(True)
				W "</td><td>&nbsp;</td>"

			   '--- Toggle hide Next10
					W "<FORM name=""frmHideNext10"" action=""" & sFileName & "?" & RQString & """ method=POST>"
					W "<td valign=top><input type=""checkbox"" style=""cursor:hand;width=17px;"" name=""hidenext10"" value=""Enable"" onClick=""this.form.submit();"""
					If Session("bUpcomingEvents") Then W " checked title="" " & Replace(strHideUp, "%1", intUpcomingEvents) & " "">" Else W " title="" " & Replace(strShowUp, "%1", intUpcomingEvents) & " "">" End if
					W "</td><input type=""hidden"" name=""hnext"" value=""ok"">"
					W "</form>"
					If Session("bLoginSuccessful") Then
						If bProtect Then
							If Session("bLoginSuccessful") Then
								'--- Event manager
								W "<FORM name=""frmAllEvents"" action=""" & sFileName & "?" & RQString & """ method=POST><td valign=bottom>"
								W "<input type=""image"" src=""" & strImgDir & "setup.gif"" HEIGHT=14 width=16 border=0 align=absmiddle hspace=2 style=""cursor:hand;"" name=""eventmgr"" onClick=""this.form.frmAllEvents.submit();"" alt="" " & strEventManager & " "">"
								W "<input type=""hidden"" name=""emgr"" value=""ok"">"
								W "</td></form>"
								'--- Configuration manager
								If bEventsPopUp Then
									W "<td><A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=CONFIG&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strCalConf & " '>"
									W "<IMG SRC=""" & strImgDir & "opties.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCalConf & " "" align=absmiddle></A></td>"
									W "<td><A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strCatConf & " '>"
									W "<IMG SRC=""" & strImgDir & "categories.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCatConf & " "" align=absmiddle></A></td>"
								Else
									W "<td><A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=CONFIG&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title='  " & strCalConf & " '>"
									W "<IMG SRC=""" & strImgDir & "opties.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCalConf & " "" align=absmiddle></A></td>"
									W "<td><A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title='  " & strCatConf & " '>"
									W "<IMG SRC=""" & strImgDir & "categories.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCatConf & " "" align=absmiddle></A></td>"
								End if
								'--- Add event
								If bEventsPopUp Then
									W "<td style=""font-size:13px;"" nowrap>&nbsp;[<A HREF=""#"" Title="" " & strAddEventi & " "" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=ADD','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
								Else
									W "<td style=""font-size:13px;"" nowrap>&nbsp;[<A HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=ADD&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ Title="" " & strAddEventi & " ""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
								End if
							End if
						Else
							'--- Event manager
							W "<FORM name=""frmAllEvents"" action=""" & sFileName & "?" & RQString & """ method=POST><td valign=bottom>"
								W "<input type=""image"" src=""" & strImgDir & "setup.gif"" HEIGHT=14 width=16 border=0 align=absmiddle hspace=2 style=""cursor:hand;"" name=""eventmgr"" onClick=""this.form.frmAllEvents.submit();"" alt="" " & strEventManager & " "">"
							W "<input type=""hidden"" name=""emgr"" value=""ok"">"
							W "</td></form>"
							'--- Configuration manager
							If bEventsPopUp Then
								W "<td><A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=CONFIG&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strCalConf & " '>"
								W "<IMG SRC=""" & strImgDir & "opties.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCalConf & " "" align=absmiddle></A></td>"
								W "<td><A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & strCatConf & " '>"
								W "<IMG SRC=""" & strImgDir & "categories.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCatConf & " "" align=absmiddle></A></td>"
							Else
								W "<td><A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=CONFIG&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title='  " & strCalConf & "  '>"
								W "<IMG SRC=""" & strImgDir & "opties.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCalConf & " "" align=absmiddle></A></td>"
								W "<td><A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=CATEGORY&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title='  " & strCatConf & "  '>"
								W "<IMG SRC=""" & strImgDir & "categories.gif"" WIDTH=16 HEIGHT=14 BORDER=0 ALT="" " & strCatConf & " "" align=absmiddle></A>&nbsp;</td>"
							End if
							'--- Add event
							If bEventsPopUp Then
								W "<td style=""font-size:13px;"" nowrap>&nbsp;[<A HREF=""#"" Title="" " & strAddEventi & " "" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=ADD','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
							Else
								W "<td style=""font-size:13px;"" nowrap>&nbsp;[<A HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=ADD&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ Title="" " & strAddEventi & " ""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
							End if
						End if
					Else
						If bGuest = True Then
							'--- Add event
							If bEventsPopUp Then
								W "<td style=""font-size:13px;"" nowrap>[<A HREF=""#"" Title="" " & strAddEventi & " "" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalendarMode=ADD','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
							Else
								W "<td style=""font-size:13px;"" nowrap>[<A HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalendarMode=ADD&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ Title="" " & strAddEventi & " ""><IMG SRC=""" & strImgDir & "add.gif"" BORDER=0 HEIGHT=11 WIDTH=16 ALT="" " & strAddEventi & " ""></A>]</td>"
							End if
						End if
					End If
					W "<td valign=center><a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""cursor:hand;""><img src=""" & strImgDir & "h.gif"" width=16 height=14 alt="" Help "" align=absmiddle hspace=2 border=0></a></td>"
					If bProtect Then
						If Session("bLoginSuccessful") Then
							'--- Logout
							W "<td nowrap><a href=""" & sFileName & "?" & RQString & "&CalLogoff=True""><img src=""" & strImgDir & "keyoff.gif"" width=18 height=14 alt="" Logout "" align=absmiddle hspace=2 border=0></a></td>"
						Else
							'--- Login
							W "<td nowrap><a href=""" & sFileName & "?" & RQString & "&CalLogin=True&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "&CalDate=" & Request.QueryString("CalDate") & """>"
							W "<img src=""" & strImgDir & "key.gif"" width=18 height=14 alt="" Login "" align=absmiddle hspace=2 border=0></a></td>"
						End if
					End if
					'--- WARNING: REMOVING CREDITS AND LINKS TO LIVIO.NET WILL VIOLATE THE LICENSE AGREEMENT
					W "<td nowrap style=""font-family:Tahoma;font-size:10px;color:#666666;"" align=right>&nbsp;"
					W "<a href=""http://www.livio.net/"" target=_blank style=""font-family:Tahoma;font-size:10px;color:#666666;text-decoration:none;font-weight:bold;"" title="" Livio.net Open Source ASP Scripts "" >Livio.net</a>&nbsp;</td>"

		W "</td></tr></table></td>"

			if dNextRCA > 0 Then
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=lightgreen width=16>"
				W "<A href=""" & sFileName & "?" & RQString & "&CalMonth=" & IntNextMonth & "&amp;CalYear=" & IntNextYear & """" & _
					" title="" " & strMeseNex & "." & vbcrlf & " " & Replace(strEventi2, "%1", dNextRCA) & " """ & _
					" onMouseOver=""document.strimgNextEv.src='" & strimgNextMonEv & "'""" & _
					" onMouseOut=""document.strimgNextEv.src='" & strimgNextMoffEv & "'"">" & strNextpEv & "</A>"
			Else
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=15>"
				W "<A href=""" & sFileName & "?"&RQString&"&CalMonth="&IntNextMonth&"&amp;CalYear="&IntNextYear&"""" & _
					" title="" " & strMeseNex & ". " & strNoEventi & " """ & _
					" onMouseOver=""document.strimgNext.src='" & strimgNextMon & "'""" & _
					" onMouseOut=""document.strimgNext.src='" & strimgNextMoff & "'"">" & strNextp & "</A>"
			End if
				W "<td ALIGN=CENTER VALIGN=MIDDLE BGCOLOR=Silver width=15>"
				W "<A href=""" & sFileName & "?"&RQString&"&CalMonth="&IntThisMonth&"&amp;CalYear="&IntThisYear+1&"""" & _
					" title="" " & strAnnoNex & " """ & _
					" onMouseOver=""document.strimgLast.src='" & strimgLastMon & "'""" & _
					" onMouseOut=""document.strimgLast.src='" & strimgLastMoff & "'"">" & strLastp & "</A>"
			W "</tr></table>"
		W "</td></tr><tr><td colspan=5>"

			If bBorderDays Then
				W "<table BORDER=0 CELLPADDING=1 CELLSPACING=1 ALIGN=center BGCOLOR=#FFFFFF>" '--- Week Day Name and Days Table
			Else
				W "<table BORDER=0 CELLPADDING=0 CELLSPACING=1 ALIGN=center BGCOLOR=#FFFFFF>" '--- Week Day Name and Days Table
			End if
		W "<tr>"
				W "<td ALIGN=CENTER CLASS=ACTD VALIGN=MIDDLE Style=""background-color: #F0F0F0;padding-left:1px;"" TITLE="" " & intThisYear & " "">"
					W "<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"
					W "<IMG SRC=""" & strImgDir & "drop2.gif"" WIDTH=12 HEIGHT=10 BORDER=0 ALT="" " & intThisYear & " "" align=absmiddle></a></td>"

		For intLoopDay = 1 to 5
			If nFirstWeekDay = 7 Then
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(2, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(2, sLanguage), 2)&"</a></td>"
			Else
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore style=""background-color:#D0D0D0;"" TITLE="" "&SpecialWeekDayName(1, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;color:navy;"">"&Left(SpecialWeekDayName(1, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(2, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(2, sLanguage), 2)&"</a></td>"
			End if
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(3, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(3, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(4, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(4, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(5, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(5, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(6, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(6, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore style=""background-color:#D0D0D0;"" TITLE="" "&SpecialWeekDayName(7, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(7, sLanguage), 2)&"</a></td>"
			If nFirstWeekDay = 7 Then
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore style=""background-color:#D0D0D0;"" TITLE="" "&SpecialWeekDayName(1, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(1, sLanguage), 2)&"</a></td>"
			End if
		Next
			If nFirstWeekDay = 7 Then
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(2, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(2, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(3, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(3, sLanguage), 2)&"</a></td>"
			Else
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore style=""background-color:#D0D0D0;"" TITLE="" "&SpecialWeekDayName(1, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;color:navy;"">"&Left(SpecialWeekDayName(1, sLanguage), 2)&"</a></td>"
				W "<td ALIGN=CENTER CLASS=ACTB WIDTH=12 HEIGHT=14 VALIGN=MIDDLE id=ignore TITLE="" "&SpecialWeekDayName(2, sLanguage)&" "">&nbsp;<a Onclick=""window.open('"&sScriptDir&"help.asp','','width=450,height=495')"" style=""Text-decoration:none;"">"&Left(SpecialWeekDayName(2, sLanguage), 2)&"</a></td>"
			End if
			W "</tr>"

		ActualDate = Date()
		dFirstDayOfYear = DateSerial(intThisYear, 1, 1)
		dLastDayOfYear =  DateSerial(intThisYear, 12, 31)
		If instr(dFirstDayOfYear, ".") > 0 then
			dFirstDayOfYear = replace(dFirstDayOfYear, ".", "/")
			dLastDayOfYear = replace(dLastDayOfYear, ".", "/")
		end if

		If Session("Event_Category") <> "" Then
			If LCase(dbType) = "access" Then
				sSQL = 	"SELECT DISTINCT Start_Date, End_Date, Event_Repeat, Event_Active FROM tblEvents WHERE " & _
							"((End_Date >= #" & dFirstDayOfYear & "# AND Start_Date <= #" & dLastDayOfYear & "#)" & _
							" OR " & _
							"(Event_Repeat = True))" & _
							" AND " & _
							"(Event_Active = True)" & _
							" AND " & _
							"(Event_Category LIKE ('" & Session("Event_Category") & "'))" & _
							" ORDER BY Start_Date ASC"
			Elseif LCase(dbType) = "mssql" Then
				sSQL = 	"SELECT DISTINCT Start_Date, End_Date, Event_Repeat, Event_Active FROM tblEvents WHERE " & _
							"((End_Date >= '" & dFirstDayOfYear & "' AND Start_Date <= '" & dLastDayOfYear & "')" & _
							" OR " & _
							"(Event_Repeat = 'True'))" & _
							" AND " & _
							"(Event_Active = 'True')" & _
							" AND " & _
							"(Event_Category LIKE ('" & Session("Event_Category") & "'))" & _
							" ORDER BY Start_Date ASC"
			End if
		Else
			If LCase(dbType) = "access" Then
				sSQL = 	"SELECT DISTINCT Start_Date, End_Date, Event_Repeat, Event_Active FROM tblEvents WHERE " & _
							"((End_Date >= #" & dFirstDayOfYear & "# AND Start_Date <= #" & dLastDayOfYear & "#)" & _
							" OR " & _
							"(Event_Repeat = True))" & _
							" AND " & _
							"(Event_Active = True)" & _
							" ORDER BY Start_Date ASC"
			Elseif LCase(dbType) = "mssql" Then
				sSQL = 	"SELECT Start_Date, End_Date, Event_Repeat, Event_Active FROM tblEvents WHERE " & _
							"((End_Date >= '" & dFirstDayOfYear & "' AND Start_Date <= '" & dLastDayOfYear & "')" & _
							" OR " & _
							"(Event_Repeat = 'True'))" & _
							" AND " & _
							"(Event_Active = 'True')" & _
							" ORDER BY Start_Date ASC"
			End if
		End if
		Set Rs = Server.CreateObject("ADODB.RecordSet")
		Rs.Open sSQL, sCalendarDSN, adOpenStatic, adLockReadOnly, adCmdText
		EndRows = False

	For intThisMonth = 1 to 12

		datFirstDay = DateSerial(intThisYear, intThisMonth, 1)
		intFirstWeekDay = WeekDay(datFirstDay, vbUseSystem)
		intLastDay = GetLastDay(intThisMonth, intThisYear)
		intPrevMonth = intThisMonth - 1
		If intPrevMonth = 0 Then
			intPrevMonth = 12
			intPrevYear = intThisYear - 1
		Else
			intPrevYear = intThisYear	
		End If
		intNextMonth = intThisMonth + 1
		If intNextMonth > 12 Then
			intNextMonth = 1
			intNextYear = intThisYear + 1
		Else
			intNextYear = intThisYear
		End If
		sMonthName = SpecialMonthName(intThisMonth, sLanguage)

		LastMonthDate = GetLastDay(intPrevMonth, intThisYear) - intFirstWeekDay + 2

		NextMonthDate = 1
		intPrintDay = 1

		TempWeekDay= DateSerial(datepart("yyyy", date), datepart("m", date), 0)
		WD = WeekDay(TempWeekDay)
		nFirstWeekDay = TempWeekDay - (WD+6) mod 7
		nFirstWeekDay = WeekDay(nFirstWeekDay, vbUseSystem) 
	 
		dFirstDay = DateValue(LDate("1", intThisMonth, intThisYear, binternational))
		dLastDay = DateValue(LDate(intLastDay, intThisMonth, intThisYear, binternational))

		If intThisMonth = 12 Then
			dintNextMonth = 1
			dintNextYear = intThisYear + 1
		Else
			dintNextMonth = intThisMonth + 1
			dintNextYear = intThisYear
		End if
		dintLastDay = GetLastDay(dintNextMonth, dintNextYear)
		dFirstNext = DateValue(LDate("1", dintNextMonth, dintNextYear, binternational))
		dLastNext = DateValue(LDate(dintLastDay, dintNextMonth, dintNextYear, binternational))

			W "<TR>"
				If mevent(intThisMonth) = True Then
					W "<td ALIGN=CENTER CLASS=ACTD HEIGHT=14 width= 32 VALIGN=MIDDLE Style=""background-color:#DCEEDC;"""
					If intThisMonth = CInt(Request.Querystring("CalMonth")) OR intThisMonth = intMonthTemp Then W " Style=""border-right:1px #F00000 solid;border-top:1px #F00000 solid;border-bottom:1px #F00000 solid;border-left:4px #F00000 solid;""" End if
					W ">"
						If bEventsPopUp Then
							W "<A target=_self HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & SpecialMonthName(intThisMonth, sLanguage) & " " & intThisYear & ", " & Replace(strEventi2, "%1", "") & " ' class=LINKSTYLE>"
							W left(SpecialMonthName(intThisMonth, sLanguage), 3) & "</a>"
'									W SpecialMonthName(intThisMonth, sLanguage) & "</a>&nbsp;"
						Else
							W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title=' " & SpecialMonthName(intThisMonth, sLanguage) & " " & intThisYear & ", " & Replace(strEventi2, "%1", "") & " ' class=LINKSTYLE>"
							W left(SpecialMonthName(intThisMonth, sLanguage), 3) & "</a>"
'									W SpecialMonthName(intThisMonth, sLanguage) & "</a>&nbsp;"
						End if
					w "</td>"
				Else
					W "<td ALIGN=CENTER CLASS=ACTD HEIGHT=14 width= 32 VALIGN=MIDDLE"
					If intThisMonth = CInt(Request.Querystring("CalMonth")) OR intThisMonth = intMonthTemp Then W " Style=""border:1px #F00000 solid;""" End if
					W ">"
						If bEventsPopUp Then
							W "<A target=_self HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" title=' " & SpecialMonthName(intThisMonth, sLanguage) & " " & intThisYear & ", " & strNoEventi & " ' class=LINKSTYLE>"
							W left(SpecialMonthName(intThisMonth, sLanguage), 3) & "</a>"
'									W SpecialMonthName(intThisMonth, sLanguage) & "</a>&nbsp;"
						Else
							W "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ title=' " & SpecialMonthName(intThisMonth, sLanguage) & " " & intThisYear & ", " & strNoEventi & " ' class=LINKSTYLE>"
							W left(SpecialMonthName(intThisMonth, sLanguage), 3) & "</a>"
'									W SpecialMonthName(intThisMonth, sLanguage) & "</a>&nbsp;"
						End if
					w "</td>"
				End if

			For intLoopDay = 1 to 37
				If intFirstWeekDay > 1 Then
					strLastMonthDate = "&nbsp;" & LastMonthDate & "&nbsp;"
					If ((intLoopDay = 1 OR intLoopDay = 7) AND NOT bInternational) OR ((intLoopDay = 6 OR intLoopDay = 7) AND bInternational) Then
						Write_TD strLastMonthDate, "NONH"
					Else
						Write_TD strLastMonthDate, "NON"
					End if
					LastMonthDate = LastMonthDate + 1
					intFirstWeekDay = intFirstWeekDay - 1
				Else
					if NextMonthDate < 10 Then strNextMonthDate =  "&nbsp;0" & NextMonthDate & "&nbsp;" Else strNextMonthDate = "&nbsp;" & NextMonthDate & "&nbsp;" End if
					If intPrintDay > intLastDay Then
						If ((intLoopDay = 1 OR intLoopDay = 7) AND NOT bInternational) OR ((intLoopDay = 6 OR intLoopDay = 7) AND bInternational) Then
							Write_TD strNextMonthDate, "NONH"
						Else
							Write_TD strNextMonthDate, "NON"
						End if
						NextMonthDate = NextMonthDate + 1
					Else
						sToday = LDate(intPrintDay, intThisMonth, intThisYear, binternational)  
						dToday = DateValue(sToday)  
						tToday = SpecialWeekDayName(WeekDay(DateValue(sToday)), sLanguage) & ", " & intPrintDay & " " & sMonthName & ", " & intThisYear
						if intPrintDay < 10 Then strPrintDay =  "&nbsp;0" & intPrintDay & "&nbsp;" Else strPrintDay = "&nbsp;" & intPrintDay & "&nbsp;" End if
						bEvents = False
						If NOT Rs.EOF Then
							Do While NOT Rs.EOF AND bEvents = False

								if (Rs("Start_Date") <= dToday AND Rs("End_Date") >= dToday) _
								OR ((DatePart("d", Rs("Start_Date")) <= DatePart("d", dToday) AND DatePart("m", Rs("Start_Date")) <= DatePart("m", dToday) AND DatePart("d", Rs("End_Date")) >= DatePart("d", dToday) AND DatePart("m", Rs("End_Date")) >= DatePart("m", dToday)) AND Rs("Event_Repeat")) _
								OR ((DatePart("d", Rs("Start_Date")) <= DatePart("d", dToday) AND DatePart("m", Rs("Start_Date")) <= DatePart("m", dToday) AND DatePart("d", Rs("Start_Date")) >= DatePart("d", dToday) AND DatePart("m", Rs("Start_Date")) >= DatePart("m", dToday)) AND Rs("Event_Repeat")) _
								OR ((DatePart("d", Rs("End_Date")) <= DatePart("d", dToday) AND DatePart("m", Rs("End_Date")) <= DatePart("m", dToday) AND DatePart("d", Rs("End_Date")) >= DatePart("d", dToday) AND DatePart("m", Rs("End_Date")) >= DatePart("m", dToday)) AND Rs("Event_Repeat")) _
								OR (DatePart("m", Rs("Start_Date")) < DatePart("m", dToday) AND DatePart("d", Rs("End_Date")) >= DatePart("d", dToday) AND DatePart("m", Rs("End_Date")) >= DatePart("m", dToday) AND Rs("Event_Repeat")) _
								OR (DatePart("m", Rs("End_Date")) > DatePart("m", dToday) AND DatePart("d", Rs("Start_Date")) <= DatePart("d", dToday) AND DatePart("m", Rs("Start_Date")) <= DatePart("m", dToday) AND Rs("Event_Repeat")) _
								Then

										If dToday = ActualDate Then
											tToday = strOggi & ": " & tToday
											If bEventsPopUp Then
												Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='EVENTTODAY' title=' " & tToday & " " + vbCrLf + " " & strEventi & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "H"
											Else
												Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='EVENTTODAY' title=' " & tToday & " " + vbCrLf + " " & strEventi & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
											End if
										ElseIf dToday < ActualDate Then
											If bEventsPopUp Then
												Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='PASSEDEVENT' title=' " & tToday & " " + vbCrLf + " " & strEventiPassati & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
											Else
												Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='PASSEDEVENT' title=' " & tToday & " " + vbCrLf + " " & strEventiPassati & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
											End if
										Else
											If Rs("Event_Repeat") Then
												If bEventsPopUp Then
													Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='RECURSIVEEVENT' title=' " & tToday & " " + vbCrLf + " " &  Replace(strEventi2, "%1", "")  & " " + vbCrLf + " (" & strEventRepeat & ") " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
												Else
													Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='RECURSIVEEVENT' title=' " & tToday & " " + vbCrLf + " " &  Replace(strEventi2, "%1", "")  & " " + vbCrLf + " (" & strEventRepeat & ") " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
												End if
											Else
												If bEventsPopUp Then
													Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='EVENT' title=' " & tToday & " " + vbCrLf + " " &  Replace(strEventi2, "%1", "")  & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
												Else
													Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='EVENT' title=' " & tToday & " " + vbCrLf + " " &  Replace(strEventi2, "%1", "")  & " " + vbCrLf + " " & strClicca & " '>" & strPrintDay & "</A>", "HL"
												End if
											End if
										End if
									bEvents = True
								Else	
									Rs.MoveNext
								End If
							Loop
							Rs.MoveFirst
						End If
						If bEvents = False Then
							Dim sCss
							If datepart("w", sToday) = 7 OR datepart("w", sToday) = 1 then sCss = "SD" Else sCss = "ACT" End if
							If dToday = ActualDate Then
								tToday = strOggi & ": " & tToday
								If bEventsPopUp Then
									Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='NOEVENTTODAY' title=' " & tToday & " " + vbCrLf +" " & strNoEventi & " '>" & strPrintDay & "</A>", sCss
								Else
									Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='NOEVENTTODAY' title=' " & tToday & " " + vbCrLf +" " & strNoEventi & " '>" & strPrintDay & "</A>", sCss
								End if
							Else
								If bEventsPopUp Then
									Write_TD "<A HREF=""#"" Onclick=""window.open('" & sScriptDir & "popevents.asp?CalDate=" & Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & "','calendarpop','width=" & intPopUpWidth & ",height=" & intPopUpHeight & ",resizable=yes, scrollbars=yes, toolbar=yes,location=yes,menubar=yes,status=yes,toolbar=yes')"" CLASS='NOEVENT' title=' " & tToday & " " + vbCrLf + " " & strNoEventi & " '>" & strPrintDay & "</A>", sCss
								Else
									Write_TD "<A target=_self HREF=""" & sCalendarEventsPage & "?" & RQString & "&CalDate="& Server.URLEncode(sToday) & "&CalMonth=" & intThisMonth & "&CalYear=" & intThisYear & """ CLASS='NOEVENT' title=' " & tToday & " " + vbCrLf + " " & strNoEventi & " '>" & strPrintDay & "</A>", sCss
								End if
							End if
						End If
					End If 
						intPrintDay = intPrintDay + 1
				End If
			Next
			W "</tr>"
	Next
			W "</TR>"
		Rs.Close
		Set Rs = Nothing
			W "</table>"

			W "</td></tr></table>"
		W "</td></tr></table>" '--- Main table end
		W "<img src=""" & strImgDir & "pixel.gif"" width=10 height=5 alt="""" align=absmiddle border=0><BR>"
	End if '--- Session("bShowCalendar")
End Sub '--- TheYearlyCalendar
%>
