<%
'BindEvents Method @1-AD6FC8E4
Sub BindEvents()
    Set users.CCSEvents("OnValidate") = GetRef("users_OnValidate")
    Set users.CCSEvents("BeforeInsert") = GetRef("users_BeforeInsert")
    Set users.CCSEvents("AfterInsert") = GetRef("users_AfterInsert")
    Set CCSEvents("AfterInitialize") = GetRef("Page_AfterInitialize")
End Sub
'End BindEvents Method

Function users_OnValidate(Sender) 'users_OnValidate @5-C3B7D005

'Custom Code @20-73254650
' -------------------------
	If users.user_password.Value <> CCGetFromPost("ConfirmPassword","") Then
		users.Errors.addError(CCSLocales.GetText("cal_error_difpass",Empty))
	End if

	If Len(users.user_login.Value) > 0 AND Not CCRegExpTest(users.user_login.Value,"^[a-zA-Z0-9_\-]{3,16}$", True, False) Then
		users.Errors.addError(CCSLocales.GetText("cal_error_login",Empty))
	End if
	If Len(users.user_password.Value) > 0 AND Not CCRegExpTest(users.user_password.Value, "^[a-zA-Z0-9]{3,16}$", True, False) Then 
		users.Errors.addError(CCSLocales.GetText("cal_error_pass",Empty))
	End if
' -------------------------
'End Custom Code

End Function 'Close users_OnValidate @5-54C34B28

Function users_BeforeInsert(Sender) 'users_BeforeInsert @5-E273D400

'Custom Code @21-73254650
' -------------------------
	Select Case calendar_config("registration_type")
		Case 1  users.user_is_approved.Value = 1
				users.user_level.Value = 10
		Case 4  Randomize
				users.user_access_code.Value = CStr(Int(8887 * Rnd + 1111)) & CStr(Int(8887 * Rnd + 1111))
				users.user_is_approved.Value = 0
				users.user_level.Value = 1
		Case 8  users.user_is_approved.Value = 0
				users.user_level.Value = 1
	End Select
' -------------------------
'End Custom Code

End Function 'Close users_BeforeInsert @5-54C34B28

Function users_AfterInsert(Sender) 'users_AfterInsert @5-2F9A1802

'Custom Code @22-73254650
' -------------------------
Dim Parameters

	Parameters = Array( _
			Array("{user_name}",  users.user_first_name.Value) ,_
			Array("{user_login}",  users.user_login.Value) ,_
			Array("{user_email}", users.user_email.Value) ,_
			Array("{date_time}",  users.user_date_add.Text)  ,_
			Array("{activate_url}", ServerURL & "confirm.asp?name=" & users.user_login.Value & "&acc=" & users.user_access_code.Value) ,_
			Array("{subject}", "[VCalendar] Confirm your registration."))

	Session("content_param") = Parameters

	Select Case calendar_config("registration_type")
		Case 1  Session("content_type") = "registration_message"
		Case 4  Session("content_type") = "registration_need_confirm"
				Dim Sent : Sent = SendEmailMessage("confirm_registration", users.user_email.Value, Parameters)
				If Len(sent) Then remind.Errors.AddError(sent)
		Case 8  Session("content_type") = "registration_need_approve"
	End Select
' -------------------------
'End Custom Code

End Function 'Close users_AfterInsert @5-54C34B28

Function Page_AfterInitialize(Sender) 'Page_AfterInitialize @1-5C791CCC

'Custom Code @36-73254650
' -------------------------
	If calendar_config("registration_type") = 0 Then
		Response.Redirect("index.asp")
	End If
' -------------------------
'End Custom Code

End Function 'Close Page_AfterInitialize @1-54C34B28


%>
