<%

'---------------------------------------
'Global variable
'---------------------------------------
Dim calendar_config
Dim calendar_permissions

Set calendar_config = CreateObject("Scripting.Dictionary")
Set calendar_permissions = CreateObject("Scripting.Dictionary")


If CalendarIsInstalled = True Then
	getGlobalVariable()
End if
'---------------------------------------
'Read all global variable
'---------------------------------------
Sub getGlobalVariable 
Dim Conn
Dim RecordSet
Dim config_var

	Set Conn = New clsDBcalendar
	Conn.Open

	'Read config for calendar
	Set RecordSet = Conn.Execute("SELECT config_var, config_value FROM config")
	While (NOT RecordSet.EOF)
		config_var = RecordSet("config_var")
		calendar_config(config_var) = RecordSet("config_value")
		RecordSet.MoveNext
	Wend

	'Read permissions for calendar
	Set RecordSet = Conn.Execute("SELECT permission_var, permission_value FROM permissions")
	While (NOT RecordSet.EOF)
		config_var = RecordSet("permission_var")
		calendar_permissions(config_var) = RecordSet("permission_value")
		RecordSet.MoveNext
	Wend

	If calendar_config("registration_type") = "4" Then
		Conn.Execute("DELETE FROM users WHERE user_level=1 AND user_date_add < " & Conn.ToSQL(DateAdd("d", -1 ,Now()), ccsDate))
	End If
	
	CCSLocales.Locale.OverrideDateFormats = True
	If calendar_config("time_format") = "2" Then
		CCSLocales.Locale.ShortTime = Array("HH",":","nn")
	ElseIf calendar_config("time_format") = "3" Then
		CCSLocales.Locale.ShortTime = Array("hh",":","nn"," ","AM/PM")
	End If

	RecordSet.Close
	Set RecordSet = Nothing
	Conn.Close
	Set Conn = Nothing

End Sub


'---------------------------------------
' Generate new password 
' Return the string  
'---------------------------------------
Function generateNewPassword(PassLength) 
Dim i
Dim OneHdigit
Dim Result

	Randomize
	For i = 1 to PassLength
		OneHdigit = CInt(Rnd * 1000) Mod 16
		Result = Result & Hex(OneHdigit)
	Next
	generateNewPassword = Result
End Function

'---------------------------------------
' Add filtering for group of events
' Return condition for WHERE 
'---------------------------------------
Function AddGroupsFilter(Where) 
Dim category
Dim result

	category = Session("category")

	If Len(category) Then
		If Len(Where) > 0 Then
			result = " AND "
		Else
			result = ""
		End If
		AddGroupsFilter = result & "(events.category_id = " & category & ") "
	Else
		AddGroupsFilter = ""
	End If
End Function

'---------------------------------------
'
'---------------------------------------
Function AddReadFilter(Where)
Dim user_level
Dim Result

	If CCGetUserID() > 0 Then
		user_level = CCGetGroupID() '10 for registred and 100 for Admin
	Else
		user_level = 0 'Not logged-in user -- Everyone
	End if

	If user_level < calendar_permissions("private_read") OR (user_level >= calendar_permissions("private_read") AND calendar_permissions("private_read") = 50) Then
		If Len(Where) > 0 Then Result = Result & " AND "
		Result = Result & "(events.event_is_public = 1 "
		If calendar_permissions("private_read") = 50 Then Result = Result & " OR (events.event_is_public=0 AND events.user_id=" & DBCalendar.ToSQL(CCGetUserID(), ccsInteger) & ")"
		Result = Result & ")"
	Else 
		Result = ""
	End if
	AddReadFilter = Result
End Function


'---------------------------------------
'
'---------------------------------------
Function EditAllowed(event_id) 
Dim Conn
Dim SQL
Dim RecordSet
Dim event_is_public
Dim event_owner
Dim user_level
Dim effective_rights
	
	If Len(event_id)>0 Then
		Set Conn = New clsDBcalendar
		Conn.Open
		SQL = "SELECT event_is_public, user_id FROM events WHERE event_id=" & Conn.ToSQL(event_id,ccsInteger)
  		Set RecordSet = Conn.Execute(SQL)

		If NOT RecordSet.EOF Then
			event_is_public = RecordSet("event_is_public")
			event_owner = RecordSet("user_id")
		End if

		Conn.Close
		Set Conn = Nothing

		If event_is_public = "1" Then
			effective_rights = calendar_permissions("public_update")
		Else
			effective_rights = calendar_permissions("private_update")
		End If

		If CCGetUserID() >0 Then
			user_level = CCGetGroupID() ' 10 for registred and 100 for Admin
			If CStr(event_owner) = CStr(CCGetUserID()) AND (user_level < 100 OR effective_rights = 50) Then
				user_level = 50  'if logged_in user and not admin but owner of event
			End If
		Else
			user_level = 0 'Not logged-in user -- Everyone
		End If

		If user_level < effective_rights OR (event_is_public <> "1" AND effective_rights = 50 AND user_level <>50) Then
			EditAllowed = False
		Else
			EditAllowed = True
		End If
	Else
		EditAllowed = False
	End If
End Function


'---------------------------------------
'
'---------------------------------------
Function AddAllowed() 
Dim user_level

	If CCGetUserID() > 0 Then
		user_level = CCGetGroupID() ' 10 for registred and 100 for Admin
	Else
		user_level = 0 'Not logged-in user -- Everyone
	End If

	If user_level < calendar_permissions("new_event") Then
		AddAllowed = False
	Else
		AddAllowed = True
	End If
End Function


'---------------------------------------
'
'---------------------------------------
Function DeleteAllowed(event_id) 
Dim Conn
Dim SQL
Dim RecordSet
Dim event_is_public
Dim event_owner
Dim user_level
Dim effective_rights

	If Len(event_id)>0 Then
		Set Conn = new clsDBcalendar
		Conn.Open

		SQL = "SELECT event_is_public, user_id FROM events WHERE event_id=" & Conn.ToSQL(event_id,ccsInteger)

  		Set RecordSet = Conn.Execute(SQL)
		If NOT RecordSet.EOF Then
			event_is_public = RecordSet("event_is_public")
			event_owner = RecordSet("user_id")
		End if

		Conn.Close
		Set Conn = Nothing

		If event_is_public = "1" Then
			effective_rights = calendar_permissions("public_delete")
		Else
			effective_rights = calendar_permissions("private_delete")
		End If

		If CCGetUserID() > 0 Then
			user_level = CCGetGroupID() ' 10 for registred and 100 for Admin
			If CStr(event_owner) = CStr(CCGetUserID()) And (user_level < 100 OR effective_rights = 50) Then
				user_level = 50  ' if logged_in user and not admin but owner of event
			End If
		Else
			user_level = 0 'Not logged-in user -- Everyone
		End If

		If user_level < effective_rights OR (event_is_public <> "1" AND effective_rights = 50 AND user_level <> 50) Then
			DeleteAllowed = False
		Else
			DeleteAllowed = True
		End If
	Else
		DeleteAllowed = False
	End If

End Function


'---------------------------------------
'
'---------------------------------------
Function ReadAllowed(event_id) 
Dim Conn
Dim SQL
Dim RecordSet
Dim event_is_public
Dim event_owner
Dim user_level

	If Len(event_id)>0 Then
		Set Conn = new clsDBcalendar
		Conn.Open

		SQL = "SELECT event_is_public, user_id FROM events WHERE event_id=" & Conn.ToSQL(event_id,ccsInteger)

		Set RecordSet = Conn.Execute(SQL)
		If NOT RecordSet.EOF Then
			event_is_public = RecordSet("event_is_public")
			event_owner = RecordSet("user_id")
		End if
		Conn.Close
		Set Conn = Nothing

		If event_is_public = "1" Then
			ReadAllowed = True
		Else
			If CCGetUserID() > 0 Then
				user_level = CCGetGroupID()  ' 10 for registred and 100 for Admin
				If CStr(event_owner) = CStr(CCGetUserID()) And (user_level < 100 OR calendar_permissions("private_read") = 50) Then
					user_level = 50  ' if logged_in user and not admin but owner of event
				End If
			Else
				user_level = 0 'Not logged-in user -- Everyone
			End If

			If user_level < calendar_permissions("private_read") OR (calendar_permissions("private_read") = 50 AND user_level <> 50) Then
				ReadAllowed = False
			Else
				ReadAllowed = True
			End If
		End If
	Else
		ReadAllowed = False
	End If

End Function


'---------------------------------------
'
'---------------------------------------
Function processCustomFields(sender) 
Dim Conn
Dim SQL
Dim RecordSet
Dim label_name
Dim flag : flag = True

	Set Conn = New clsDBcalendar
	Conn.Open
	SQL = "SELECT field_name, " &_
				"custom_fields.field_label AS mainLabel, " &_
				"custom_fields_langs.field_label AS localeLabel, " &_
				"field_is_active " &_
		   "FROM custom_fields_langs INNER JOIN custom_fields " &_
		   		"ON custom_fields.field_id = custom_fields_langs.field_id " &_
		   "WHERE language_id = " & Conn.ToSQL(Session("locale"), ccsText)

	Set RecordSet = Conn.Execute(SQL)

	While (NOT RecordSet.EOF)
		If Len(RecordSet("field_is_active")) > 0 AND RecordSet("field_is_active") = 1 Then
			If sender = "eventGrid" Then
				Execute("flag = (Len(" & sender & ".event_" & RecordSet("field_name").Value & ".Value) > 0)")
			End If
			If flag Then
				If Len(RecordSet("localeLabel")) > 0 Then
					label_name = RecordSet("localeLabel")
				Else
					label_name = RecordSet("mainLabel")
				End If
				Execute(sender & ".Label" & RecordSet("field_name").Value & ".Value = label_name")
			Else
				Execute(sender & ".Panel" & RecordSet("field_name").Value & ".Visible = False")
			End If
		Else
			Execute(sender & ".Panel" & RecordSet("field_name").Value & ".Visible = False")
		End If
		RecordSet.MoveNext
	Wend

	RecordSet.Close
	Set RecordSet = Nothing

	Conn.Close
	Set Conn = Nothing

End Function

'---------------------------------------
'
'---------------------------------------
Function SendEmailMessage(variable, email_to, parameters) 
Dim result
Dim Conn
Dim SQL
Dim RecordSet
Dim email_subject
Dim email_body
Dim email_from
Dim elem

	result = ""

	If Len(variable) > 0 Then
		Set Conn = New clsDBcalendar
		Conn.Open
		SQL = "SELECT email_template_from, " &_
					"email_templates.email_template_subject AS mainSubject, " &_
					"email_templates_lang.email_template_subject AS localeSubject, " &_
					"email_templates.email_template_body AS mainBody, " &_
					"email_templates_lang.email_template_body AS localeBody " &_
			   "FROM email_templates LEFT JOIN email_templates_lang " &_
					"ON email_templates.email_template_id = email_templates_lang.email_template_id " &_
			   "WHERE email_template_type = " & Conn.ToSQL(variable, ccsText) &_
			   		" AND language_id = " & Conn.ToSQL(Session("locale"), ccsText)
		Set RecordSet = Conn.Execute(SQL)

		If NOT RecordSet.EOF Then
			If Len(RecordSet("localeSubject")) > 0 Then
				email_subject = RecordSet("localeSubject")
			Else
				email_subject = RecordSet("mainSubject")
			End If

			If Len(RecordSet("localeBody")) > 0 Then
				email_body = RecordSet("localeBody")
			Else
				email_body = RecordSet("mainBody")
			End If

			If Len(RecordSet("email_template_from")) > 0 Then
				email_from = RecordSet("email_template_from")
			Else
				email_from = calendar_config("site_email")
			End If

			if IsNULL(email_body) Then email_body = " "

			For Each elem in parameters
				email_body = Replace(email_body,elem(0),elem(1))
			Next

			email_body = Replace(email_body,"{site_url}",ServerURL)

			If calendar_config("email_setting") = "CDO" Then
				Dim sch, cdoConfig, cdoMessage
				If Len(calendar_config("SMTP")) Then
					sch = "http://schemas.microsoft.com/cdo/configuration/"
					Set cdoConfig = Server.CreateObject("CDO.Configuration")
					With cdoConfig.Fields
						.Item(sch & "sendusing") = 2 'cdoSendUsingPort
						.Item(sch & "smtpserver") = calendar_config("SMTP")
						.Update
					End With
				End If
				Set cdoMessage = Server.CreateObject("CDO.Message")
				On Error Resume Next
				With cdoMessage
					If Len(calendar_config("SMTP")) Then _
						Set .Configuration = cdoConfig
					.From = email_from
					.To = email_to
					.Subject = email_subject
					.TextBody = email_body
					.Send
				End With
				If Err.Number <> 0 Then
					result = "Cann't send email - Error # " & CStr(Err.number) & " - " & Err.Description
				End If
				Set cdoMessage = Nothing
				If Len(calendar_config("SMTP")) Then _
					Set cdoConfig = Nothing
				On Error Resume Next
				If Err.Number <> 0 Then
					result = "Cann't send email - Error # " & CStr(Err.number) & " - " & Err.Description
				End If
			Else
				On Error Resume Next
				With CreateObject("CDONTS.NewMail")
					.From = email_from
					.To = email_to
					.Subject = email_subject
					.Body = email_body
					.BodyFormat = 0
					.MailFormat = 0
					.Send
				End With
				If Err.Number <> 0 Then
					result = "Cann't send email - Error # " & CStr(Err.number) & " - " & Err.Description
				End If
			End If
		End If

		RecordSet.Close
		Set RecordSet = Nothing

		Conn.Close
		Set Conn = Nothing
    End If

    SendEmailMessage = result
End Function


'---------------------------------------
' Read Content
'---------------------------------------
Function GetContent(strkey)
Dim Conn
Dim RecordSet
Dim SQL
Dim Result : Result = ""

	Set Conn = new clsDBcalendar
	Conn.Open
	SQL = "SELECT contents.content_value as mainValue, contents_langs.content_value as localeValue "&_
		  "FROM contents LEFT JOIN contents_langs ON contents.content_id = contents_langs.content_id "&_
		  "WHERE language_id=" & Conn.ToSQL(Session("locale"),ccsText) &_
		  " AND content_type=" & Conn.ToSQL(strkey,ccsText)
	Set RecordSet = Conn.Execute(SQL)
	If NOT RecordSet.EOF Then
		Result = RecordSet("localeValue").Value
		If IsNULL(Result) OR Len(Trim(Result)) = 0 Then
			Result = RecordSet("mainValue").Value
		End if
	End If

	RecordSet.Close
	Set RecordSet = Nothing
	Conn.Close
	Set Conn = Nothing

	GetContent = Result
End Function

%>