﻿namespace AnLogger
{
    using System;
    using System.IO;
    using System.Linq;
    using System.Web;
    using System.Web.UI;

    public class MoreAboutTheError
    {

        private string host;
        private string url;
        private string date;
        private string time;
        private string requestTypes;
        private string totalBytes;
        private string cookies;
        private string browserDetails;
        private string headerDetails;
        private const string LineBreak = "<br/>";

        public MoreAboutTheError(HttpRequest request)
        {
            host = request.Url.Host;
            url = request.Url.AbsoluteUri;
            date = DateTime.Now.Date.ToShortDateString();
            time = DateTime.Now.ToShortTimeString();
            headerDetails = HeaderDetails(request);
            requestTypes = request.RequestType;
            totalBytes = request.TotalBytes.ToString() + "bytes";
            browserDetails = GetBrowserDetails(request);
            cookies = GetCookieDetails(request);
        }
        public string ConstructTheSummary()
        {
            StringWriter stringWriter = new StringWriter();
            HtmlTextWriter writer = new HtmlTextWriter(stringWriter);
            writer.RenderBeginTag(HtmlTextWriterTag.B);
            writer.Write("More about the Error:");
            writer.RenderEndTag();
            writer.RenderBeginTag(HtmlTextWriterTag.Br);
            writer.RenderBeginTag(HtmlTextWriterTag.Br);
            writer.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
            writer.RenderBeginTag(HtmlTextWriterTag.Table);
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Host");
            AddCellContents(writer, host);
            writer.RenderEndTag();

            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "URL");
            AddCellContents(writer, url);
            writer.RenderEndTag();

            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Date");
            AddCellContents(writer, date);
            writer.RenderEndTag();
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Time");
            AddCellContents(writer, time);
            writer.RenderEndTag();
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Request Type");
            AddCellContents(writer, requestTypes);
            writer.RenderEndTag();
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Total Bytes");
            AddCellContents(writer, totalBytes);
            writer.RenderEndTag();
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Browser Details");
            AddCellContents(writer, browserDetails);
            writer.RenderEndTag();
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Cookie Details");
            AddCellContents(writer, cookies);
            writer.RenderEndTag();
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Request Headers");
            AddCellContents(writer, headerDetails);
            writer.RenderEndTag();
            writer.RenderEndTag();
            writer.RenderEndTag();
            writer.RenderEndTag(); //Table 
            return stringWriter.ToString();
        }
        private void AddCellContents(HtmlTextWriter writer, string contents)
        {
            writer.AddStyleAttribute(HtmlTextWriterStyle.FontFamily, "Verdana");
            writer.AddStyleAttribute(HtmlTextWriterStyle.FontWeight, "normal");
            writer.AddStyleAttribute(HtmlTextWriterStyle.FontSize, ".8em");
            writer.AddStyleAttribute(HtmlTextWriterStyle.Color, "black");
            writer.AddStyleAttribute(HtmlTextWriterStyle.MarginTop, "-5px");
            writer.RenderBeginTag(HtmlTextWriterTag.Td);
            writer.Write(contents);
            writer.RenderEndTag();
        }
        private static void AddCellHeader(HtmlTextWriter writer, string dataToWrite, string textAlign = "Right")
        {
            writer.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#ffffcc");
            writer.AddStyleAttribute(HtmlTextWriterStyle.FontFamily, "Verdana");
            writer.AddStyleAttribute(HtmlTextWriterStyle.FontWeight, "bold");
            writer.AddStyleAttribute(HtmlTextWriterStyle.FontSize, ".8em");
            writer.AddStyleAttribute(HtmlTextWriterStyle.Color, "black");
            writer.AddStyleAttribute(HtmlTextWriterStyle.MarginTop, "-5px");
            writer.AddStyleAttribute(HtmlTextWriterStyle.TextAlign, textAlign);
            writer.AddStyleAttribute(HtmlTextWriterStyle.VerticalAlign, "Top");
            writer.RenderBeginTag(HtmlTextWriterTag.Td);
            writer.Write(dataToWrite);
            writer.RenderEndTag();
        }
        private string HeaderDetails(HttpRequest request)
        {
            StringWriter stringWriter = new StringWriter();
            HtmlTextWriter writer = new HtmlTextWriter(stringWriter);
            writer.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
            writer.RenderBeginTag(HtmlTextWriterTag.Table);
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            foreach (string key in request.Headers.Keys)
            {
                AddCellHeader(writer, key, "Left");
            }
            writer.RenderEndTag();
            writer.AddStyleAttribute(HtmlTextWriterStyle.VerticalAlign, "top");
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            foreach (string key in request.Headers.Keys)
            {
                var headerValue = string.Empty;
                request.Headers.GetValues(key).ToList().ForEach(value =>
                {
                    if (value.Contains(","))
                    {
                        value = value.Replace(",", LineBreak);
                    }
                    headerValue = string.Concat(value, LineBreak);
                });
                AddCellContents(writer, headerValue);
            }
            writer.RenderEndTag();//tr 
            writer.RenderEndTag(); //Table 
            return stringWriter.ToString();
        }
        private string GetBrowserDetails(HttpRequest request)
        {
            StringWriter stringWriter = new StringWriter();
            HtmlTextWriter writer = new HtmlTextWriter(stringWriter);
            writer.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
            writer.RenderBeginTag(HtmlTextWriterTag.Table);
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);

            AddCellHeader(writer, "Type", "Left");
            AddCellHeader(writer, "Name", "Left");
            AddCellHeader(writer, "Version", "Left");
            AddCellHeader(writer, "Major Version", "Left");
            AddCellHeader(writer, "Minor Version", "Left");
            AddCellHeader(writer, "Platform", "Left");
            AddCellHeader(writer, "Is Beta", "Left");
            AddCellHeader(writer, "Is Crawler", "Left");
            AddCellHeader(writer, "Is AOL", "Left");
            AddCellHeader(writer, "Is Win16", "Left");
            AddCellHeader(writer, "Is Win32", "Left");
            AddCellHeader(writer, "Supports Frames", "Left");
            AddCellHeader(writer, "Supports Tables", "Left");
            AddCellHeader(writer, "Supports Cookies", "Left");
            AddCellHeader(writer, "EcmaScriptVersion", "Left");
            AddCellHeader(writer, "Supports Java Applets", "Left");
            AddCellHeader(writer, "Supports ActiveX Controls", "Left");
            AddCellHeader(writer, "CDF", "Left");
            writer.RenderEndTag();
            HttpBrowserCapabilities bc = request.Browser;
            // Tr of Contents 
            writer.AddStyleAttribute(HtmlTextWriterStyle.VerticalAlign, "top");
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellContents(writer, bc.Type);
            AddCellContents(writer, bc.Browser);
            AddCellContents(writer, bc.Version);
            AddCellContents(writer, bc.MajorVersion.ToString());
            AddCellContents(writer, bc.MinorVersion.ToString());
            AddCellContents(writer, bc.Platform.ToString());
            AddCellContents(writer, bc.Beta ? "&radic;" : "&times;");
            AddCellContents(writer, bc.Crawler ? "&radic;" : "&times;");
            AddCellContents(writer, bc.AOL ? "&radic;" : "&times;");
            AddCellContents(writer, bc.Win16 ? "&radic;" : "&times;");
            AddCellContents(writer, bc.Win32 ? "&radic;" : "&times;");
            AddCellContents(writer, bc.Frames ? "&radic;" : "&times;");
            AddCellContents(writer, bc.Tables ? "&radic;" : "&times;");
            AddCellContents(writer, bc.Cookies ? "&radic;" : "&times;");
            AddCellContents(writer, bc.EcmaScriptVersion.ToString());
            AddCellContents(writer, bc.JavaApplets ? "&radic;" : "&times;");
            AddCellContents(writer, bc.ActiveXControls ? "&radic;" : "&times;");
            AddCellContents(writer, bc.CDF ? "&radic;" : "&times;");
            writer.RenderEndTag();//tr 
            writer.RenderEndTag(); //Table 
            return stringWriter.ToString();
        }
        private string FormateWithLineBreak(string item1, string item2)
        {
            return string.Format("{0} :&nbsp; {1} {2}", item1, item2, LineBreak);
        }
        private string GetCookieDetails(HttpRequest request)
        {
            StringWriter stringWriter = new StringWriter();
            HtmlTextWriter writer = new HtmlTextWriter(stringWriter);
            writer.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
            writer.RenderBeginTag(HtmlTextWriterTag.Table);
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            AddCellHeader(writer, "Cookies", "Left");
            AddCellHeader(writer, "Expires", "Left");
            AddCellHeader(writer, "Secure", "Left");
            AddCellHeader(writer, "Value", "Left");
            writer.RenderEndTag();
            if (request.Cookies != null)
            {
                HttpCookieCollection cookieCollection = request.Cookies;
                string[] allKeys = cookieCollection.AllKeys;
                foreach (string key in allKeys)
                {
                    HttpCookie currentCookie = cookieCollection[key];
                    writer.AddStyleAttribute(HtmlTextWriterStyle.VerticalAlign, "top");
                    writer.RenderBeginTag(HtmlTextWriterTag.Tr);
                    AddCellContents(writer, currentCookie.Name);
                    AddCellContents(writer, currentCookie.Expires.ToShortDateString());
                    AddCellContents(writer, currentCookie.Secure ? "&radic;" : "&times;");
                    AddCellContents(writer, HttpContext.Current.Server.HtmlEncode(currentCookie.Value));
                    writer.RenderEndTag();//tr 
                }
            }
            writer.RenderEndTag(); //Table 
            return stringWriter.ToString();
        }
    }

}
