﻿namespace AnLogger
{
    using System;
    using System.IO;

    public class FileLogger : ILogger
    {
        // To log exception details from Exception object into file.
        public void Log(Exception exceptionDetails)
        {
            FileWriter.WriteToFile(ExceptionFormatter.GetHtmlFormmatedException(exceptionDetails));
        }

        public void Log(string formattedExceptionDetails)
        {
            FileWriter.WriteToFile(formattedExceptionDetails);
        }

        #region ILogger Members
        public void Log(Exception exceptionDetails, System.Web.HttpRequest httpRequest)
        {
            var formattedExceptionDetails = ExceptionFormatter.GetHtmlFormmatedException(exceptionDetails);
            FileWriter.WriteToFile(formattedExceptionDetails.Replace("</body>", string.Concat(new MoreAboutTheError(httpRequest).ConstructTheSummary(), "</body>")));
        }
        #endregion
    }


    internal static class FileWriter
    {
        internal static void WriteToFile(string dataToWrite)
        {
            string defaultFilePath = ConfigurationReader.ReadValuOf(ConfigurationItems.DefaultFilePath);
            if (Directory.Exists(defaultFilePath))
            {
                var resul = Path.Combine(defaultFilePath, CreateFileName());
                File.WriteAllText(Path.Combine(defaultFilePath, CreateFileName()), dataToWrite);
            }
        }

        private static string CreateFileName()
        {
            return string.Join(Definitions.Separator, GenerateFileFormattedDateTime(), Definitions.FileExtension);
        }

        private static string GenerateFileFormattedDateTime()
        {
            return DateTime.Now.ToString().Replace("/", Definitions.Separator).Replace(":", Definitions.Separator);
        }
    }
}
