﻿namespace AnLogger
{
    using System.Net.Mail;
    using System.Net;

    internal class EmailSender
    {
        private string toAddress;
        private string fromAddress;
        private string smtpServer;

        internal EmailSender()
        {
            toAddress = ConfigurationReader.ReadValuOf(ConfigurationItems.To);
            fromAddress = ConfigurationReader.ReadValuOf(ConfigurationItems.From);
            smtpServer = ConfigurationReader.ReadValuOf(ConfigurationItems.SmtpServer);
        }

        /// <summary>
        /// It will send email with exception details as contents. The email will be sent as Html body.
        /// </summary>
        /// <param name="exceptionDetails"></param>
        /// <param name="submitOfEmail"></param>
        internal static void SendExceptionDetails(string exceptionDetails, string submitOfEmail = "An Exception has been raised.")
        {
            EmailSender emailSender = new EmailSender();
            MailMessage mailMessage = new MailMessage(
                emailSender.fromAddress,
                emailSender.toAddress,
                submitOfEmail,
                exceptionDetails
            );
            mailMessage.IsBodyHtml = true;
            SmtpClient client = new SmtpClient(ConfigurationReader.ReadValuOf(ConfigurationItems.SmtpServer));
            // Please use your own username and Password for the NetworkCredential class.
            //client.Credentials = new NetworkCredential("REPLACE WITH USERNAME", "REPLACE WITH PASSWORD");
            client.Send(mailMessage);
        }
    }
}
