﻿namespace AnLogger
{
    using System;
    using System.IO;
    using System.Web;
    using System.Web.UI;

    public class EmailLogger : ILogger
    {
        // To log exception details from Exception objects via Email.
        public void Log(Exception exceptionDetails)
        {
            EmailSender.SendExceptionDetails(ExceptionFormatter.GetHtmlFormmatedException(exceptionDetails), exceptionDetails.Message);
        }

        public void Log(Exception exceptionDetails, HttpRequest httpRequest)
        {
            var formattedExceptionDetails = ExceptionFormatter.GetHtmlFormmatedException(exceptionDetails);
            formattedExceptionDetails = formattedExceptionDetails.Replace("</body>", string.Concat(new MoreAboutTheError(httpRequest).ConstructTheSummary(), "</body>"));
            EmailSender.SendExceptionDetails(formattedExceptionDetails, exceptionDetails.Message);
        }

        // To log exception details from provided exception details data.
        public void Log(string formattedExceptionDetails)
        {
            EmailSender.SendExceptionDetails(formattedExceptionDetails);
        }

    }
}
