﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Combine And Minify</title>
    <link rel="Stylesheet" type="text/css" href="css/site1.css" />
    <link rel="Stylesheet" type="text/css" href="css/site2.css" />
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <h1>Combine And Minify</h1>

        <p style="border: 1px solid red;">
        Although this site has <em>Combine And Minify</em> fully installed, you still need to make sure that the site runs under IIS instead of Cassini.
        Why this is and how to make this happen is shown 
        <a href="http://www.codeproject.com/KB/aspnet/CombineAndMinify.aspx#installation_vs" target="_blank">here</a>.
        </p>

        <p>
        This site is a version of <em>DemoSite_Gallery</em>.
        It has the 
        <a href="http://www.codeproject.com/KB/aspnet/CombineAndMinify.aspx" target="_blank">Combine And Minify package</a> 
        installed.
        </p>
        <p>
        <em>Combine And Minify</em> has lots of features to further reduce page load times, including automatically combining and minifying
        CSS and JavaScript files, applying far future caching in conjunction with inserting version numbers in images file names for immediate updates, cookieless domains, etc.
        </p>
        <p>
        To demonstrate the ability to combine and minify CSS files, this site has a few extra CSS files in the <em>css</em> directory (<em>site1.css</em> and <em>site2.css</em>).
        It also uses the <em>inlineSpriteStyles</em> property to place all the additional CSS that was generated to support sprites in a separate CSS file, rather than inlining it.
        This saves on page weight.
        If you do a View Source on the page, you'll see that <em>Combine And Minify</em> has combined and minified not only the CSS files in the 
        <em>css</em> directory but also the generated CSS file.
        </p>
        <p>
        <a href="http://www.codeproject.com/KB/aspnet/CombineAndMinify.aspx" target="_blank">Download the <em>Combine And Minify</em> package</a>
        </p>

        <h2>Thumbnails</h2>
        <p>
        Physically resized on the fly using the <em>resizeWidth</em> property.
        This has been coded with ASP.NET HyperLink controls rather than anchor and img tags, to show that
        the package works with HyperLink controls and other ASP.NET controls as well. 
        </p>
        <p>
        <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl="~/Picture1.aspx" ImageUrl="~/largeimages/vanuatu1.JPG">Vanuatu picture 1</asp:HyperLink>
        </p>
        <p>
        <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl="~/Picture2.aspx" ImageUrl="~/largeimages/vanuatu2.JPG">Vanuatu picture 2</asp:HyperLink>
        </p>

        <h2>Small png icons</h2>

        <p><img src="images/contactus.png" /></p>
        <p><img src="images/cart.png" /></p>
        <p><img src="images/print.png" /></p>
    </div>
    </form>
</body>
</html>
