﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Drawing;

namespace CssSpriteGenerator
{
    public abstract class PageBase_ImageReference : IImageReference
    {
        private ImageTag _imageTag = null;
        private Control _control = null;
        private ConfigSection _cs = null;
        private string _originalImageFilePath = null;

        public PageBase_ImageReference(Control control, ImageTag imageTag, ConfigSection cs)
        {
            _control = control;
            _imageTag = imageTag;
            _cs = cs;
            _originalImageFilePath = ImageFilePath(_imageTag, cs);
        }

        public PageBase_ImageReference(Control control, ConfigSection cs)
        {
            _control = control;
            _imageTag = ControlUtils.ImageInControl(control);
            _cs = cs;
            _originalImageFilePath = ImageFilePath(_imageTag, cs);
        }

        private string ImageFilePath(ImageTag imageTag, ConfigSection cs)
        {
            return UrlUtils.MapPath(imageTag.ImgAttributes["src"], ConfigSection.OptionIsActive(cs.ExceptionOnMissingFile));
        }

        #region IImageReference Members

        public string OriginalImageFilePath
        {
            get { return _originalImageFilePath; }
        }

        public Size SizeFromProperties
        { 
            get 
            {
                return new Size(
                    _imageTag.GetImgAttribute("width", -1),
                    _imageTag.GetImgAttribute("height", -1));
            } 
        }

        public void ReplaceWithSprite(
            string spriteUrl, int xOffset, int yOffset, int imageWidth, int imageHeight, bool overrideImgTagDimensionProperies,
            Stylesheet additionalCss, int nbrImagesInSprite)
        {
            // Create the html that will replace the img tag
            string spriteHtml = null;

            if (nbrImagesInSprite == 1)
            {
                // If there is only one image in the sprite, than simply generate an image tag rather than
                // a div with a background image. That way, the image will show up when the page is printed,
                // it is more accessible for vision impaired people, etc.

                spriteHtml = HtmlUtils.ImgHtml(spriteUrl, _imageTag.ImgAttributes, _imageTag.AnchorAttributes, imageWidth, imageHeight, overrideImgTagDimensionProperies);
            }
            else
            {
                spriteHtml = 
                    HtmlUtils.PageSpriteHtml(
                        spriteUrl, xOffset, yOffset, imageWidth, imageHeight, 
                        _imageTag.ImgAttributes, _imageTag.AnchorAttributes,
                        _cs.InlineSpriteStyles, _cs.CopiedImgAttributesRegex,
                        additionalCss);
            }

            // Replace the img tag with the new html
            ControlUtils.ReplaceControlWithSprite(_control, spriteHtml, _imageTag.TagText);
        }

        #endregion
    }
}
