﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;

namespace CssSpriteGenerator
{
    public interface IFileSystem
    {
        /// <summary>
        /// Writes a text file to the generatedFolder folder on the web server
        /// </summary>
        /// <param name="fileName">
        /// Name of the file to be written.
        /// </param>
        /// <param name="fileContents">
        /// Contents of the file.
        /// </param>
        /// <returns>
        /// Url of the new file (which can be used on the web site).
        /// Note: this is not the file system path.
        /// </returns>
        string WriteTextFile(string fileName, string fileContents);

        /// <summary>
        /// Writes an image file to the generatedFolder folder on the web server
        /// </summary>
        /// <param name="fileName">
        /// Name of the file to be written.
        /// </param>
        /// <param name="bitmap">
        /// Contents of the file.
        /// </param>
        /// <param name="imageFormat">
        /// The image format of the sprite, such as Png or Gif.
        /// </param>
        /// <param name="jpegQuality">
        /// This is only relevant if imageFormat is jpg.
        /// 
        /// If this is not 0, than the jpg image's quality will be reduced based on this parameter.
        /// 100 gives you highest quality, 50 gives you 50% quality, etc.
        /// The lower the quality, the fewer bytes the images takes up.
        /// </param>
        /// <returns>
        /// Url of the new file (which can be used on the web site).
        /// Note: this is not the file system path.
        /// </returns>
        string WriteImageFile(string fileName, Bitmap bitmap, ImageFormat imageFormat, int jpegQuality);

        /// <summary>
        /// Version of WriteImageFile that takes an ImageType (an enum defined in this solution),
        /// rather than an ImageFormat (a class defined in .Net).
        /// </summary>
        string WriteImageFile(string fileName, Bitmap bitmap, ImageType imageType, int jpegQuality);
    }
}
