﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;

namespace CssSpriteGenerator
{
    public class ImageTag
    {
        /// <summary>
        /// The attributes of the image, such as src and style.
        /// </summary>
        public ImageAttributeDictionary ImgAttributes { get; set; }

        /// <summary>
        /// If the image sits within an anchor tag, than these are the attributes of the anchor, such as href.
        /// </summary>
        public ImageAttributeDictionary AnchorAttributes { get; set; }

        /// <summary>
        /// Text of the image tag.
        /// </summary>
        public string TagText { get; set; }

        /// <summary>
        /// Returns the value of an image attribute as an integer.
        /// </summary>
        /// <param name="attributeName"></param>
        /// <param name="defaultValue">
        /// If the attribute doesn't exist, or if it's value is not a valid integer,
        /// this default is returned.
        /// </param>
        /// <returns></returns>
        public int GetImgAttribute(string attributeName, int defaultValue)
        {
            if (!ImgAttributes.ContainsKey(attributeName)) { return defaultValue; }

            int attributeValue;
            if (!Int32.TryParse(ImgAttributes[attributeName], out attributeValue)) { return defaultValue; }
	
            return attributeValue;
        }
    }
}
