﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;

namespace CssSpriteGenerator
{
    [ConfigurationCollection(typeof(CssImageConfigurationElement), CollectionType = ConfigurationElementCollectionType.AddRemoveClearMap)]
    public class CssImageConfigurationElementCollection : ConfigurationElementCollection
    {
        private static ConfigurationPropertyCollection _properties;
        protected override ConfigurationPropertyCollection Properties
        {
            get { return _properties; }
        }

        static CssImageConfigurationElementCollection()
        {
            _properties = new ConfigurationPropertyCollection();
        }

        public CssImageConfigurationElementCollection()
        {
        }

        public override ConfigurationElementCollectionType CollectionType
        {
            get { return ConfigurationElementCollectionType.AddRemoveClearMap; }
        }

        public CssImageConfigurationElement this[int index]
        {
            get { return (CssImageConfigurationElement)base.BaseGet(index); }
            set
            {
                if (base.BaseGet(index) != null)
                {
                    base.BaseRemoveAt(index);
                }
                base.BaseAdd(index, value);
            }
        }

        protected override ConfigurationElement CreateNewElement()
        {
            return new CssImageConfigurationElement();
        }

        protected override object GetElementKey(ConfigurationElement element)
        {
            // Create a readable element key, because if there is a duplicate, that key
            // will be shown in an exception.
            CssImageConfigurationElement cce = element as CssImageConfigurationElement;
            return "imageUrl=" + cce.ImageUrl + ", cssSelector=" + cce.CssSelector;
        }
    }
}
