﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;

namespace CssSpriteGenerator
{
    public class CssImageConfigurationElement : ConfigurationElement
    {
        private static ConfigurationProperty _imageUrl;
        private static ConfigurationProperty _cssSelector;
        private static ConfigurationProperty _combineRestriction;
        private static ConfigurationProperty _backgroundAlignment;
        private static ConfigurationPropertyCollection _properties;

        static CssImageConfigurationElement()
        {
            _imageUrl = new ConfigurationProperty(
                "imageUrl",
                typeof(string)
            );

            _cssSelector = new ConfigurationProperty(
                "cssSelector",
                typeof(string)
            );

            _combineRestriction = new ConfigurationProperty(
                "combineRestriction",
                typeof(CombineRestriction)
            );

            _backgroundAlignment = new ConfigurationProperty(
                "backgroundAlignment",
                typeof(Alignment)
            );

            _properties = new ConfigurationPropertyCollection();
            _properties.Add(_imageUrl);
            _properties.Add(_cssSelector);
            _properties.Add(_combineRestriction);
            _properties.Add(_backgroundAlignment);
        }

        [ConfigurationProperty("imageUrl", IsRequired = true)]
        public string ImageUrl
        {
            get { return (string)base[_imageUrl]; }
        }

        [ConfigurationProperty("cssSelector", IsRequired = true)]
        public string CssSelector
        {
            get { return (string)base[_cssSelector]; }
        }

        [ConfigurationProperty("combineRestriction", IsRequired = true)]
        public CombineRestriction CombineRestriction
        {
            get { return (CombineRestriction)base[_combineRestriction]; }
        }

        [ConfigurationProperty("backgroundAlignment", IsRequired = true)]
        public Alignment BackgroundAlignment
        {
            get { return (Alignment)base[_backgroundAlignment]; }
        }

        protected override ConfigurationPropertyCollection Properties
        {
            get { return _properties; }
        }
    }
}
