﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Mobile.FirstWebApplication.Business;
using ListView = Mobile.WebControls.ListView;

namespace Mobile.FirstWebApplication
{
    public partial class UsersList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (HttpContext.Current.Request.QueryString["c"] != null)
            {
                string country = HttpContext.Current.Request.QueryString["c"];
                
                Control control = ControlHelper.GetControlById(mpUsersList, "lv");
                if (control is WebControls.ListView)
                {
                    WebControls.ListView lv = control as ListView;
                    List<User> users = UserManager.GetUsersByCountry(country);
                    var q = from p in users
                            orderby p.Name ascending
                            select p;
                    lv.DataSource = q.ToList();
                    lv.DataBind();
                }
            }
        }
    }
}