﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Mobile.FirstWebApplication.Business;
using ListView = Mobile.WebControls.ListView;

namespace Mobile.FirstWebApplication
{
    public partial class CountryList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Control control = ControlHelper.GetControlById(mbCountryList, "lv");
            if (control is WebControls.ListView)
            {
                WebControls.ListView lv = control as ListView;
                lv.DataSource = CountryManager.GetCountries();
                lv.DataBind();
            }
        }

        protected string GetUrl(string countryName)
        {
            return "UsersList.aspx?c=" + countryName;
        }

        protected string GetImageUrl(string countryName)
        {
            return String.Format("/Images/flag_{0}.png", countryName.ToLower());
        }
    }
}