﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="CountryList.aspx.cs" Inherits="Mobile.FirstWebApplication.CountryList" %>
<%@ Import Namespace="Mobile.FirstWebApplication.Business" %>
<%@ Register TagPrefix="mob" Namespace="Mobile.WebControls" Assembly="AMF" %>
<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="server">
    <mob:MobilePage ID="mbCountryList" HeaderPosition="Fixed" FooterPosition="Fixed" Theme="B" runat="server">
        <Header>
            <mob:IconLinkButton runat="server" ForceToReload="true" Text="Back" Url="Default.aspx" Icon="Back" DataDirection="Reverse" DataTransition="Slide"/>
            <h1>Country</h1>
        </Header>
        <Content>
            <mob:ListView ID="lv" runat="server">
                <ItemTemplate>  
                    <mob:LinkContainer ForceToReload="true" Url="<%# GetUrl(((Country)Container.DataItem).Name) %>" runat="server" DataItem="<%# (Container.DataItem)%>">
                        <Content>
                        <mob:IconListViewItem Source="<%# GetImageUrl(((Country)Container.DataItem).Name) %>" runat="server"/>
                        <%# ((Country)Container.DataItem).Name%>
                        <mob:CountBubbleListViewItem BubbleInfo="<%# ((Country)Container.DataItem).Number %>" runat="server"></mob:CountBubbleListViewItem>
                        </Content>
                    </mob:LinkContainer>
                </ItemTemplate>
            </mob:ListView>
        </Content>
        <Footer>
            <h1>AMF 0.9</h1>
        </Footer>
    </mob:MobilePage>
</asp:Content>
