﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Mobile.FirstWebApplication.Business
{
    public static class UserManager
    {
        public const string UsersSessionKey = "Users";

        public static List<User> GetUsers()
        {
            List<User> users = null;
            if ((HttpContext.Current.Session[UsersSessionKey] != null) && (HttpContext.Current.Session[UsersSessionKey] is List<User>))
            {
                users = HttpContext.Current.Session[UsersSessionKey] as List<User>;
            }
            else
            {
                users = GetMockUserList();
                HttpContext.Current.Session[UsersSessionKey] = users;
            }
            return users;
        }

        private static List<User> GetMockUserList()
        {
            List<User> users = new List<User>();
            User userFr1 = new User("Yohann",true,"France",28);
            User userFr2 = new User("Francis", false, "France",32);
            User userFr3 = new User("Jean", true, "France",16);
            User userFr4 = new User("Yann", true, "France",5);

            User userG1 = new User("Markus", true, "Germany",39);
            User userG2 = new User("Raimund", true, "Germany",20);
            User userG3 = new User("Tankred", false, "Germany",16);
            User userG4 = new User("Vinzens", true, "Germany",7);

            User userUsa1 = new User("Mike", true, "USA",39);
            User userUsa2 = new User("Joe", false, "USA",12);
            User userUsa3 = new User("John", true, "USA",10);
            User userUsa4 = new User("Billy", true, "USA",79);
            User userUsa5 = new User("Bob", true, "USA",48);

            users.Add(userFr1);
            users.Add(userFr2);
            users.Add(userFr3);
            users.Add(userFr4);

            users.Add(userG1);
            users.Add(userG2);
            users.Add(userG3);
            users.Add(userG4);

            users.Add(userUsa1);
            users.Add(userUsa2);
            users.Add(userUsa3);
            users.Add(userUsa4);
            users.Add(userUsa5);
            return users;
        }

        public static void AddUser(string name, bool isActive, string country, int age)
        {
            if ((HttpContext.Current.Session[UsersSessionKey] != null) && (HttpContext.Current.Session[UsersSessionKey] is List<User>))
            {
                List<User> users = HttpContext.Current.Session[UsersSessionKey] as List<User>;
                if (users != null)
                {
                    if (!String.IsNullOrEmpty(name))
                    {
                        User user = new User(name, isActive, country, age);
                        users.Add(user);
                        HttpContext.Current.Session[UsersSessionKey] = users;
                    }

                }

            } 
        }

        public static List<User> GetUsersByCountry(string country)
        {
            List<User> users = null;
            List<User> sessionUsers = GetUsers();
            if (sessionUsers != null)
            {
                var q = from p in sessionUsers
                        where p.Country == country
                        select p;
                users = q.ToList();
            }
            return users;
        }
    }
}