﻿using System;
using System.Globalization;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Drawing.Design;
using System.ComponentModel.Design;
using System.Runtime;
using System.Reflection;

namespace YuiExtAspNetCalendar
{
    /// <summary>
    /// This the calendar mode
    /// </summary>
    public enum CalendarDisplayMode
    {
        Flat,
        CollapsibleCalendarWithNoDateSummury,
        CollapsibleCalendarWithDateSummury
       
    }

    public class YuiExtCalendar : CompositeControl
    {

        /// <summary>
        /// This is the calendar mode :
        /// - Mode Flat : the calendar is displayed classically on the page like any web widget
        /// - Mode CollapsibleCalendarWithNoDateSummury : An image is displayed , when you clicked it, the calendar opens , and you can do your selection
        /// - Mode CollapsibleCalendarWithDateSummury : it's the like CollapsibleCalendarWithNoDateSummury , but you have on thing more : a summury of your selected dates
        /// </summary>
        [Description("Calendar display mode")]
        public virtual CalendarDisplayMode Mode
        {
            get
            {
                object obj2 = this.ViewState["CalendarDisplayMode"];
                if (obj2 != null)
                {
                    return (CalendarDisplayMode)obj2;
                }
                return CalendarDisplayMode.Flat;
            }
            set
            {
                this.ViewState["CalendarDisplayMode"] = value;
            }
        }

        /// <summary>
        /// MinDateSelectable and MaxDateSelectable must be set together.
        /// It Allows you to restric your date selection interval on the calendar.
        /// For example , if you wish that your calendar allows to select dates between 19/09/2012 and  09/12/2012.
        /// (You ll must set MinDateSelectable = 19/09/2012 and MaxDateSelectable = 09/12/2012.)
        /// Set this variable server side
        /// </summary>
        [Browsable(false)]
        public DateTime MinDateSelectable
        {
            get
            {
                return (ViewState["MinDateSelectable"] == null) ? DateTime.MinValue : DateTime.Parse(
              ViewState["MinDateSelectable"].ToString());
            }
            set { ViewState["MinDateSelectable"] = value; }
        }

        /// <summary>
        /// MinDateSelectable and MaxDateSelectable must be set together.
        /// It Allows you to restric your date selection interval on the calendar.
        /// For example , if you wish that your calendar allows to select dates between 19/09/2012 and  09/12/2012.
        /// (You ll must set MinDateSelectable = 19/09/2012 and MaxDateSelectable = 09/12/2012.)
        /// Set this variable server side
        /// </summary>
        [Browsable(false)]
        public DateTime MaxDateSelectable
        {
            get
            {
                return (ViewState["MaxDateSelectable"] == null) ? DateTime.MaxValue : DateTime.Parse(
              ViewState["MaxDateSelectable"].ToString());
            }
            set { ViewState["MaxDateSelectable"] = value; }
        }

        /// <summary>
        /// You must set this list server side to select some datetimes at the load of the page
        /// </summary>
        [Browsable(false)]
        public List<DateTime> InitialSelectedDates
        {
            get
            {
                return (ViewState["InitialSelectedDates"] == null) ? new List<DateTime>() : (List<DateTime>)ViewState["InitialSelectedDates"];
            }
            set { ViewState["InitialSelectedDates"] = value; }
        }

        /// <summary>
        /// You must set this list server side to set a list of forbidden date : these dates won't be selectable . 
        /// You can customize the UI style of these forbidden date in calendar.css
        /// /*Forbidden Style*/
        /// .yui-skin-sam .yui-calendar td.calcell.forbidden{ ##customize_here## }
        ///  Set this variable server side
        /// </summary>
        [Browsable(false)]
        public List<DateTime> ForbiddenDates
        {
            get
            {
                return (ViewState["ForbiddenDates"] == null) ? new List<DateTime>() : (List<DateTime>)ViewState["ForbiddenDates"];
            }
            set { ViewState["ForbiddenDates"] = value; }
        }

        /// <summary>
        /// This variable allows you to control the number of selected dates
        /// For example : If you wish to enable one user to select 4 dates in calendar , set this variable to 4.
        /// Set this variable server side or client side
        /// </summary>
        [Browsable(true)]
        public int NumberOfSelectableDates
        {
            get
            {
                return (ViewState["NumberOfSelectableDates"] == null) ? -1 : int.Parse( ViewState["NumberOfSelectableDates"].ToString());
            }
            set { ViewState["NumberOfSelectableDates"] = value; }
        }


        /// <summary>
        /// Set the title of the header of the calendar
        /// Set this variable server side or client side
        /// </summary>
        [Browsable(true)]
        public string HeaderTitle
        {
            get
            {
                return (ViewState["HeaderTitle"] == null) ? "Please make a selection:" : ViewState["HeaderTitle"].ToString();
            }
            set { ViewState["HeaderTitle"] = value; }
        }

        /// <summary>
        /// ImageCalendarUrl must be set if you are in mode CollapsibleCalendarWithNoDateSummury or CollapsibleCalendarWithNoDateSummury , it will be trigger
        /// I advice you to set this variable client side
        /// </summary>
        [Category("Appearance"),
         Editor("System.Web.UI.Design.ImageUrlEditor, System.Design, Version=3.5.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor)), 
         UrlProperty, 
         Description("ImageUrl of the picture who expand the calendar"), 
         Bindable(true), 
         DefaultValue("")]
        public virtual string ImageCalendarUrl
        {
            get
            {
                string str = (string)this.ViewState["ImageUrl"];
                if (str != null)
                {
                    return str;
                }
                return string.Empty;
            }
            set
            {
                this.ViewState["ImageUrl"] = value;
            }
        }

        /// <summary>
        /// Tag of this control generated client side
        /// </summary>
        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Div;
            }
        }

        /// <summary>
        /// You must set this list server side to set a list of pre selected date. 
        /// </summary>
        [Browsable(false)]
        public List<DateTime> SelectedValues
        {
            get
            {
                List<DateTime> l = new List<DateTime>();
                 string HiddenFieldValue = string.Empty;

                foreach (string key in Page.Request.Form.Keys)
                {
                    if (key.Contains(this.ClientID))
                    {
                        if (key.Contains("hSelectedDates"))
                        {
                            HiddenFieldValue = Page.Request.Form[key];
                        }
                    }

                }

                if (!string.IsNullOrEmpty(HiddenFieldValue))
                {
                    if (HiddenFieldValue.Contains(","))
                    {
                        string[] tks = HiddenFieldValue.Split(',');

                        foreach (string date in tks)
                        {
                            string dateTrimed = date.Trim();
                            if (dateTrimed.Length > 0)
                            {
                                string day = dateTrimed.Split('/')[0];
                                string month = dateTrimed.Split('/')[1];
                                string year = dateTrimed.Split('/')[2];
                                
                                l.Add(new DateTime(
                                        Convert.ToInt32(year),
                                        Convert.ToInt32(month),
                                        Convert.ToInt32(day)
                                        ));
                            }
                        }
                    }
                }

                return l;
            }
        }

        /// <summary>
        /// Constructor
        /// </summary>
        public YuiExtCalendar() : base() { }


        protected override void CreateChildControls()
        {
            //set exmaple style
            this.Attributes["style"] = "position:relative;height:250px;";
            this.Attributes["class"] = "yui-skin-sam";

            HtmlGenericControl theCalendar = new HtmlGenericControl("div");
            theCalendar.ID = "cal1Container";

          
            if (    Mode == CalendarDisplayMode.CollapsibleCalendarWithDateSummury 
                ||  Mode == CalendarDisplayMode.CollapsibleCalendarWithNoDateSummury)
            {
                if (string.IsNullOrEmpty(ImageCalendarUrl))
                {
                    throw new Exception("Mode  CollapsibleCalendarWithDateSummury and CollapsibleCalendarWithNoDateSummury require ImageCalendarUrl property (select it with the designer)");
                }
                else
                {
                    Image ImgTrigger = new Image();
                    ImgTrigger.Attributes["align"] = "left";
                    ImgTrigger.ID = "imgTrigger";
                    ImgTrigger.ImageUrl =  ImgTrigger.ResolveUrl(ImageCalendarUrl);
                    Controls.Add(ImgTrigger);
                }

                if (Mode == CalendarDisplayMode.CollapsibleCalendarWithDateSummury)
                {
                    HtmlGenericControl Summury = new HtmlGenericControl("div");
                    Summury.Attributes["class"] = "eventlog";
                    Summury.ID = "caleventlog";

                    HtmlGenericControl SummuryHeader = new HtmlGenericControl("div");
                    SummuryHeader.Attributes["class"] = "hd";
                    SummuryHeader.ID = "sumtitle";

                    HtmlGenericControl SummuryBody = new HtmlGenericControl("div");
                    SummuryBody.Attributes["class"] = "bd";
                    SummuryBody.ID = "sumentries";

                    Summury.Controls.Add(SummuryHeader);
                    Summury.Controls.Add(SummuryBody);
                    Controls.Add(Summury);

                }
            }

            Controls.Add(theCalendar);

            //Hidden Field whose store dates
            HtmlInputHidden hSelectedDates = new HtmlInputHidden();
            hSelectedDates.ID = "hSelectedDates";
            hSelectedDates.Value = this.ClientID;
            Controls.Add(hSelectedDates);


        }

        protected override void OnPreRender(EventArgs e)
        {

            //Statics scripts
            string YahooDomEventScript = Page.ClientScript.GetWebResourceUrl(
               this.GetType(),
               "YuiExtAspNetCalendar.resources.yahoo-dom-event.js"
               );

            string YuiCalendarScript = Page.ClientScript.GetWebResourceUrl(
               this.GetType(),
               "YuiExtAspNetCalendar.resources.calendar.js"
               );

            string YuiCalendarStyle = Page.ClientScript.GetWebResourceUrl(
               this.GetType(),
               "YuiExtAspNetCalendar.resources.calendar.css"
               );

            HtmlGenericControl crtlYahooDomEventScript = new HtmlGenericControl("script");
            crtlYahooDomEventScript.Attributes.Add("language", "JavaScript");
            crtlYahooDomEventScript.Attributes.Add("type", "text/javascript");
            crtlYahooDomEventScript.Attributes.Add("src", YahooDomEventScript);
            crtlYahooDomEventScript.Attributes.Add("alt", "yahoo-dom-event.js");

            HtmlGenericControl crtlYuiCalendarScript = new HtmlGenericControl("script");
            crtlYuiCalendarScript.Attributes.Add("language", "JavaScript");
            crtlYuiCalendarScript.Attributes.Add("type", "text/javascript");
            crtlYuiCalendarScript.Attributes.Add("src", YuiCalendarScript);
            crtlYuiCalendarScript.Attributes.Add("alt", "calendar.js");

            HtmlGenericControl crtlYuiCalendarStyle = new HtmlGenericControl("link");
            crtlYuiCalendarStyle.Attributes.Add("type", "text/css");
            crtlYuiCalendarStyle.Attributes.Add("rel", "stylesheet");
            crtlYuiCalendarStyle.Attributes.Add("href", YuiCalendarStyle);
            crtlYuiCalendarScript.Attributes.Add("alt", "calendar.css");


            if (Page.Items["RESOURCES_FILES_ALREADY_REGISTERED_IN_PAGE"] == null)
            {
                Page.Items["RESOURCES_FILES_ALREADY_REGISTERED_IN_PAGE"] = 1;
                Page.Header.Controls.Add(crtlYahooDomEventScript);
                Page.Header.Controls.Add(crtlYuiCalendarScript);
                Page.Header.Controls.Add(crtlYuiCalendarStyle);
            }
          

            //Dynamics scripts

            //Build CalendarLoader.js Constructor
            System.IO.Stream streamScriptLoader = Assembly.GetExecutingAssembly().GetManifestResourceStream("YuiExtAspNetCalendar.Loading.calendarLoader.js");
            System.IO.StreamReader readerScriptLoader = new System.IO.StreamReader(streamScriptLoader);
            string scriptLoader = readerScriptLoader.ReadToEnd();
            readerScriptLoader.Close();

            StringBuilder CalendarConstructor = new StringBuilder();
            CalendarConstructor.Append("YAHOO._ID_ASPNETwebcontrol.cal1 = new YAHOO.widget.CalendarGroup(" + "\"" + "_ID_cal1Container" + "\"" + ", {")
                               .Append(" navigator: true,")
                               .Append(" title : " + "\"" + HeaderTitle + "\""+",")
                               .Append(" MULTI_SELECT : true" + ",");


            if (MinDateSelectable != DateTime.MinValue)
            {
                CalendarConstructor.Append(" mindate : " + "\"" + MinDateSelectable.Month.ToString() + "/" + MinDateSelectable.Day.ToString() + "/" + MinDateSelectable.Year.ToString() + "\"" +",");
            }
            if (MaxDateSelectable != DateTime.MaxValue)
            {
                CalendarConstructor.Append(" maxdate : " + "\"" + MaxDateSelectable.Month.ToString() + "/" + MaxDateSelectable.Day.ToString() + "/" + MaxDateSelectable.Year.ToString() + "\"" + ",");
            }

            if (InitialSelectedDates.Count > 0)
            {
                string stringConcatSelectedDates = "";
                foreach (DateTime dt in InitialSelectedDates)
                {
                    stringConcatSelectedDates += dt.Month + "/" + dt.Day + "/" + dt.Year + "  ,";
                }

                stringConcatSelectedDates =  stringConcatSelectedDates.Substring(0, stringConcatSelectedDates.Length - 1);

                CalendarConstructor.Append(" selected : " + "\"" + stringConcatSelectedDates + "\""+ ",");
            }

            if (ForbiddenDates.Count > 0)
            {
                string stringConcatForbiddenDates = "";
                foreach (DateTime dt in ForbiddenDates)
                {
                    stringConcatForbiddenDates +=  dt.Month + "/" + dt.Day + "/" + dt.Year + "  ,";
                }

                stringConcatForbiddenDates = stringConcatForbiddenDates.Substring(0, stringConcatForbiddenDates.Length - 1);

                CalendarConstructor.Append(" forbidden : " + "\"" + stringConcatForbiddenDates + "\"" + ",");
            }

            if (NumberOfSelectableDates != -1)
            {
                CalendarConstructor.Append(" NUMBER_OF_DATE_SELECTABLE : " + "\"" + NumberOfSelectableDates + "\"" + ",");
            }

            
            if (Mode == CalendarDisplayMode.Flat)
            {
                CalendarConstructor.Append(" close: false});");
            }
            else
            {
                CalendarConstructor.Append(" close: true});");
                CalendarConstructor.Append(" YAHOO.util.Event.addListener(" + "\"" + "_ID_imgTrigger" + "\"" + ", " + "\"" + "click" + "\"" + ", YAHOO._ID_ASPNETwebcontrol.cal1.show, YAHOO._ID_ASPNETwebcontrol.cal1, true);");
            }

            //insert constructor in the script loader
            scriptLoader = scriptLoader.Replace("[CONSTRUCTOR_TO_GENERATE_FROM_SERVER_SIDE]", CalendarConstructor.ToString());
            //replace Id in the script
            scriptLoader = scriptLoader.Replace("_ID_",this.ClientID+"_");

            //Add the script to the page
            HtmlGenericControl crtlScriptLoader = new HtmlGenericControl("script");
            crtlScriptLoader.Attributes.Add("type", "text/javascript");
            crtlScriptLoader.Controls.Add( new LiteralControl( scriptLoader));
            Page.Header.Controls.Add(crtlScriptLoader);


            //build style
            string styleLoader = string.Empty;

            if (Mode == CalendarDisplayMode.Flat)
            {
                styleLoader += "#_ID_cal1Container {position:absolute; left:5px; top:10px; z-index:2} \r\n";
            }
            else
            {
                styleLoader += "#_ID_cal1Container { display:none; position:absolute; left:5px; top:10px; z-index:2} \r\n";
            }

            styleLoader = styleLoader.Replace("_ID_", this.ClientID + "_");


            //Add style for registering sprite.png
            //We exctract all css lines from calendar.css whose contain url(sprite.png)
            string urlImageSprite = Page.ClientScript.GetWebResourceUrl(this.GetType(), "YuiExtAspNetCalendar.resources.sprite.png");

            StringBuilder stylesExtracted = new StringBuilder();

            stylesExtracted.Append(" \r\n .yui-skin-sam .yui-calcontainer .title{background:url(\"[SPRITE_IMG_URL]\") repeat-x 0 0;border-bottom:1px solid #ccc;font:100% sans-serif;color:#000;font-weight:bold;height:auto;padding:.4em;margin:0 -10px 10px -10px;top:0;left:0;text-align:left;} \r\n")
            .Append(" .yui-skin-sam .yui-calcontainer .calclose{background:url(\"[SPRITE_IMG_URL]\") no-repeat 0 -300px;width:25px;height:15px;top:.4em;right:.4em;cursor:pointer;} \r\n")
            .Append(" .yui-skin-sam .yui-calendar .calnavleft{background:url(\"[SPRITE_IMG_URL]\") no-repeat 0 -450px;width:25px;height:15px;top:0;bottom:0;left:-10px;margin-left:.4em;cursor:pointer;} \r\n")
            .Append(" .yui-skin-sam .yui-calendar .calnavright{background:url(\"[SPRITE_IMG_URL]\") no-repeat 0 -500px;width:25px;height:15px;top:0;bottom:0;right:-10px;margin-right:.4em;cursor:pointer;} \r\n")
            .Append(" .yui-skin-sam .yui-calendar a.calnav:hover{background:url(\"[SPRITE_IMG_URL]\") repeat-x 0 0;border-color:#A0A0A0;cursor:pointer;} \r\n")
            .Append(" .yui-skin-sam .yui-calcontainer .yui-cal-nav .yui-cal-nav-btn{border:1px solid #808080;background:url(\"[SPRITE_IMG_URL]\") repeat-x 0 0;background-color:#ccc;margin:auto .15em;} \r\n")
            .Append(" .yui-skin-sam .yui-calcontainer .yui-cal-nav .yui-cal-nav-btn.yui-default{border:1px solid #304369;background-color:#426fd9;background:url(\"[SPRITE_IMG_URL]\") repeat-x 0 -1400px;} \r\n");

            stylesExtracted = stylesExtracted.Replace("[SPRITE_IMG_URL]", urlImageSprite);

            if (Page.Items["STYLE_ALREADY_REGISTERED_IN_PAGE"] == null)
            {
                Page.Items["STYLE_ALREADY_REGISTERED_IN_PAGE"] = 1;
                styleLoader += stylesExtracted.ToString();
            }

            
            if (Mode == CalendarDisplayMode.CollapsibleCalendarWithDateSummury)
            {
                //add calendarLoader.css
                System.IO.Stream streamStyleSummury = Assembly.GetExecutingAssembly().GetManifestResourceStream("YuiExtAspNetCalendar.Loading.calendarLoader.css");
                System.IO.StreamReader readerStyleSummury = new System.IO.StreamReader(streamStyleSummury);
                string styleSummury = readerStyleSummury.ReadToEnd();
                readerStyleSummury.Close();

                styleSummury = styleSummury.Replace("_ID_", this.ClientID + "_");

                styleLoader += styleSummury;
            }

            //Add the style to the page
            HtmlGenericControl crtlStyleLoader = new HtmlGenericControl("style");
            crtlStyleLoader.Attributes.Add("type", "text/css");
            crtlStyleLoader.Controls.Add(new LiteralControl(styleLoader));
            Page.Header.Controls.Add(crtlStyleLoader);
            
        }


    }
}
