﻿<%@ Page Title="Edit Job" Language="C#" MasterPageFile="~/Site.master" AutoEventWireup="true"
    CodeBehind="EditJob.aspx.cs" Inherits="jobs.EditJob" %>

<%@ Register Assembly="TimePicker" Namespace="MKB.TimePicker" TagPrefix="MKB" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
   <script type="text/javascript" src="Scripts/jobs/jobs.js"></script>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <h2>
        Edit job
    </h2>
    <asp:Table ID="tableJob" runat="server" BorderStyle="Solid" BorderColor="Black" GridLines="Both">
    <asp:TableRow>
    <asp:TableCell>
        <asp:Label runat="server" ID="lblDescription" Text="Description"></asp:Label>
    </asp:TableCell>
    <asp:TableCell>
        <asp:TextBox runat="server" ID="txtDescription" Width="300"></asp:TextBox>
    </asp:TableCell>
    </asp:TableRow>
    <asp:TableRow>
    <asp:TableCell>
        <asp:Label runat="server" ID="lblSheduleType" Text="Schedule type"></asp:Label>
    </asp:TableCell>
    <asp:TableCell>
        <asp:DropDownList runat="server" ID="dropListScheduleTypes" OnInit="dropListScheduleTypes_Init"></asp:DropDownList>
    </asp:TableCell>
    </asp:TableRow>
    <asp:TableRow>
    <asp:TableCell>
    </asp:TableCell>
    <asp:TableCell>
        <asp:Label runat="server" ID="lblOccurs" Text="Occurs every day"></asp:Label>
        <asp:Panel runat="server" ID="panelWeekDays">
          <asp:CheckBoxList runat="server" ID="chkWeekDays">
            <asp:ListItem Text="Monday" Value="1"></asp:ListItem>
            <asp:ListItem Text="Tuesday" Value="2"></asp:ListItem>
            <asp:ListItem Text="Wednesday" Value="3"></asp:ListItem>
            <asp:ListItem Text="Thursday" Value="4"></asp:ListItem>
            <asp:ListItem Text="Friday" Value="5"></asp:ListItem>
            <asp:ListItem Text="Saturday" Value="6"></asp:ListItem>
            <asp:ListItem Text="Sunday" Value="7"></asp:ListItem>
          </asp:CheckBoxList>
        </asp:Panel>
        <br />
        <asp:Label runat="server" ID="lblAt" Text="at"></asp:Label>
        <MKB:TimeSelector ID="timeOccurs" runat="server" SelectedTimeFormat="TwentyFour">
        </MKB:TimeSelector>
    </asp:TableCell>
    </asp:TableRow>
    <asp:TableRow>
    <asp:TableCell BorderColor="White">
    </asp:TableCell>
    <asp:TableCell HorizontalAlign="Right" BorderColor="White">
        <asp:Button ID="btnEdit" runat="server" Text="Save" OnClick="btnEdit_Click" />
        <asp:Button ID="btnCancel" runat="server" Text="Cancel" PostBackUrl="~/Default.aspx" />
    </asp:TableCell>
    </asp:TableRow>
    </asp:Table>

    <h2>
    Steps
    </h2>
    <asp:GridView ID="gridSteps" runat="server" AutoGenerateColumns="False" 
            CellPadding="4" EnableModelValidation="True" ForeColor="#333333" 
            GridLines="None" Width="100%">
        <AlternatingRowStyle BackColor="White" />
        <Columns>
            <asp:BoundField DataField="id" HeaderText="id" />
            <asp:BoundField DataField="description" HeaderText="description" />
            <asp:BoundField DataField="type" HeaderText="type" />
            <asp:BoundField DataField="command" HeaderText="command" />
            <asp:BoundField DataField="exec_order" HeaderText="exec_order" />
            <asp:TemplateField HeaderText="action">
                <ItemTemplate>
                    <asp:Button ID="btnEdit" runat="server" onclick="btnEdit_Click1" Text="edit" />
                    <asp:Button ID="btnRemove" runat="server" onclick="btnRemove_Click" Text="remove" OnClientClick="return confirm('Are you sure you want to remove this step?')" />
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <EditRowStyle BackColor="#2461BF" />
        <FooterStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" />
        <HeaderStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" />
        <PagerStyle BackColor="#2461BF" ForeColor="White" HorizontalAlign="Center" />
        <RowStyle BackColor="#EFF3FB" />
        <SelectedRowStyle BackColor="#D1DDF1" Font-Bold="True" ForeColor="#333333" />
    </asp:GridView>

    <asp:Button runat="server" ID="btnAddStep" Text="Add" OnClick="btnAddStep_Click" />
</asp:Content>
