﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Threading;
using HelperLib;

namespace jobs
{
    public partial class _Default : System.Web.UI.Page
    {
        private string connStringJobs = ConfigurationManager.ConnectionStrings["jobs"].ToString();
        private string connStringJobsAsync = ConfigurationManager.ConnectionStrings["jobsAsync"].ToString();
        private static int job_id = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                BindJobGrid();
            }
        }
        private void BindJobGrid()
        {
            SqlHelper mySqlHelper = new SqlHelper(connStringJobs, CommandType.StoredProcedure, "list_jobs");
            DataSet DS = mySqlHelper.ExecuteDataset();
            mySqlHelper.Close();
            gridJobs.DataSource = DS.Tables[0].DefaultView;
            gridJobs.DataBind();
        }
        protected void btnEdit_Click(object sender, EventArgs e)
        {
            Button edit = sender as Button;
            GridViewRow row = (GridViewRow)edit.NamingContainer;

            Response.Redirect("EditJob.aspx?job_id=" + row.Cells[0].Text);
        }
        protected void btnEnableDisable_Click(object sender, EventArgs e)
        {
            Button edit = sender as Button;
            GridViewRow row = (GridViewRow)edit.NamingContainer;
            job_id = int.Parse(row.Cells[0].Text);

            SqlHelper mySqlHelper = new SqlHelper(connStringJobs, CommandType.StoredProcedure, "get_job_enabled_status",
                                                  new SqlParameter("@job_id", job_id));
            bool enabled = bool.Parse(mySqlHelper.ExecuteScalar().ToString());
            mySqlHelper.Close();

            if (enabled)
            {
                mySqlHelper = new SqlHelper(connStringJobs, CommandType.StoredProcedure, "disable_job",
                                            new SqlParameter("@job_id", job_id));
                mySqlHelper.ExecuteNonQuery();
                mySqlHelper.Close();
            }
            else
            {
                mySqlHelper = new SqlHelper(connStringJobs, CommandType.StoredProcedure, "enable_job",
                                new SqlParameter("@job_id", job_id));
                mySqlHelper.ExecuteNonQuery();
                mySqlHelper.Close();
            }
            BindJobGrid();
        }
        protected void btnDelete_Click(object sender, EventArgs e)
        {
            Button edit = sender as Button;
            GridViewRow row = (GridViewRow)edit.NamingContainer;
            job_id = int.Parse(row.Cells[0].Text);

            SqlHelper mySqlHelper = new SqlHelper(connStringJobs, CommandType.StoredProcedure, "delete_job",
                                                  new SqlParameter("@job_id", job_id));
            mySqlHelper.ExecuteNonQuery();
            mySqlHelper.Close();
            BindJobGrid();
        }
        protected void btnRun_Click(object sender, EventArgs e)
        {
            Button edit = sender as Button;
            GridViewRow row = (GridViewRow)edit.NamingContainer;
            job_id = int.Parse(row.Cells[0].Text);

            SqlHelper mySqlHelper = new SqlHelper(connStringJobs, CommandType.StoredProcedure, "get_job_running_status",
                                                  new SqlParameter("@job_id", job_id));
            bool is_running = bool.Parse(mySqlHelper.ExecuteScalar().ToString());
            mySqlHelper.Close();
            if (is_running)
            {
                Response.Write("<script>alert('Job is still running. You should wait until the job stops.')</script>");
                return;
            }

            mySqlHelper = new SqlHelper(connStringJobsAsync, CommandType.StoredProcedure, "execute_job",
                                       new SqlParameter("@job_id", job_id));
            mySqlHelper.ExecuteNonQueryAsync();
        }
    }
}
