﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

public partial class DataUris : System.Web.UI.Page {
    private const string IMAGE_FOLDER_PATH = @"C:\Users\altair\Documents\Visual Studio 2010\Projects\EmbeddingResourcesDemo\Altairis.ResourceDemo.Controls\Resources";
    private const string IMAGE_FILE_MASK = "*.png";
    private const string CODE_LINE_FORMAT_STRING = "\"data:image/png;base64,{0}\", // {1}<br/>";
    private const string STYLE_LINE_FORMAT_STRING = ".flag.{1} {{ background-image: url(data:image/png;base64,{0}) }}<br/>";

    protected void Page_Load(object sender, EventArgs e) {
        var fileNames = Directory.GetFiles(IMAGE_FOLDER_PATH, IMAGE_FILE_MASK);
        foreach (var fileName in fileNames) {
            var data = Convert.ToBase64String(File.ReadAllBytes(fileName));
            this.LiteralCode.Text += string.Format(CODE_LINE_FORMAT_STRING, data, Path.GetFileNameWithoutExtension(fileName));
            this.LiteralStyle.Text += string.Format(STYLE_LINE_FORMAT_STRING, data, Path.GetFileNameWithoutExtension(fileName).ToLower().Substring(4));
        }
    }
}