﻿
namespace Demo
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.Data;
    using System.Linq;
    using System.ServiceModel.DomainServices.EntityFramework;
    using System.ServiceModel.DomainServices.Hosting;
    using System.ServiceModel.DomainServices.Server;


    // Implements application logic using the AdventureEntities context.
    // TODO: Add your application logic to these methods or in additional methods.
    // TODO: Wire up authentication (Windows/ASP.NET Forms) and uncomment the following to disable anonymous access
    // Also consider adding roles to restrict access as appropriate.
    // [RequiresAuthentication]
    [EnableClientAccess()]
    public class DomainService1 : LinqToEntitiesDomainService<AdventureEntities>
    {

        // TODO:
        // Consider constraining the results of your query method.  If you need additional input you can
        // add parameters to this method or create additional query methods with different names.
        // To support paging you will need to add ordering to the 'tblCustomers' query.
        public IQueryable<tblCustomer> GetTblCustomers()
        {
            //return this.ObjectContext.tblCustomers;
            return this.ObjectContext.tblCustomers.OrderBy(p => p.CustomerID);
        }

        public void InsertTblCustomer(tblCustomer tblCustomer)
        {
            if ((tblCustomer.EntityState != EntityState.Detached))
            {
                this.ObjectContext.ObjectStateManager.ChangeObjectState(tblCustomer, EntityState.Added);
            }
            else
            {
                this.ObjectContext.tblCustomers.AddObject(tblCustomer);
            }
        }

        public void UpdateTblCustomer(tblCustomer currenttblCustomer)
        {
            this.ObjectContext.tblCustomers.AttachAsModified(currenttblCustomer, this.ChangeSet.GetOriginal(currenttblCustomer));
        }

        public void DeleteTblCustomer(tblCustomer tblCustomer)
        {
            if ((tblCustomer.EntityState == EntityState.Detached))
            {
                this.ObjectContext.tblCustomers.Attach(tblCustomer);
            }
            this.ObjectContext.tblCustomers.DeleteObject(tblCustomer);
        }
    }
}


