﻿#region SVN File History
// ***********************************************************
// Copyright ©   2011 Craig Greenock.
// Contact     - cgreenock@bcs.org.uk
// Version 0.0 - 17 March 2011 20:04
// Machine     - KEFALLONIA Microsoft Windows NT 6.1.7600.0
//
// For demo purposes only. Extract methods from various class
// libraries.
//
// ***********************************************************
#endregion  // SVN File History

#region References
using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Reflection;
#endregion // References

namespace Demo
{
  
  /// <summary>
  /// This class contains a small handful of classes that normally live
  /// elsewhere.
  /// </summary>

  public class ContextMenuButton : LinkButton
  {

    // We allow an instance of a button to define its own postback 
    // behaviour in case the default behaviour isn't sufficiently flexible.
    private GetPostbackCommand customPostback;

    public delegate string GetPostbackCommand(ContextMenuButton owner);  

    public GetPostbackCommand CustomPostback
    {
      get {return customPostback;}
      set {customPostback = value;}
    }

    // We need to do this to trap the postback and convert it into an event.
    protected override void OnLoad(EventArgs e)
    {
      base.OnLoad(e);
      Demo.PostbackInfo pi = Demo.PostbackInfo.Make(Page.Request,"");
      if (pi.Target== this.UniqueID)
      {
        OnClick(new EventArgs());
      }
    }

    // This is overriden to ensure that the command argument makes it into the postback.
    protected override void Render(HtmlTextWriter writer)
    {

      // Initialise the default postback behaviour...
      string postback = Page.ClientScript.GetPostBackEventReference(this, 
                                                                    this.CommandArgument.ToUpper());

      // ...and overwrite it with any custom postback we might need.
      if (this.CustomPostback != null)
        postback = this.CustomPostback(this);

      string href = @"<a href=""javascript:{0}""  
                    style=""display:inline-block;color:{3};width:{2};"">{1}</a>";
      string colour = this.ForeColor.Name;

      if (!this.Enabled)
      {
        postback = "return;";
        colour   = System.Drawing.Color.Gray.Name;
      }

      href = string.Format(href, postback,
                                 this.Text,
                                 this.Width.ToString(),
                                 colour);
      writer.Write(href);

    }

  }

  /// <summary>
  /// Somewhere convenient to hold Form __EVENTTARGET & __EVENTARGUMENTS info.
  /// Basically I'm lazy and and only want to write the extraction code once.
  /// </summary>
  public class PostbackInfo
  {
    private string target;
    private string[] argument;

    /// <summary>
    /// Construction.
    /// </summary>
    /// <param name="eventTarget">Name of control instigating the postback.</param>
    /// <param name="eventArguments">Argument string, may be delimited.</param>
    /// <param name="argSeparator">Zero length if eventArguments not delimited.</param>
    public PostbackInfo(string eventTarget, string eventArguments, string argSeparator)
    {

      if (eventTarget != null)
        target = eventTarget;
      else
        target = "";

      if (eventArguments != null)
      {
        if (argSeparator == null || argSeparator.Length == 0)
          argument = new string[] {eventArguments};
        else
          argument = eventArguments.Split(argSeparator.ToCharArray()[0]);
      }
      else
        argument = new string[] {""};
        

    }

    /// <summary>
    /// __EVENTTARGET string.  Identifies the control firing the postback.
    /// </summary>
    public string Target
    {
      get { return target; }
      set { target = value; }
    }

    /// <summary>
    /// __EVENTARGUMENTS as string[]
    /// Length 1 where postback events are not delimited.
    /// </summary>
    public string[] Argument
    {
      get { return argument; }
      set { argument = value; }
    }

    /// <summary>
    /// I'm lazy.
    /// </summary>
    /// <param name="request"></param>
    /// <param name="argSeparator"></param>
    /// <returns></returns>
    public static PostbackInfo Make(HttpRequest request, string argSeparator)
    {
      const string argument   = "__EVENTARGUMENT";
      const string target     = "__EVENTTARGET";
      
      return new PostbackInfo(request.Form[target], 
                              request.Form[argument],
                              argSeparator);


    }

  }


  public static class ExtensionMethods
  {

    #region string methods

    /// <summary>
    /// Identify the full path in the manifest given just the resource name.
    /// </summary>
    /// <param name="resourceName"></param>
    /// <returns></returns>
    public static string ManifestResourcePath(this string resourceName)
    {
	    Assembly dll = Assembly.GetExecutingAssembly();
      resourceName = string.Format(".{0}", resourceName);
      string[] embeddedResource = dll.GetManifestResourceNames();
      foreach (string resourcePath in embeddedResource)
      {
        if (resourcePath.EndsWith(resourceName))
          resourceName = resourcePath;
      }

      return resourceName;
    }

    #endregion // string methods

 

  }

}



