<script type="text/javascript">
//<![CDATA[
function __showDialogue(dialogue)
{

  // Note how we convert ID to object.
  // If we try to hand the object in we get intermittent errors
  // when IE tries to render the page.  
  dialogue = document.all(dialogue);

  var offsetY = 5;
  var offsetX = 40;
  dialogue.style.left = window.event.x + offsetX;
  dialogue.style.top = window.event.y + offsetY;
  dialogue.style.display = "";
  window.event.cancelBubble = true;
  return false;
}


function __trapESC(element)
{
	var key = window.event.keyCode;
	if (key == 27)
	{
		element.style.display = 'none';
	}
}

// Provide concrete indication that a dialogue has been cancelled
function __cancelDialogue(controlID, dialogueID, commandArgument)
{
  var GS = String.fromCharCode(29);
  var RS = String.fromCharCode(30);
  var returnVal = '';

  returnVal = dialogueID + GS + commandArgument + '= True';

  __doPostBack(controlID, returnVal);

}


// Walk the document looking for elements identified with a div based
// dialogue and retrieve the values entered by the user.
function __getValues(controlID, dialogueKey, dialogueID, unadornedName)
{
  // Use non-printing chars to delimit return value.so that we don't
  // have to restrict what a user may enter.
  var nullValue = String.fromCharCode(2);
  var GS = String.fromCharCode(29);
  var RS = String.fromCharCode(30);
  var returnVal = '';
  
  for (i=0; i<document.all.length; i++)
  {
    if (null != document.all(i).getAttribute(dialogueKey)
        && dialogueID == document.all(i).getAttribute(dialogueKey))
    {

      // Separate multiple return values.
      if (returnVal.length > 0)
        {
        returnVal = returnVal + RS;
        }

      var v = nullValue;
      var id = document.all(i).getAttribute(unadornedName);
      var tagName = document.all(i).tagName.toLowerCase();

      switch (tagName)
      {
        case 'select':
          v = getValueSelect(i);
          break;

        default:
          v = getValueInput(i);
          break;
      }

      returnVal = returnVal + id +'=' + v;
    }
  }

  // Return value header identifies the dialogue.
  returnVal = dialogueID + GS + returnVal;

  __doPostBack(controlID, returnVal);
}

// Retrieve a value from an input tag.
function getValueInput(elementIndex)
{

  var tagName = 'input';
  var nullValue = String.fromCharCode(2);
  var returnVal = nullValue;
  
  var elementCount = document.all(elementIndex).getElementsByTagName(tagName).length;
  var elementType = '';

  switch (elementCount)
  {
  case 0:
    // Simple input field.
    returnVal = document.all(elementIndex).getAttribute('value');
    break;
  
  case 1:
    // Single input field embedded in a span, eg a checkbox or a single radio button.
    elementType = (document.all(elementIndex).getElementsByTagName(tagName)[0]).getAttribute('type');
    switch (elementType)
    {
      case 'checkbox':
      case 'radio':
        returnVal = (document.all(elementIndex).getElementsByTagName(tagName)[0]).checked;
        break;
      default:
        returnVal = (document.all(elementIndex).getElementsByTagName(tagName)[0]).getAttribute('value');
        break;
    }
    break;
  
  default:
    // Multiple input elements embedded in a span, eg a radiobuttonlist.
    for (j=0;j<elementCount;j++)
    {
      elementType = (document.all(elementIndex).getElementsByTagName(tagName)[j]).getAttribute('type');
      switch (elementType)
      {
        case 'checkbox':
        case 'radio':
          // Get the selected index for the list.
          var checked = (Boolean)((document.all(elementIndex).getElementsByTagName(tagName)[j]).checked)
          if (checked) returnVal = j;
          break;
        default:
          returnVal = (document.all(elementIndex).getElementsByTagName(tagName)[j]).getAttribute('value');
          break;
      }   // switch(elementType)
    }     // for(elementCount)
  }       // switch(elementCount)

  return returnVal;
}

// Retrieve the selected value from a select element.
function getValueSelect(elementIndex)
{
  // We assume that a dropdown list always has >= 1 members.
  var tagName = 'option';
  var nullValue = String.fromCharCode(2);
  var returnVal = nullValue;
  
  var elementCount = document.all(elementIndex).getElementsByTagName(tagName).length;

  for(j=0;j<elementCount;j++)
  {
    var selectAttrib = (document.all(elementIndex).getElementsByTagName(tagName)[j]).getAttribute('selected');
    var selected = (Boolean)(selectAttrib.length > 0);
    if (selected) 
    {
        var doc = document.all(elementIndex).getElementsByTagName(tagName)[j];
        returnVal = doc.getAttribute('value');
    }
  }  

  return returnVal;
}

//]]>
</script>


