﻿using System.Text;
namespace System.Web.Mvc
{
    public static class ControllerExtensions
    {
        public static SerializedDataResult Serialize(
            this Controller controller, object data)
        {
            return Serialize(controller, data, SerializedDataFormat.Auto, null,
                null /* contentType */, null /* contentEncoding */, SerializedDataRequestBehavior.DenyGet);
        }

        public static SerializedDataResult Serialize(
            this Controller controller, object data, SerializedDataRequestBehavior behavior)
        {
            return Serialize(controller, data, SerializedDataFormat.Auto, null,
                null /* contentType */, null /* contentEncoding */, behavior);
        }

        public static SerializedDataResult Serialize(
            this Controller controller, object data, SerializedDataFormat format, string formatParameter,
            string contentType, Encoding contentEncoding, SerializedDataRequestBehavior behavior)
        {
            return new SerializedDataResult
            {
                Data = data,
                SerializedDataFormat = format,
                FormatParameter = formatParameter,
                ContentType = contentType,
                ContentEncoding = contentEncoding,
                SerializedDataRequestBehavior = behavior
            };
        }
    }
}