﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IEnumerable<ServerExplorer.Models.FileModel>>" %>
<script src="<%= Url.Content("~/Scripts/jQuery-1.4.4.js") %>" type="text/javascript"></script>
<div id="commands">
   <% Html.RenderPartial("ActionLinks", ViewData["Parent"]);%>
</div>

<table id="listview">
    <tr class="noselect">
        <th id="one"/>
        <th id="two">
            Name
        </th>
        <th id="three">
            Date modified
        </th>
    </tr>
    <% foreach (var item in Model)
       { %>
    <tr  class="t-row noselect"">
        <td class="one">
            <%: Html.CheckBox("fileCheck", new {value = item.FullPath })%>
        </td>
        <td class="two">
            <img width="24" height="24" alt="<%= item.Category.ToString() %>" src="<%= Url.Content("~/Content/Images/" + item.Category.ToString() + ".png") %>"
                style="vertical-align: middle;" />
            <span style="padding-left: 2px;">
                <%= item.Name %></span>
        </td>
        <td  class="three">
            <%: String.Format("{0:g}", item.Modified) %>
        </td>
        <td>
            <%= Html.Hidden("fullPath", item.FullPath) %>
        </td>
    </tr>
    <% } %>
</table>

<script type="text/javascript">
    $(function () {
        $.extend($.fn.disableTextSelect = function () {
            return this.each(function () {
                if ($.browser.mozilla) {//Firefox
                    $(this).css('MozUserSelect', 'none');
                } else if ($.browser.msie) {//IE
                    $(this).bind('selectstart', function () { return false; });
                } else {//Opera, etc.
                    $(this).mousedown(function () { return false; });
                }
            });
        });
        
    });

    $(document).ready(function () {
        $("#listview .t-row").click(function () {
            $("#listview tr").removeClass("t-state-selected");
            $(this).toggleClass("t-state-selected");
        });

        $("#listview .t-row").dblclick(function () {
            var path = getApplicationPath();
            var filename = jQuery("input[name=fullPath]", this).val();
            $.ajax({
                type: "POST",
                url: path + "Explorer/GetFiles",
                data: { path: filename },
                cache: false,
                dataType: "html",
                success: function (data) {
                    $('#listpane').html(data);

                }
            })
        });

        $(':checkbox').click(function () {
            var list = new Object;
            var i = 0;
            var filename = '<%= ViewData["Parent"] %>';
            var path = getApplicationPath();
            $("input:checkbox:checked").each(function () {
                list[i++] = $(this).val();
            });
            $.ajax({
                type: "POST",
                url: path + "Explorer/LoadActionLinks",
                data: { path: filename, list: list },
                cache: false,
                dataType: "html",
                success: function (data) {
                    $('#commands').html(data);
                }
            })
        });

        $('.noselect').disableTextSelect(); //No text selection on elements with a class of 'noSelect'
        $("#listview .t-row:first").click(); 

    });


    function getApplicationPath() {
        var path = location.pathname;
        var index = path.indexOf("/Explorer");
        if (index > -1)
            return path.substr(0, index + 1);
        if (path.charAt(path.length - 1) != '/')
            path += '/';
        return path;
   }

</script>