﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using ServerExplorer.Models;

namespace ServerExplorer.Controllers
{
    public class ExplorerController : Controller
    {
        //
        // GET: /Explorer/

        public ActionResult Index()
        {
            IList<FileModel> files = FileModel.GetFiles(null);
            return View(files);
        }

        public ActionResult LoadActionLinks(string path, List<string> list)
        {
            ViewData["CheckedList"] = list;
            return PartialView("ActionLinks", path);
        }

        public ActionResult GetFiles(string path)
        {
            IList<FileModel> files = FileModel.GetFiles(path);
            ViewData["Parent"] = path;
            return PartialView("FileList", files);
        }

        public ActionResult Download(string jlist)
        {
            System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
            List<string> list = serializer.Deserialize<List<string>>(jlist);
            ZipResult result = new ZipResult();
            foreach (string path in list)
            {
                result.AddFile(FileModel.Decode(path));
            }

            return result;
        }


        public ActionResult GoUpper(string path)
        {
            string filePath = FileModel.Decode(path);
            IList<FileModel> files = new List<FileModel>();
            if (filePath == "root")
                files = FileModel.GetRootDirectories();
            else
                if (Directory.Exists(filePath))
                {
                    DirectoryInfo di = new DirectoryInfo(filePath);
                    if (di.Parent != null)
                    {
                        files = FileModel.GetFiles(di.Parent.FullName);
                        if (di.Parent.Parent != null)
                            ViewData["Parent"] = FileModel.Encode(di.Parent.Parent.FullName);
                        else
                            ViewData["Parent"] = "root";
                    }
                    else
                    {
                        files = FileModel.GetRootDirectories();
                    }
                }
            return PartialView("FileList", files);
        }

        public ActionResult GoTop()
        {
            var files = FileModel.GetRootDirectories();
            return PartialView("FileList", files);
        }
    }
}
