﻿using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VTS.Web.UI
{
    public partial class PagingWithListView : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void Profile_ItemDataBound(object sender, ListViewItemEventArgs e)
        {
            if (e.Item.ItemType == ListViewItemType.DataItem)
            {

                System.Data.DataRowView rowView = e.Item.DataItem as System.Data.DataRowView;

                Label lblProfileId = (Label)e.Item.FindControl("lblProfileId");
                Label lblName = (Label)e.Item.FindControl("lblName");
                Label lblAddress = (Label)e.Item.FindControl("lblAddress");
                Label lblEmail = (Label)e.Item.FindControl("lblEmail");
                Label lblMobile = (Label)e.Item.FindControl("lblMobile");
                Label lblStatus = (Label)e.Item.FindControl("lblStatus");

                lblProfileId.Text = rowView["ProfileId"].ToString();
                lblName.Text = rowView["Name"].ToString();
                lblAddress.Text = rowView["Address"].ToString();
                lblEmail.Text = rowView["Email"].ToString();
                lblMobile.Text = rowView["Mobile"].ToString();
                lblStatus.Text = rowView["IsActive"].ToString();                
            }
        }

        protected void Profile_Sorting(object sender, ListViewSortEventArgs e)
        {            
            String imgUrl;
            if (e.SortDirection == SortDirection.Ascending)
                imgUrl = "~/images/asc.png";
            else
                imgUrl = "~/images/desc.png";
            
            Image sortImage1 = (Image)lstProfileView.FindControl("SortImage1");
            Image sortImage2 = (Image)lstProfileView.FindControl("SortImage2");
            Image sortImage3 = (Image)lstProfileView.FindControl("SortImage3");
            Image sortImage4 = (Image)lstProfileView.FindControl("SortImage4");
            Image sortImage5 = (Image)lstProfileView.FindControl("SortImage5");
            Image sortImage6 = (Image)lstProfileView.FindControl("SortImage6");

            sortImage1.Visible = false;
            sortImage2.Visible = false;
            sortImage3.Visible = false;
            sortImage4.Visible = false;
            sortImage5.Visible = false;
            sortImage6.Visible = false;

            switch (e.SortExpression)
            {
                case "ProfileId":
                    sortImage1.Visible = true;
                    sortImage1.ImageUrl = imgUrl;                    
                    break;
                case "Name":                    
                    sortImage2.Visible = true;
                    sortImage2.ImageUrl = imgUrl;                    
                    break;
                case "Address":                    
                    sortImage3.Visible = true;
                    sortImage3.ImageUrl = imgUrl;
                    break;
                case "Email":
                    sortImage4.Visible = true;
                    sortImage4.ImageUrl = imgUrl;
                    break;
                case "Mobile":
                    sortImage5.Visible = true;
                    sortImage5.ImageUrl = imgUrl;
                    break;
                case "Status":
                    sortImage6.Visible = true;
                    sortImage6.ImageUrl = imgUrl;
                    break;
            }

        }

    }
}