﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace PradipMvcApplication.Controllers
{
    [HandleError]
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            ViewData["Message"] = "Welcome to ASP.NET MVC!";
            ViewData["CultureName"] = System.Globalization.CultureInfo.CurrentUICulture.Name;
            return View();
        }

        public ActionResult About()
        {
            ViewData["CultureName"] = System.Globalization.CultureInfo.CurrentUICulture.Name;
            return View();
        }

        public ActionResult AboutLocalization()
        {
            //It is advisible not to wite any logic in controller. Only for demo purpose I am using here. You can put this code in model
            //Here either you can take localized data from resource file or from database
            ViewData["CultureName"] = System.Globalization.CultureInfo.CurrentUICulture.Name;
            ViewData["message"] = (System.Globalization.CultureInfo.CurrentUICulture.Name == "en-US") ?
                "Content: Welcome to MVC localization demo" : "內容：歡迎到MVC演示的位置";
            return View("About");
        }

        public ActionResult AboutLocaleRedirect()
        {
            //It is advisible not to wite any logic in controller. Only for demo purpose I am using here. You can put this code in model
            ViewData["CultureName"] = System.Globalization.CultureInfo.CurrentUICulture.Name;
            return View("About_" + System.Globalization.CultureInfo.CurrentUICulture.Name);
            
        }        

        public ActionResult About_en_US()
        {
            ViewData["CultureName"] = "en-US";
            return View("About_en-US");
        }

        public ActionResult About_zh_CN()
        {
            ViewData["CultureName"] = "zh-CN";
            return View("About_zh-CN");
        }
    }
}
