﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IEnumerable<Object>>" %>
<%@ Import Namespace="PageableTableApp" %>

<!-- Custom scripts begin -->
    <script src="<%= Url.Content("/Scripts/Custom/dateformat_12.js") %>" type="text/javascript"></script>
    <script src="<%= Url.Content("/Scripts/Custom/ItemsListAjaxJS.js") %>" type="text/javascript"></script>
<!-- Custom scripts end -->

<% /* %> <script src="~/Scripts/jquery-1.4.1-vsdoc.js" type="text/javascript"></script> <% */ %>

<style type="text/css">
    a.filterButton img
    {
    	border-style: none;
    }
    
    a.filterButton
    {
        float: right;	
    }
    
    a.filterButton img
    {
    	width: 16px;
    	height: 16px;
    }
    
    #table_Persons th div
    {
        color: #000;
        text-transform: none;	
    }
    
    th.header_ID
    {
    	width: 100px;
    }
    
    th.header_Name
    {
        width: 170px;    	
    }
    
    th.header_BirthDate
    {
        width: 220px;
    }
    
    th.header_IsMarried
    {
    	width: 140px;
    }
    
    img.sortImage
    {
        width: 16px;
        height: 16px;	
        display: none;
    }
    
    thead th a.filtered, thead th a.filtered:link
    {
        color: #99CE0A;	
    }
    
    a.linkButton, a.linkButton:visited
    {
    	color: Blue;
    }
</style>

<h2>
    The list of persons (Ajax):
</h2>

<a id="a_ClearAllFilters" href="#" class="linkButton">Clear all filters</a>

<br />

<input type="checkbox" id="cbk_Instant" /> Filter instantly

<br />

Pagesize: <%= Html.DropDownList ("ddl_pageSizes", ViewData["pageSizes"] as System.Collections.Generic.List<System.Web.Mvc.SelectListItem>) %>

<br />
<br />

<center>
    <table id="table_Persons">
        <thead>
            <tr>
            <%
                foreach (var propertyName in (ViewData ["filters"] as FiltersData).Filters.Keys)
                {  %>
                <th class="<%= "header_" + propertyName %>">
                    <a id="<%= "a_" + propertyName %>" href="#">
                        <%= propertyName %> 
                    </a>

                    <div style="float: right;"></div>

                    <a href="#" class="filterButton">
                        <img src="<%= Url.Content("/Content/Images/up.jpg") %>" alt="" />
                    </a>

                    <div style="float: right; margin-right: 20px;">
                        <img class="sortImage" src="<%= Url.Content("/Content/Images/down-arrow.jpg") %>" alt="" />
                        <img class="sortImage" src="<%= Url.Content("/Content/Images/up-arrow.jpg") %>" alt="" />
                    </div>
                </th>
            <% 
                } %>
            </tr>
        </thead>
        <tbody>
            <%
                var j = 1;

                foreach (var item in Model)
                { %>
                <tr class="<%= (j++)%2 == 0 ? "" : "odd" %>">
                    <%
                        foreach (System.Reflection.PropertyInfo pInfo in Model.First ().GetType ().GetProperties ())
                        { %>
                        <td>
                            <%= pInfo.GetValue (item, null)%>
                        </td>
                    <%
                        } %>
                </tr>
            <%
                } %>
        </tbody>
        <tfoot>
            <tr>
                <td style="text-align: left;" colspan="4">
                    <% 
                        for (var i = 1; i <= (int)ViewData ["pages"]; ++i)
                        { %>

                        <a href="#" class="<%= i == (int)ViewData["page"] ? "selectedPage" : "defaultPage" %>"><%= i %></a>
                    <% 
                        } %>
                </td>
            </tr>
        </tfoot>
    </table>
    <div>
        <span id="span_NumberOfRecords"><%= ViewData["numberOfRecords"] %></span>&nbsp;records found.
    </div>
</center>

<img id="img_Loader" src="<%= Url.Content("/Content/Images/ajax-loader.gif") %>" alt="" style="display: none; position: absolute;" />

<div style="display: none;">
<%
    using (Ajax.BeginForm ("MaintainList", "ItemsList", new AjaxOptions {OnSuccess = "onSuccess_SubmitForm", OnFailure = "onFailure_SubmitForm"}))
    { 
        foreach (var propertyName in (ViewData ["filters"] as FiltersData).Filters.Keys)
        { %>
            <div id="<%= "div_" + propertyName %>">
                <%
                    foreach (FilterData fData in (ViewData["filters"] as FiltersData).Filters [propertyName]) 
                    { %>
                        <%= Html.Hidden ("filter_" + propertyName + "_" + fData.FilterText, fData.IsActive) %> 
                <% 
                    } %>
            </div>
    <%  
        } %>

        <input id="hdn_pageSize" type="hidden" name="pageSize" value="<%= ViewData["pageSize"] %>" />
        <input id="hdn_page" type="hidden" name="page" value="<%= ViewData["page"] %>" />
        <input id="hdn_showFilter" type="hidden" name="showFilter" value="" />
        <input id="hdn_sortBy" type="hidden" name="sortBy" value="<%= ViewData["sortBy"] %>" />
        <input id="hdn_sortMode" type="hidden" name="sortMode" value="<%= ViewData["sortMode"] %>" />
        <input id="hdn_scrollTop" type="hidden" name="scrollTop" value="" />

        <input id="btn_Submit" type="submit" style="display: none;" />
<%
    } %>
</div>