﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;

namespace PageableTableApp
{
    // Note: For instructions on enabling IIS6 or IIS7 classic mode, 
    // visit http://go.microsoft.com/?LinkId=9394801

    public class MvcApplication : System.Web.HttpApplication
    {
        public static void RegisterRoutes (RouteCollection routes)
        {
            routes.IgnoreRoute ("{resource}.axd/{*pathInfo}");

            routes.MapRoute (
                null, // Route name
                "", // URL with parameters
                new { controller = "ItemsList", action = "InitialList", pageSize = 4, page = 1, sortBy = String.Empty, sortMode = String.Empty } // Parameter defaults
            );

            routes.MapRoute (
                null, // Route name
                "{pageSize}/{page}", // URL with parameters
                new { controller = "ItemsList", action = "InitialList", sortBy = String.Empty, sortMode = String.Empty },
                new { pageSize = @"\d+", page = @"\d+" }
            );

            routes.MapRoute (
                null, // Route name
                "{pageSize}/{page}/{sortBy}/{sortMode}", // URL with parameters
                new { controller = "ItemsList", action = "InitialList" },
                new { pageSize = @"\d+", page = @"\d+" }
            );

            routes.MapRoute (
                null,
                "{controller}/{action}");
        }

        protected void Application_Start ()
        {
            //AreaRegistration.RegisterAllAreas ();

            RegisterRoutes (RouteTable.Routes);

            ControllerBuilder.Current.SetControllerFactory (new WindsorControllerFactory ());
        }
    }
}