﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;


namespace PageableTableApp
{
    public class FiltersData
    {
        public Dictionary<String, FilterData[]> Filters
        {
            get;

            private set;
        }


        public FiltersData (IEnumerable<Object> items)
        {
            Filters = new Dictionary<String, FilterData[]> ();

            foreach (var pInfo in items.First ().GetType ().GetProperties ())
            {
                Filters[pInfo.Name] =
                    items.Select (x => x.GetType ().GetProperty (pInfo.Name).GetValue (x, null).ToString ()).Distinct ().Select (x => new FilterData(x)).ToArray ();
            }
        }
    }
}