﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DomainModel;
using Moq;


namespace MvcTableDemo.Tests
{
    public class PersonsRepositoryCreator
    {
        public static IPersonsRepository CreatePersonsRepository (int howMany)
        {
            var theListOfPersons = new List<Person> ();

            for (var i = 0; i < howMany; ++i)
            {
                var p =
                    new Person
                    {
                        ID = i + 1,
                        Name = "Name" + i,
                        BirthDate = DateTime.Now.AddYears (-10 * i),
                        IsMarried = i % 2 == 0 ? true : false
                    };

                theListOfPersons.Add (p);
            }

            var personsRepositoryMock =
                new Mock<IPersonsRepository> ();

            personsRepositoryMock.Setup (x => x.Persons).Returns (theListOfPersons);

            return personsRepositoryMock.Object;
        }
    }
}
