using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace CSSFriendly
{
    public class MenuAdapter : System.Web.UI.WebControls.Adapters.MenuAdapter
    {
        private MenuItem firstMenuItem;
        private int subMenuNo = 1;
        public MenuAdapter()
        {
            //
        }

        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);
            RegisterScripts();
        }

        private void RegisterScripts()
        {
            Utility.RegisterScripts(Page);
            Page.ClientScript.RegisterClientScriptInclude(GetType(), GetType().ToString(), Page.ResolveUrl("~/JavaScript/MenuAdapter.js"));
        }

        protected override void RenderBeginTag(HtmlTextWriter writer)
        {
            if ((Control != null) && (Control.Attributes["CssSelectorClass"] != null) && (Control.Attributes["CssSelectorClass"].Length > 0))
            {
                writer.WriteLine();
                writer.WriteBeginTag("div");
                writer.WriteAttribute("class", Control.Attributes["CssSelectorClass"]);
                writer.Write(HtmlTextWriter.TagRightChar);
                writer.Indent++;
            }

            writer.WriteLine();
            writer.WriteBeginTag("div");
            writer.WriteAttribute("class", "AspNet-Menu-" + Control.Orientation.ToString());
            writer.Write(HtmlTextWriter.TagRightChar);
        }

        protected override void RenderEndTag(HtmlTextWriter writer)
        {
            writer.WriteEndTag("div");

            if ((Control != null) && (Control.Attributes["CssSelectorClass"] != null) && (Control.Attributes["CssSelectorClass"].Length > 0))
            {
                writer.Indent--;
                writer.WriteLine();
                writer.WriteEndTag("div");
            }
            writer.WriteLine();
        }

        protected override void RenderContents(HtmlTextWriter writer)
        {
            writer.Indent++;
            if (Control.Items.Count > 0)
                firstMenuItem = Control.Items[0];
            BuildItems(Control.Items, true, writer);
            
            writer.Indent--;
            writer.WriteLine();
        }

        private void BuildItems(MenuItemCollection items, bool isRoot, HtmlTextWriter writer)
        {
            if (items.Count > 0)
            {
                writer.WriteLine();

                writer.WriteBeginTag("ul");
                if (isRoot)
                {
                    writer.WriteAttribute("class", "AspNet-Menu");
                }
                else
                {
                    writer.WriteAttribute("class", "AspNet-SubMenu-"+subMenuNo);
                    subMenuNo++;
                }
                 //subMenuNo=1 means, this is 1st SubMenu, 2 means this is 2nd Submenu and so on
                writer.Write(HtmlTextWriter.TagRightChar);
                writer.Indent++;
                int rootItemNo = 1;
                foreach (MenuItem item in items)
                {
                    if(items.Contains(firstMenuItem))
                        BuildItem(item, writer, true, rootItemNo); // rootItemNo=1 means, this is 1st rootItemNo, 2 means this is 2nd rootItemNo, etc
                    else
                        BuildItem(item, writer, false, 0); //Here IsRootItem=false so no need rootItemNo 
                    rootItemNo++;
                }

                writer.Indent--;
                writer.WriteLine();
                writer.WriteEndTag("ul");
            }
        }

        private void BuildItem(MenuItem item, HtmlTextWriter writer, bool IsRootItem, int rootItemNo)
        {
            Menu menu = Control as Menu;
            if ((menu != null) && (item != null) && (writer != null))
            {
                writer.WriteLine();
                writer.WriteBeginTag("li");
                writer.WriteAttribute("class", item.ChildItems.Count > 0 ? "AspNet-Menu-WithChildren" : "AspNet-Menu-Leaf");
                writer.Write(HtmlTextWriter.TagRightChar);
                writer.Indent++;
                writer.WriteLine();
                if (IsRootItem)
                {
                    writer.WriteBeginTag("div");
                    writer.WriteAttribute("class", "AspNet-Menu-" + rootItemNo + "-Left");
                    writer.Write(HtmlTextWriter.TagRightChar);
                    writer.WriteEndTag("div");

                    writer.WriteLine();
                    writer.WriteBeginTag("div");
                    writer.WriteAttribute("class", "AspNet-Menu-" + rootItemNo + "-Center");
                    writer.Write(HtmlTextWriter.TagRightChar);

                    NavigationLinkWrite(menu, item, writer);

                    writer.WriteLine();
                    writer.WriteEndTag("div");

                    writer.WriteBeginTag("div");
                    writer.WriteAttribute("class", "AspNet-Menu-" + rootItemNo + "-Right");
                    writer.Write(HtmlTextWriter.TagRightChar);
                    writer.WriteEndTag("div");
                    
                }
                else 
                {
                    NavigationLinkWrite(menu, item, writer);
                }

                if ((item.ChildItems != null) && (item.ChildItems.Count > 0))
                {
                    BuildItems(item.ChildItems, false, writer);
                }

                writer.Indent--;
                writer.WriteLine();
                writer.WriteEndTag("li");
            }
        }
        private void NavigationLinkWrite(Menu menu, MenuItem item, HtmlTextWriter writer)
        {
            writer.Indent++;
            writer.WriteLine();
            if (item.NavigateUrl.Length > 0)
            {
                writer.WriteBeginTag("a");
                writer.WriteAttribute("href", Page.ResolveUrl(item.NavigateUrl));
                writer.WriteAttribute("class", "AspNet-Menu-Link");
                if (item.Target.Length > 0)
                {
                    writer.WriteAttribute("target", item.Target);
                }
                if (item.ToolTip.Length > 0)
                {
                    writer.WriteAttribute("title", item.ToolTip);
                }
                else if (menu.ToolTip.Length > 0)
                {
                    writer.WriteAttribute("title", menu.ToolTip);
                }
                writer.Write(HtmlTextWriter.TagRightChar);
                writer.Indent++;
                writer.WriteLine();
            }
            else
            {
                writer.WriteBeginTag("span");
                writer.WriteAttribute("class", "AspNet-Menu-NonLink");
                writer.Write(HtmlTextWriter.TagRightChar);
                writer.Indent++;
                writer.WriteLine();
            }

            if (item.ImageUrl.Length > 0)
            {
                writer.WriteBeginTag("img");
                writer.WriteAttribute("src", Page.ResolveUrl(item.ImageUrl));
                writer.WriteAttribute("alt", item.ToolTip.Length > 0 ? item.ToolTip : (menu.ToolTip.Length > 0 ? menu.ToolTip : item.Text));
                writer.Write(HtmlTextWriter.SelfClosingTagEnd);
            }

            writer.Write(item.Text);

            if (item.NavigateUrl.Length > 0)
            {
                writer.Indent--;
                writer.WriteLine();
                writer.WriteEndTag("a");
            }
            else
            {
                writer.Indent--;
                writer.WriteLine();
                writer.WriteEndTag("span");
            }
        }
    }
}
