using System;
using System.Web;

namespace VerticalTextExample
{

    /// <summary>
    /// Summary description for ImageViewer
    /// </summary>
    public class ImageViewer : IHttpHandler
    {
        private ImageCreationLibrary imageLib;
        private string stImagePath = @"C:\verticaltext\";//dynamicimagepath in config

        public ImageViewer()
        {
            if (System.Configuration.ConfigurationManager.AppSettings["dynamicimagepath"] != null)
            {
                this.stImagePath = System.Configuration.ConfigurationManager.AppSettings["dynamicimagepath"];
            }
            this.imageLib = new ImageCreationLibrary(stImagePath);
        }

        private void WriteImageFile(HttpContext ctx, string stFilePath)
        {
            if (stFilePath != null && System.IO.File.Exists(stFilePath))
            {
                string stContentType = "image/JPEG";
                string ext = System.IO.Path.GetExtension(stFilePath).ToLower();
                switch (ext)
                {
                    case ".gif":
                        stContentType = "image/GIF";
                        break;
                    case ".png":
                        stContentType = "image/PNG";
                        break;
                }
                ctx.Response.ContentType = stContentType;
                ctx.Response.WriteFile(stFilePath);
            }
        }
        #region IHttpHandler Members

        // Override the ProcessRequest method.
        public void ProcessRequest(HttpContext context)
        {
            try
            {
                //get the text passed in
                string stText = context.Request.QueryString["text"];
                if (stText != null && stText != "")
                {
                    string stFileName = this.imageLib.CreateVerticalTextImage(stText, new System.Drawing.Font(System.Drawing.FontFamily.GenericSerif, 12));
                    this.WriteImageFile(context, stFileName);
                }
            }
            catch (Exception Ex)
            {
                throw Ex;
            }

        }

        // Override the IsReusable property.
        public bool IsReusable
        {
            get { return false; }
        }

        #endregion
    }
}
