using System;
using System.Drawing;
using System.IO;

/// <summary>
/// Summary description for ImageCreationLibrary
/// </summary>
public class ImageCreationLibrary
{
    private string _baseImagePath;
    public string BaseImagePath { get { return this._baseImagePath; } set { this._baseImagePath = value; } }

    private Graphics _graphics;

    public ImageCreationLibrary(string stBasePath)
    {
        this._baseImagePath = stBasePath;
        System.Drawing.Image i = (Image)new Bitmap(1000, 1000);
        _graphics = Graphics.FromImage(i);
    }

    public string CreateVerticalTextImage(string stText, Font f)
    {
        string stFileName = Toolbox.GetMD5String(stText);
        string stFullFilePath = this._baseImagePath + stFileName + ".jpg";
        if (!File.Exists(stFullFilePath))
        {
            StringFormat stringFormat = new StringFormat();
            stringFormat.FormatFlags = StringFormatFlags.DirectionVertical;

            SizeF imageSize = _graphics.MeasureString(stText, f, 25, stringFormat);
            System.Drawing.Image i = (Image)new Bitmap((int)imageSize.Width, (int)imageSize.Height);
            Graphics g = Graphics.FromImage(i);
            g.FillRectangle(Brushes.White, 0, 0, i.Width, i.Height);

            //flip the image 180 degrees
            g.TranslateTransform(i.Width, i.Height);
            g.RotateTransform(180.0F);

            g.DrawString(stText, f, Brushes.Black, 0, 0, stringFormat);

            i.Save(stFullFilePath, System.Drawing.Imaging.ImageFormat.Jpeg);
        }
        return stFullFilePath;
    }

}
