﻿using System;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Net;
using System.IO;
using OAuth.Net.Common;
using OAuth.Net.Components;
using OAuth.Net.Consumer;
using OAuth;
using System.Text;
using System.Xml;
using System.Collections;
using System.Collections.Generic;
using System.Net.Mail;
using System.Text.RegularExpressions;

public partial class test_oauth_test : System.Web.UI.Page
{
    public string ConsumerKey
    {
        get
        {
            return "YOUR_CONSUMER_KEY";
        }
    }
    public string ConsumerSecret
    {
        get
        {
            return "YOUR_CUSTOMER_SECRET_KEY";
        }
    }

    public string OauthVerifier
    {
        get
        {
            try
            {
                if (!string.IsNullOrEmpty(Session["Oauth_Verifier"].ToString()))
                    return Session["Oauth_Verifier"].ToString();
                else
                    return string.Empty;
            }
            catch
            {
                return string.Empty;
            }
        }
        set
        {
            Session["Oauth_Verifier"] = value;
        }
    }
    public string OauthToken
    {
        get
        {
            if (!string.IsNullOrEmpty(Session["Oauth_Token"].ToString()))
                return Session["Oauth_Token"].ToString();
            else
                return string.Empty;
        }
        set
        {
            Session["Oauth_Token"] = value;
        }
    }
    public string OauthTokenSecret
    {
        get
        {
            if (!string.IsNullOrEmpty(Session["Oauth_Token_Secret"].ToString()))
                return Session["Oauth_Token_Secret"].ToString();
            else
                return string.Empty;
        }
        set
        {
            Session["Oauth_Token_Secret"] = value;
        }
    }
    public string OauthSessionHandle
    {
        get
        {
            if (!string.IsNullOrEmpty(Session["Oauth_Session_Handle"].ToString()))
                return Session["Oauth_Session_Handle"].ToString();
            else
                return string.Empty;
        }
        set
        {
            Session["Oauth_Session_Handle"] = value;
        }
    }
    public string OauthYahooGuid
    {
        get
        {
            try
            {
                if (!string.IsNullOrEmpty(Session["Oauth_Yahoo_Guid"].ToString()))
                    return Session["Oauth_Yahoo_Guid"].ToString();
                else
                    return string.Empty;
            }
            catch
            {
                return string.Empty;
            }
        }
        set
        {
            Session["Oauth_Yahoo_Guid"] = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            string oauth_token = Request["oauth_token"];
            string oauth_verifier = Request["oauth_verifier"];

            if (!string.IsNullOrEmpty(oauth_verifier) && oauth_verifier != "")
            {
                Button1.Visible = false;
                OauthToken = oauth_token;
                OauthVerifier = oauth_verifier;
                RegisterStartupScript("refresh", "<script type='text/javascript'>window.opener.location = 'oauth-test.aspx'; self.close();</script>");
            }
            else if (!string.IsNullOrEmpty(OauthVerifier))
            {
                Button1.Visible = false;
                if (string.IsNullOrEmpty(OauthYahooGuid))
                    GetAccessToken(OauthToken, OauthVerifier);
                //RefreshToken();
                RetriveContacts();
            }
        }

    }
    private string GetRequestToken()
    {
        string authorizationUrl = string.Empty;
        OAuthBase oauth = new OAuthBase();

        Uri uri = new Uri("https://api.login.yahoo.com/oauth/v2/get_request_token");
        string nonce = oauth.GenerateNonce();
        string timeStamp = oauth.GenerateTimeStamp();
        string normalizedUrl;
        string normalizedRequestParameters;
        string sig = oauth.GenerateSignature(uri, ConsumerKey, ConsumerSecret, string.Empty, string.Empty, "GET", timeStamp, nonce, OAuthBase.SignatureTypes.PLAINTEXT, out normalizedUrl, out normalizedRequestParameters); //OAuthBase.SignatureTypes.HMACSHA1
        StringBuilder sbRequestToken = new StringBuilder(uri.ToString());
        sbRequestToken.AppendFormat("?oauth_nonce={0}&", nonce);
        sbRequestToken.AppendFormat("oauth_timestamp={0}&", timeStamp);
        sbRequestToken.AppendFormat("oauth_consumer_key={0}&", ConsumerKey);
        sbRequestToken.AppendFormat("oauth_signature_method={0}&", "PLAINTEXT"); //HMAC-SHA1
        sbRequestToken.AppendFormat("oauth_signature={0}&", sig);
        sbRequestToken.AppendFormat("oauth_version={0}&", "1.0");
        sbRequestToken.AppendFormat("oauth_callback={0}", HttpUtility.UrlEncode("http://www.yoursite.com/yahoo-oauth/default.aspx"));
        //Response.Write(sbRequestToken.ToString());
        //Response.End();

        try
        {
            string returnStr = string.Empty;
            string[] returnData;

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(sbRequestToken.ToString());
            HttpWebResponse res = (HttpWebResponse)req.GetResponse();
            StreamReader streamReader = new StreamReader(res.GetResponseStream());
            returnStr = streamReader.ReadToEnd();
            returnData = returnStr.Split(new Char[] { '&' });
            //Response.Write(returnStr);

            int index;
            if (returnData.Length > 0)
            {
                //index = returnData[0].IndexOf("=");
                //string oauth_token = returnData[0].Substring(index + 1);
                //Session["Oauth_Token"] = oauth_token;

                index = returnData[1].IndexOf("=");
                string oauth_token_secret = returnData[1].Substring(index + 1);
                OauthTokenSecret = oauth_token_secret;

                //index = returnData[2].IndexOf("=");
                //int oauth_expires_in;
                //Int32.TryParse(returnData[2].Substring(index + 1), out oauth_expires_in);
                //Session["Oauth_Expires_In"] = oauth_expires_in;

                index = returnData[3].IndexOf("=");
                string oauth_request_auth_url = returnData[3].Substring(index + 1);
                authorizationUrl = HttpUtility.UrlDecode(oauth_request_auth_url);
            }
        }
        catch (WebException ex)
        {
            Response.Write(ex.Message);
        }
        return authorizationUrl;
    }
    private void RedirectUserForAuthorization(string authorizationUrl)
    {
        //Response.Redirect(authorizationUrl);
        RegisterStartupScript("openwin", "<script type='text/javascript'>window.open('" + authorizationUrl + "','mywindow', 'left=250,top=50,menubar=0,resizable=0,location=1,toolbar=0,status=1,scrollbars=0,width=500,height=455');</script>");
    }
    private void GetAccessToken(string oauth_token, string oauth_verifier)
    {
        OAuthBase oauth = new OAuthBase();

        Uri uri = new Uri("https://api.login.yahoo.com/oauth/v2/get_token");
        string nonce = oauth.GenerateNonce();
        string timeStamp = oauth.GenerateTimeStamp();
        string sig = ConsumerSecret + "%26" + OauthTokenSecret;

        StringBuilder sbAccessToken = new StringBuilder(uri.ToString());
        sbAccessToken.AppendFormat("?oauth_consumer_key={0}&", ConsumerKey);
        sbAccessToken.AppendFormat("oauth_signature_method={0}&", "PLAINTEXT"); //HMAC-SHA1
        sbAccessToken.AppendFormat("oauth_signature={0}&", sig);
        sbAccessToken.AppendFormat("oauth_timestamp={0}&", timeStamp);
        sbAccessToken.AppendFormat("oauth_version={0}&", "1.0");
        sbAccessToken.AppendFormat("oauth_token={0}&", oauth_token);
        sbAccessToken.AppendFormat("oauth_nonce={0}&", nonce);
        sbAccessToken.AppendFormat("oauth_verifier={0}", oauth_verifier);
        //Response.Write(sbAccessToken.ToString());
        //Response.End();

        try
        {
            string returnStr = string.Empty;
            string[] returnData;

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(sbAccessToken.ToString());
            HttpWebResponse res = (HttpWebResponse)req.GetResponse();
            StreamReader streamReader = new StreamReader(res.GetResponseStream());
            returnStr = streamReader.ReadToEnd();
            returnData = returnStr.Split(new Char[] { '&' });
            //Response.Write(returnStr);
            //Response.End();

            int index;
            if (returnData.Length > 0)
            {
                index = returnData[0].IndexOf("=");
                OauthToken = returnData[0].Substring(index + 1);

                index = returnData[1].IndexOf("=");
                string oauth_token_secret = returnData[1].Substring(index + 1);
                OauthTokenSecret = oauth_token_secret;

                //index = returnData[2].IndexOf("=");
                //int oauth_expires_in;
                //Int32.TryParse(returnData[2].Substring(index + 1), out oauth_expires_in);

                index = returnData[3].IndexOf("=");
                string oauth_session_handle = returnData[3].Substring(index + 1);
                OauthSessionHandle = oauth_session_handle;

                //index = returnData[4].IndexOf("=");
                //int oauth_authorization_expires_in;
                //Int32.TryParse(returnData[4].Substring(index + 1), out oauth_authorization_expires_in);

                index = returnData[5].IndexOf("=");
                string xoauth_yahoo_guid = returnData[5].Substring(index + 1);
                OauthYahooGuid = xoauth_yahoo_guid;
            }
        }
        catch (WebException ex)
        {
            Response.Write(ex.Message);
        }
    }
    private void RefreshToken()
    {
        OAuthBase oauth = new OAuthBase();

        Uri uri = new Uri("https://api.login.yahoo.com/oauth/v2/get_token");
        string nonce = oauth.GenerateNonce();
        string timeStamp = oauth.GenerateTimeStamp();
        string sig = ConsumerSecret + "%26" + OauthTokenSecret;

        StringBuilder sbrefreshToken = new StringBuilder(uri.ToString());
        sbrefreshToken.AppendFormat("?oauth_consumer_key={0}&", ConsumerKey);
        sbrefreshToken.AppendFormat("oauth_signature_method={0}&", "PLAINTEXT"); //HMAC-SHA1
        sbrefreshToken.AppendFormat("oauth_signature={0}&", sig);
        sbrefreshToken.AppendFormat("oauth_timestamp={0}&", timeStamp);
        sbrefreshToken.AppendFormat("oauth_version={0}&", "1.0");
        sbrefreshToken.AppendFormat("oauth_token={0}&", OauthToken);
        sbrefreshToken.AppendFormat("oauth_session_handle={0}&", OauthSessionHandle);
        sbrefreshToken.AppendFormat("oauth_nonce={0}", nonce);

        try
        {
            string returnStr = string.Empty;
            string[] returnData;

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(sbrefreshToken.ToString());
            HttpWebResponse res = (HttpWebResponse)req.GetResponse();
            StreamReader streamReader = new StreamReader(res.GetResponseStream());
            returnStr = streamReader.ReadToEnd();
            returnData = returnStr.Split(new Char[] { '&' });
            //Response.Write(returnStr);

            int index;
            if (returnData.Length > 0)
            {
                index = returnData[0].IndexOf("=");
                string oauth_token = returnData[0].Substring(index + 1);
                OauthToken = oauth_token;

                index = returnData[1].IndexOf("=");
                string oauth_token_secret = returnData[1].Substring(index + 1);
                OauthTokenSecret = oauth_token_secret;

                //index = returnData[2].IndexOf("=");
                //int oauth_expires_in;
                //Int32.TryParse(returnData[2].Substring(index + 1), out oauth_expires_in);

                index = returnData[3].IndexOf("=");
                string oauth_session_handle = returnData[3].Substring(index + 1);
                OauthSessionHandle = oauth_session_handle;

                //index = returnData[4].IndexOf("=");
                //int oauth_authorization_expires_in;
                //Int32.TryParse(returnData[4].Substring(index + 1), out oauth_authorization_expires_in);

                index = returnData[5].IndexOf("=");
                string xoauth_yahoo_guid = returnData[5].Substring(index + 1);
                OauthYahooGuid = xoauth_yahoo_guid;
            }
        }
        catch (WebException ex)
        {
            Response.Write(ex.Message);
        }
    }
    private void RetriveContacts()
    {
        OAuthBase oauth = new OAuthBase();

        Uri uri = new Uri("http://social.yahooapis.com/v1/user/" + OauthYahooGuid + "/contacts?format=XML");
        string nonce = oauth.GenerateNonce();
        string timeStamp = oauth.GenerateTimeStamp();
        string normalizedUrl;
        string normalizedRequestParameters;
        string sig = oauth.GenerateSignature(uri, ConsumerKey, ConsumerSecret, OauthToken, OauthTokenSecret, "GET", timeStamp, nonce, OAuthBase.SignatureTypes.HMACSHA1, out normalizedUrl, out normalizedRequestParameters);

        StringBuilder sbGetContacts = new StringBuilder(uri.ToString());

        //Response.Write("URL: " + sbGetContacts.ToString());
        //Response.End();

        try
        {
            string returnStr = string.Empty;
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(sbGetContacts.ToString());
            req.Method = "GET";

            string authHeader = "Authorization: OAuth " +
            "realm=\"yahooapis.com\"" +
            ",oauth_consumer_key=\"" + ConsumerKey + "\"" +
            ",oauth_nonce=\"" + nonce + "\"" +
            ",oauth_signature_method=\"HMAC-SHA1\"" +
            ",oauth_timestamp=\"" + timeStamp + "\"" +
            ",oauth_token=\"" + OauthToken + "\"" +
            ",oauth_version=\"1.0\"" +
            ",oauth_signature=\"" + HttpUtility.UrlEncode(sig) + "\"";

            //Response.Write("</br>Headers: " + authHeader);

            req.Headers.Add(authHeader);

            HttpWebResponse res = (HttpWebResponse)req.GetResponse();
            StreamReader streamReader = new StreamReader(res.GetResponseStream());
            returnStr = streamReader.ReadToEnd();
            XmlDocument xmldoc = new XmlDocument();
            xmldoc.LoadXml(returnStr);
            XmlNodeList elemList = xmldoc.DocumentElement.GetElementsByTagName("fields");

            ArrayList emails = new ArrayList();
            for (int i = 0; i < elemList.Count; i++)
            {
                if (elemList[i].ChildNodes[1].InnerText == "email")
                    emails.Add(elemList[i].ChildNodes[2].InnerText);
                //Response.Write(elemList[i].ChildNodes[2].InnerText + "<br/>");
            }
            grvMyFriends.DataSource = emails;
            grvMyFriends.DataBind();
        }
        #region error
        catch (WebException ex)
        {
            //Response.Write(ex.Message);
            Response.Write("<br/>" + ex.Message + "</br>xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
            Response.Write("<br/>length: " + ex.Source.Length.ToString());
            Response.Write("<br/>stack trace: " + ex.StackTrace);
            Response.Write("<br/>status: " + ex.Status.ToString());
            HttpWebResponse res = (HttpWebResponse)ex.Response;
            int code = Convert.ToInt32(res.StatusCode);

            Response.Write("<br/>Status Code: (" + code.ToString() + ") " + res.StatusCode.ToString());
            Response.Write("<br/>Status Description: " + res.StatusDescription);

            if (ex.InnerException != null)
            {
                Response.Write("<br/>innerexception: " + ex.InnerException.Message);
            }

            if (ex.Source.Length > 0)
                Response.Write("<br/>source: " + ex.Source.ToString());

            if (res != null)
            {
                for (int i = 0; i < res.Headers.Count; i++)
                {
                    Response.Write("<br/>headers: " + i.ToString() + ": " + res.Headers[i]);
                }
            }
        }
        #endregion error
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        string authorizationUrl = string.Empty;
        authorizationUrl = GetRequestToken();
        RedirectUserForAuthorization(authorizationUrl);
    }
   
}
