﻿#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TypesFromXsdGenerator
{
    class TagTemplate : TemplateBase, IGroupItem
    {
        public TagTemplate()
        {
            Attributes = new List<AttributeItem>();
            PossibleChilds = new List<TagTemplate>();
        }

        public TagTemplate(String name)
        {
            Attributes = new List<AttributeItem>();
            PossibleChilds = new List<TagTemplate>();
            Name = name;
            ClassName = "Tag" + char.ToUpper(name[0]) + name.Substring(1);
            InterfaceName = "I" + ClassName;
            InterfaceNameForChilds = InterfaceName + "Child";
            MethodName = name == "base" || name == "object" ? "@" + name : name;
        }
        public String Name { get; set; }
        public String ClassName { get; set; }
        public String InterfaceName { get; set; }
        public String InterfaceNameForChilds { get; set; }
        public String MethodName { get; set; }
        public List<AttributeItem> Attributes { get; set; }
        public List<TagTemplate> PossibleChilds { get; set; }

        public bool CanBeIncludedIntoFullAdoptability()
        {
            return PossibleChilds.Count == 0;
        }

        public override string Render()
        {
            var tab = "".PadRight(8);
            var attrParams = new StringBuilder();
            var attrInits = new StringBuilder();
            var attrProps = new StringBuilder();
            foreach (var attribute in Attributes)
            {
                attrParams.AppendLine(tab + tab + attribute.GetParam() + ",");
                attrInits.AppendLine(tab + tab + attribute.GetInitializer());
                attrProps.AppendLine(tab + attribute.GetProperty());
            }
            return TemplateStr.Replace("T_Tag", ClassName)
                              .Replace("T_TAG_NAME", Name)
                              .Replace("T_ATTRS_PARAMS", attrParams.ToString().Substring(0, attrParams.ToString().LastIndexOf(',')))
                              .Replace("T_ATTRS_INIT", attrInits.ToString())
                              .Replace("T_ATTRS_PROPS", attrProps.ToString());
        }

        public override string GetFileName()
        {
            return ClassName + ".cs";
        }

        public String GetMethodForBuilder()
        {
            //return String.Format("public {0} {1} {{ get {{ return new {0}(); }} }}", ClassName, MethodName);
            return String.Format("public virtual {0} {1} {{ get {{ return new {0}(); }} }}", ClassName, MethodName);
        }

    }
}
