﻿#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TypesFromXsdGenerator
{
    class Group<T> where T:class, IGroupItem, new()
    {
        public Group()
        {
            Items = new List<T>();
            SubGroups = new List<Group<T>>();
        }
        public List<T> Items { get; set; }
        public List<Group<T>> SubGroups { get; set; }
        public String Name { get; set; }
        public List<T> GatAllItems()
        {
            var res = new List<T>();
            res.AddRange(Items);
            foreach (var attributeGroup in SubGroups)
            {
                res.AddRange(attributeGroup.GatAllItems());
            }

            return res;
        }

        public Group<T> GetGroupByName(String name)
        {
            foreach (var subGroup in SubGroups)
            {
                if (subGroup.Name == name) return subGroup;
            }
            return new Group<T>();
        }

        public T GetItemByName(String name)
        {
            foreach (var item in Items)
            {
                if (item.Name == name) return item;
            }
            foreach (var subGroup in SubGroups)
            {
                var temp = subGroup.GetItemByName(name);
                if (temp != null) return temp;
            }
            var defRes = new T();
            defRes.Name = name;
            return defRes;
        }
    }
}
