﻿#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace TypesFromXsdGenerator
{
    class AttributeItem : IGroupItem
    {

        public String Name { get; set; }
        public TypeTemplate Type { get; set; }
        
        public String GetNameForRender()
        {
            if (Name == "class") return "cssClass";
            if (Name == "char") return "character";
            if (Name == "readonly") return "isReadonly";
            if (Name == "checked") return "Ischecked";
            if (Name == "for") return "forElement";

            return Name.Replace(':','_').Replace('-','_');
        }

        public String GetNameForProperty()
        {
            var info = CultureInfo.CurrentCulture.TextInfo;
            return info.ToTitleCase(GetNameForRender());
        }

        

        public string GetProperty()
        {
            //return String.Format("public {1} {0} {{ get; set; }}", GetNameForProperty(), Type.GetNameForRender());
            return
                String.Format(
                    "public virtual {1} {0}{{get {{ return GetAttr<{1}>(); }} set {{ SetAttr(value); }}}}", GetNameForProperty(), Type.GetClassNameForRender());
        }

        public string GetParam()
        {
            return String.Format("{1} {0} = {2}", GetNameForRender(), Type.GetClassNameForRender(), Type.DefaultValue);
        }

        public string GetInitializer()
        {
            return String.Format("{0} = {1};", GetNameForProperty(), GetNameForRender());
        }

        public void Populate(XElement attrEleemnt, Group<TypeTemplate> types)
        {
            if (attrEleemnt.Attribute("name") != null)
            {
                Name = attrEleemnt.Attribute("name").Value;
                if (attrEleemnt.Attribute("type") != null)
                    Type = types.GetItemByName(attrEleemnt.Attribute("type").Value);
                else Type = new TypeTemplate { Name = "String", Type = "String", DefaultValue = "\"\"" };
            }
            else
            {
                Name = attrEleemnt.Attribute("ref").Value;
                Type = new TypeTemplate { Name = "String", Type = "String", DefaultValue = "\"\"" };
            }


        }
    }
}
