#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using SharpDom.Attributes;
using SharpDom.Navigation;

namespace SharpDom.Tags
{
    /// <summary>Implementation of param tag</summary>
    [Parentship(typeof(ITagParamChild))]
    [Adoptability(typeof(ITagParamAdoptability))]
    public class TagParam : IndexedTag
    {
        /// <summary>Default constructor assigning the tag name</summary>
        public TagParam() : base("param") { }

        public virtual AttrId Id { get { return GetAttr<AttrId>(); } set { SetAttr(value); } }
        public virtual AttrName Name { get { return GetAttr<AttrName>(); } set { SetAttr(value); } }
        public virtual AttrValue Value { get { return GetAttr<AttrValue>(); } set { SetAttr(value); } }
        public virtual AttrValueType ValueType { get { return GetAttr<AttrValueType>(); } set { SetAttr(value); } }
        public virtual AttrType Type { get { return GetAttr<AttrType>(); } set { SetAttr(value); } }

        /// <summary>Assigns all needed attributes to the tag</summary>
        /// <returns>This instance downcasted to base class</returns>
        public virtual IndexedTag attr(
            AttrId id = null,
            AttrName name = null,
            AttrValue value = null,
            AttrValueType valuetype = null,
            AttrType type = null
        )
        {
            Id = id;
            Name = name;
            Value = value;
            ValueType = valuetype;
            Type = type;

            return this;
        }
    }
}
