﻿#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion

using System;
using System.IO;
using System.Text;
using System.Web;
using System.Web.Mvc;

namespace SharpDom.Mvc
{
    public abstract class SharpDomView<T> : HtmlPageBuilder<T>, IView, IViewDataContainer, IViewWithContext
    {
        #region View Context, HTTP Context, View Data, View Model

        private ViewContext _viewContext;
        /// <summary>
        /// Current View context
        /// </summary>
        public ViewContext ViexContext
        {
            get { return _viewContext; }
        }

        private UrlHelper _urlHelper;
        /// <summary>
        /// Url helper
        /// </summary>
        public UrlHelper Url
        {
            get { return _urlHelper; }
        }

        private HtmlHelper<T> _htmlHelper;
        /// <summary>
        /// Html helper, can be used with standard asp.net mvc html helpers like ActionLink
        /// </summary>
        public HtmlHelper<T> Html
        {
            get { return _htmlHelper; }
        }

        private ViewDataDictionary<T> _viewData;
        /// <summary>
        /// Obsolete probably will be removed or hided
        /// </summary>
        public ViewDataDictionary ViewData
        {
            get
            {
                if (_viewData == null)
                {
                    SetViewData(new ViewDataDictionary<T>());
                }
                return _viewData;
            }
            set { SetViewData(value); }
        }

        /// <summary>
        /// Set current view data
        /// </summary>
        /// <param name="viewData">current view data</param>
        protected virtual void SetViewData(ViewDataDictionary viewData)
        {
            _viewData = new ViewDataDictionary<T>(viewData);
        }

        #endregion

        /// <summary>
        /// This method renders current view andinvokes child types render method
        /// </summary>
        /// <param name="viewContext">current view context</param>
        /// <param name="writer">text writer</param>
        public void Render(ViewContext viewContext, TextWriter writer)
        {
            try
            {
                SetContext(viewContext);
                SetViewData(viewContext.ViewData);
                Render(_viewData.Model, writer);
            }
            finally
            {
                _viewContext = null;
                _viewData = null;
            }
        }

        /// <summary>
        /// Helper method to set current context. We usually need it when copy context from and to master pages and user controls.
        /// </summary>
        /// <param name="viewContext">current view context</param>
        /// <returns></returns>
        public void SetContext(ViewContext viewContext)
        {
            _htmlHelper = new HtmlHelper<T>(viewContext, this);
            _urlHelper = new UrlHelper(viewContext.RequestContext);
            _viewContext = viewContext;
        }
        public override TBuilder CreateBuilder<TBuilder>(ContainerTag container = null)
        {
            var res = base.CreateBuilder<TBuilder>(container);
            (res as IViewWithContext).SetContext(ViexContext);
            return res;
        }
        ///// <summary>Creates builder nested into this builder</summary>
        ///// <typeparam name="TBuilder">Type of nested builder</typeparam>
        ///// <param name="container">Top container tag of this (parent) builder</param>
        ///// <param name="viewContext">Current view context</param>
        ///// <returns>Just newly created parent page builder with assigned top container</returns>
        //public virtual TBuilder CreateBuilder<TBuilder>(ViewContext viewContext, ContainerTag container = null) 
        //    where TBuilder : AbstractBuilder, IViewWithContext, new()
        //{
        //    var res = CreateBuilder<TBuilder>(container);
        //    res.SetContext(viewContext);
        //    return res;
        //}

    }
}
