﻿#region Copyright(c) Anton Shelin, Vladimir Timashkov. All Rights Reserved.
// -----------------------------------------------------------------------------
// Copyright(c) 2010 Anton Shelin, Vladimir Timashkov. All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. No Trademark License - Microsoft Public License (Ms-PL) does not grant you rights to use
//      authors names, logos, or trademarks.
//   2. If you distribute any portion of the software, you must retain all copyright,
//      patent, trademark, and attribution notices that are present in the software.
//   3. If you distribute any portion of the software in source code form, you may do
//      so only under this license by including a complete copy of Microsoft Public License (Ms-PL)
//      with your distribution. If you distribute any portion of the software in compiled
//      or object code form, you may only do so under a license that complies with
//      Microsoft Public License (Ms-PL).
//   4. The names of the authors may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// The software is licensed "as-is." You bear the risk of using it. The authors
// give no express warranties, guarantees or conditions. You may have additional consumer
// rights under your local laws which this license cannot change. To the extent permitted
// under your local laws, the authors exclude the implied warranties of merchantability,
// fitness for a particular purpose and non-infringement.
// -----------------------------------------------------------------------------
#endregion
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc.Html;
using SharpDom;
using SharpDom.Mvc;

namespace MvcAppSample.Views.Shared
{
    /// <summary>
    /// Main master page for other content pages
    /// </summary>
    public class SiteMaster : SharpDomView<Object>
    {
        /// <summary>
        /// Placeholder for page title
        /// </summary>
        public virtual PlaceHolderDelegate TitleContent { get; set; }
        /// <summary>
        /// Placeholder for main content
        /// </summary>
        public virtual PlaceHolderDelegate MainContent { get; set; }
        /// <summary>
        /// Linked user control
        /// </summary>
        public virtual LogOnUserControl LogOnUserControl { get { return CreateBuilder<LogOnUserControl>(); } }

        /// <summary>
        /// Main render method. It creates master page tags tree
        /// </summary>
        /// <param name="container"></param>
        /// <returns></returns>
        public override ContainerTag CreateTagTree(ContainerTag container)
        {
            return container
                            [
                                html.attr(xmlns: "http://www.w3.org/1999/xhtml")[
                                    head[
                                        title[PlaceHolder(TitleContent)],
                                        link.attr(href: "../../Content/Site.css", rel: "stylesheet", type: "text/css")
                                    ],
                                    body[
                                        div.attr(cssclass:"page")[

                                            div.attr(id:"header")[
                                                div.attr(id:"title")[
                                                    h1["My MVC Application"]
                                                ],
              
                                                div.attr(id:"logindisplay")[
                                                    LogOnUserControl.CreateTags(null)//here we get tags sub tree from LogOn user control
                                                ],
            
                                                div.attr(id:"menucontainer")[
            
                                                    ul.attr(id:"menu")[
                                                        li[ Html.ActionLink("Home", "Index", "Home").ToLiteral()],// we can use standard asp.net mvc html helpers
                                                        li[ Html.ActionLink("About", "About", "Home").ToLiteral()]
                                                    ]
            
                                                ]
                                            ],

                                            div.attr(id:"main")[
                                                PlaceHolder(MainContent),//here we get tags sub tree from main placeholder of content page
                                                div.attr(id:"footer")
                                            ]
                                        ]
                                    ]
                                ]
                            ];
        }
    }
}