using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

public partial class UI_TaskDetails : System.Web.UI.Page
{
    string projectId;
    public string ProjectId
    {
        set { projectId = value; }
        get { return projectId; }
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        string userId = Session["userId"].ToString();
        string userRole = Session["userRole"].ToString();
        this.Master.userId = userId;
        this.Master.UserRole = userRole;
        this.TaskInformation();
        
        ContainerPanel.Visible = false;
        if (userRole == "User")
        {
            endTaskButton.Visible = false;
        }
    }
    
    private void TaskInformation()
    {
        string taskId = Request.QueryString["taskId"].ToString();
        TaskBLL taskBllObj = new TaskBLL();
        DataTable dt = taskBllObj.SelectTaskInformation(taskId);
        taskIdTextBox.Text = dt.Rows[0]["TaskId"].ToString();
        projectNameTextBox.Text = dt.Rows[0]["ProjectName"].ToString();
        taskNameTextBox.Text = dt.Rows[0]["TaskName"].ToString();
        taskDescriptionTextBox.Text = dt.Rows[0]["TaskDescription"].ToString();
        creationDateTextBox.Text = dt.Rows[0]["TaskCreationDate"].ToString();
        endDateTextBox.Text = dt.Rows[0]["TaskEndDate"].ToString();
        taskOwnerTextBox.Text = dt.Rows[0]["UserId"].ToString();
        this.ProjectId= dt.Rows[0]["ProjectId"].ToString();
        Label19.Text = dt.Rows[0]["ProjectId"].ToString();
    }
    protected void createCommentLinkButton_Click(object sender, EventArgs e)
    {
        ContainerPanel.Visible = true;

    }
    protected void createCommentButton_Click(object sender, EventArgs e)
    {
        string taskId = Request.QueryString["taskId"].ToString();
        TaskBLL taskBllObj = new TaskBLL();
        DataTable dt = taskBllObj.SelectTaskInformation(taskId);


        string projectId = dt.Rows[0]["ProjectId"].ToString(); 
        string commentBody = commntTextBox.Text;
        string commentSenderId = Session["userId"].ToString();
        string attachmentAddress = Path.GetFileName(FileUpload1.PostedFile.FileName).ToString(); ;
        CommentBLL commentBllObj = new CommentBLL();
        if (attachmentAddress=="")
        {
            
            //attachmentAddress = string.Empty;
            commentBllObj.InserNewComments(commentBody,taskId,projectId,commentSenderId,attachmentAddress);


        }
        else
        {
           // attachmentAddress = Path.GetFileName(FileUpload1.PostedFile.FileName).ToString();
            if (FileUpload1.PostedFile.ContentLength != 0)
            {
                try
                {
                    if (FileUpload1.PostedFile.ContentLength > 100000)
                    {
                        statusLabel.Text = "The size of the file is too large.";
                    }
                    else
                    {
                        string destinationDir = Server.MapPath("./Store");
                        string fileName = Path.GetFileName(FileUpload1.PostedFile.FileName);
                        string destinationPath = Path.Combine(destinationDir, fileName);
                        FileUpload1.PostedFile.SaveAs(destinationPath);


                    }


                }
                catch (Exception ex)
                {
                    statusLabel.Text = ex.Message;
                }
                commentBllObj.InserNewComments(commentBody, taskId, projectId, commentSenderId, attachmentAddress);
            }
            else
            {
                attachmentAddress = "";
            }

           
           

        }
        Response.Redirect("~/UI/TaskDetails.aspx?taskId="+taskId);

    }
    protected void forwardTaskButton_Click(object sender, EventArgs e)
    {
        string taskId = Request.QueryString["taskId"].ToString();
        string userId = DropDownList1.Text;
        TaskBLL taskBllObj = new TaskBLL();
        taskBllObj.ForwardTask(Request.QueryString["taskId"].ToString(), userId);
        Response.Redirect("~/UI/TaskDetails.aspx?taskId=" + taskId);
    }
}
